/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import org.lobobrowser.primary.gui.AbstractItemEditor;
import org.lobobrowser.primary.gui.ItemEditorFactory;
import org.lobobrowser.primary.gui.ValidationException;

public class ItemEditorDialog<T>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JLabel captionLabel = new JLabel();
    private final JButton okButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final AbstractItemEditor<T> editor;
    private T resultingItem;

    public ItemEditorDialog(Dialog owner, ItemEditorFactory<T> factory) throws HeadlessException {
        super(owner);
        this.editor = factory.createItemEditor();
        this.init();
    }

    public ItemEditorDialog(Frame owner, ItemEditorFactory<T> factory) throws HeadlessException {
        super(owner);
        this.editor = factory.createItemEditor();
        this.init();
    }

    private void init() {
        this.captionLabel.setPreferredSize(new Dimension(Short.MAX_VALUE, 32));
        this.captionLabel.setAlignmentX(0.0f);
        this.captionLabel.setBorder(new EmptyBorder(8, 0, 8, 0));
        this.okButton.setAction(new OkAction());
        this.okButton.setText("OK");
        this.cancelButton.setAction(new CancelAction());
        this.cancelButton.setText("Cancel");
        Box rootBox = new Box(1);
        rootBox.setBorder(new EmptyBorder(4, 4, 4, 4));
        rootBox.add(this.captionLabel);
        rootBox.add(this.editor);
        rootBox.add(this.createButtonPanel());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(rootBox);
    }

    public void setCaption(String caption) {
        this.captionLabel.setText(caption);
    }

    public void setItem(T item) {
        this.editor.setItem(item);
    }

    private Component createButtonPanel() {
        Box panel = new Box(0);
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add(Box.createGlue());
        panel.add(this.okButton);
        panel.add(Box.createRigidArea(new Dimension(4, 1)));
        panel.add(this.cancelButton);
        panel.add(Box.createGlue());
        return panel;
    }

    public T getResultingItem() {
        return this.resultingItem;
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemEditorDialog.this.resultingItem = null;
            ItemEditorDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ItemEditorDialog.this.editor.validateItem();
            }
            catch (ValidationException ve) {
                JOptionPane.showMessageDialog(ItemEditorDialog.this, ve.getMessage());
                return;
            }
            ItemEditorDialog.this.resultingItem = ItemEditorDialog.this.editor.getItem();
            ItemEditorDialog.this.dispose();
        }
    }
}

