/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.lobobrowser.primary.gui.FieldType;

public class FormField {
    public final FieldType type;
    private JLabel label;
    private JComponent fieldEditor;

    public FormField(FieldType type) {
        this(FieldType.TEXT, "");
    }

    public FormField(FieldType type, String caption) {
        this(type, caption, true);
    }

    public FormField(FieldType type, String caption, boolean editable) {
        this.type = type;
        this.setCaption(caption);
        this.setEditable(editable);
    }

    public FormField(FieldType type, boolean editable) {
        this.type = type;
        this.setEditable(editable);
    }

    public String getCaption() {
        return this.getLabel().getText();
    }

    public boolean isEditable() {
        JComponent fe = this.getFieldEditor();
        if (fe instanceof JTextComponent) {
            return ((JTextComponent)fe).isEditable();
        }
        return false;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getValue() {
        JComponent fe = this.getFieldEditor();
        if (fe instanceof JTextComponent) {
            return ((JTextComponent)fe).getText();
        }
        return null;
    }

    public void setValue(String value) {
        JComponent fe = this.getFieldEditor();
        if (fe instanceof JTextComponent) {
            ((JTextComponent)fe).setText(value);
        }
    }

    public String getToolTip() {
        return this.getFieldEditor().getToolTipText();
    }

    public void setToolTip(String tooltip) {
        this.getFieldEditor().setToolTipText(tooltip);
    }

    public void setEditable(boolean editable) {
        JComponent fe = this.getFieldEditor();
        if (fe instanceof JTextComponent) {
            ((JTextComponent)fe).setEditable(editable);
        }
    }

    public void setCaption(String caption) {
        this.getLabel().setText(caption);
    }

    public JLabel getLabel() {
        JLabel label = this.label;
        if (label != null) {
            return label;
        }
        this.label = label = new JLabel();
        return label;
    }

    public JComponent getFieldEditor() {
        JComponent fe = this.fieldEditor;
        if (fe != null) {
            return fe;
        }
        switch (this.type) {
            case TEXT: {
                JTextField textField = new JTextField();
                fe = textField;
                break;
            }
            case PASSWORD: {
                JPasswordField pwdField = new JPasswordField();
                pwdField.setEchoChar('*');
                fe = pwdField;
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + (Object)((Object)this.type));
            }
        }
        this.fieldEditor = fe;
        return fe;
    }
}

