/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lobobrowser.primary.gui.SwingTasks;

public class CheckBoxPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox checkBox;
    private final JComponent subPanel;

    public CheckBoxPanel(String text, JComponent subPanel) {
        this.subPanel = subPanel;
        this.setLayout(new BoxLayout(this, 1));
        this.checkBox = new JCheckBox();
        this.checkBox.setAlignmentX(0.0f);
        this.checkBox.setAction(new CheckBoxAction());
        this.checkBox.setText(text);
        JPanel checkBoxArea = new JPanel();
        checkBoxArea.setLayout(new BoxLayout(checkBoxArea, 0));
        checkBoxArea.add(this.checkBox);
        checkBoxArea.add(SwingTasks.createHorizontalFill());
        this.add(checkBoxArea);
        this.add(subPanel);
        SwingTasks.setNestedEnabled(subPanel, this.checkBox.isSelected());
    }

    public void updateEnabling() {
        SwingTasks.setNestedEnabled(this.subPanel, this.checkBox.isSelected());
    }

    public void setText(String text) {
        this.checkBox.setText(text);
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public class CheckBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingTasks.setNestedEnabled(CheckBoxPanel.this.subPanel, CheckBoxPanel.this.checkBox.isSelected());
        }
    }
}

