/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import org.lobobrowser.ua.ProgressType;

public class ProgressBar
extends JProgressBar {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProgressBar.class.getName());

    public ProgressBar() {
        this.setStringPainted(true);
    }

    public void updateProgress(ProgressType progressType, int value, int max) {
        switch (progressType) {
            case NONE: 
            case DONE: {
                this.setString("");
                this.setIndeterminate(false);
                this.setValue(0);
                this.setMaximum(0);
                break;
            }
            default: {
                if (max == -1) {
                    this.setIndeterminate(true);
                    this.setString(ProgressBar.getSizeText(value));
                    break;
                }
                this.setIndeterminate(false);
                this.setValue(value);
                this.setMaximum(max);
                if (max == 0) {
                    this.setString("");
                    break;
                }
                this.setString(value * 100 / max + "%");
            }
        }
    }

    private static double round1(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    private static String getSizeText(int numBytes) {
        if (numBytes == 0) {
            return "";
        }
        if (numBytes < 1024) {
            return numBytes + " bytes";
        }
        double numK = (double)numBytes / 1024.0;
        if (numK < 1024.0) {
            return ProgressBar.round1(numK) + " Kb";
        }
        double numM = numK / 1024.0;
        if (numM < 1024.0) {
            return ProgressBar.round1(numM) + " Mb";
        }
        double numG = numM / 1024.0;
        return ProgressBar.round1(numG) + " Gb";
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(64, 18);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(128, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(128, 18);
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (Exception err) {
            logger.log(Level.SEVERE, "paintComponent(): Swing bug?", err);
        }
    }
}

