/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.primary.ext.BaseHistory;
import org.lobobrowser.store.StorageManager;

public class NavigationHistory
extends BaseHistory<Object>
implements Serializable {
    private static final long serialVersionUID = 2257845000600200100L;
    private static final Logger logger = Logger.getLogger(NavigationHistory.class.getName());
    private static final NavigationHistory instance;

    private NavigationHistory() {
    }

    public static NavigationHistory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        NavigationHistory navigationHistory = this;
        synchronized (navigationHistory) {
            try {
                StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Unable to save settings: " + this.getClass().getSimpleName(), ioe);
            }
        }
    }

    static {
        NavigationHistory ins = null;
        try {
            ins = (NavigationHistory)StorageManager.getInstance().retrieveSettings(NavigationHistory.class.getSimpleName(), NavigationHistory.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new NavigationHistory();
        }
        instance = ins;
    }
}

