/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import org.lobobrowser.gui.ConsoleModel;
import org.lobobrowser.primary.action.AboutAction;
import org.lobobrowser.primary.action.AddBookmarkAction;
import org.lobobrowser.primary.action.BackAction;
import org.lobobrowser.primary.action.BackMoreAction;
import org.lobobrowser.primary.action.BlankWindowAction;
import org.lobobrowser.primary.action.ClearCacheAction;
import org.lobobrowser.primary.action.ClonedWindowAction;
import org.lobobrowser.primary.action.ConsoleAction;
import org.lobobrowser.primary.action.CopyAction;
import org.lobobrowser.primary.action.ExitAction;
import org.lobobrowser.primary.action.ForwardAction;
import org.lobobrowser.primary.action.ForwardMoreAction;
import org.lobobrowser.primary.action.GoAction;
import org.lobobrowser.primary.action.OpenFileAction;
import org.lobobrowser.primary.action.PreferencesAction;
import org.lobobrowser.primary.action.RecentHostsAction;
import org.lobobrowser.primary.action.ReloadAction;
import org.lobobrowser.primary.action.SaveFileAction;
import org.lobobrowser.primary.action.SearchAction;
import org.lobobrowser.primary.action.SearchBookmarksAction;
import org.lobobrowser.primary.action.ShowBookmarksAction;
import org.lobobrowser.primary.action.SourceAction;
import org.lobobrowser.primary.action.StopAction;
import org.lobobrowser.primary.ext.ActionPool;
import org.lobobrowser.primary.ext.AddressField;
import org.lobobrowser.primary.ext.BookmarkInfo;
import org.lobobrowser.primary.ext.BookmarksHistory;
import org.lobobrowser.primary.ext.ExtensionImpl;
import org.lobobrowser.primary.ext.HistoryEntry;
import org.lobobrowser.primary.ext.HostEntry;
import org.lobobrowser.primary.ext.IconFactory;
import org.lobobrowser.primary.ext.MenuAdapter;
import org.lobobrowser.primary.ext.NavigationHistory;
import org.lobobrowser.primary.ext.ProgressBar;
import org.lobobrowser.primary.ext.SearchPageSource;
import org.lobobrowser.primary.ext.TextViewerWindow;
import org.lobobrowser.primary.settings.SearchEngine;
import org.lobobrowser.primary.settings.ToolsSettings;
import org.lobobrowser.request.ClientletRequestHandler;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.ua.NavigatorWindowEvent;
import org.lobobrowser.ua.NavigatorWindowListener;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.util.Timing;

public class ComponentSource
implements NavigatorWindowListener {
    private static final Logger logger = Logger.getLogger(ComponentSource.class.getName());
    private static final int PREFERRED_MAX_MENU_SIZE = 20;
    private final NavigatorWindow window;
    private final AddressField addressField;
    private final JLabel statusMessageComponent;
    private final ProgressBar progressBar;
    private final JMenu recentBookmarksMenu;
    private final JMenu taggedBookmarksMenu;
    private final JMenu backMoreMenu;
    private final JMenu forwardMoreMenu;
    private final JMenu recentHostsMenu;
    private final JMenu searchersMenu;
    private final JButton searchButton;
    private final ActionPool actionPool;
    private final SearchPageSource searchPageSource;
    private String defaultStatusMessage;
    private String statusMessage;

    public ComponentSource(NavigatorWindow window) {
        JMenu taggedBookmarksMenu;
        JMenu bookmarksMenu;
        this.actionPool = new ActionPool(this, window);
        this.searchPageSource = new SearchPageSource(this.actionPool);
        this.window = window;
        this.addressField = new AddressField(this);
        this.progressBar = new ProgressBar();
        this.statusMessageComponent = new JLabel();
        this.searchButton = this.getSearchButton();
        this.updateSearchButtonTooltip();
        this.recentBookmarksMenu = bookmarksMenu = new JMenu("Recent Bookmarks");
        bookmarksMenu.setMnemonic('R');
        bookmarksMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                ComponentSource.this.populateRecentBookmarks();
            }
        });
        this.taggedBookmarksMenu = taggedBookmarksMenu = new JMenu("Tagged Bookmarks");
        taggedBookmarksMenu.setMnemonic('T');
        taggedBookmarksMenu.setToolTipText("Shows up to 20 tags with up to 20 recent bookmarks each.");
        taggedBookmarksMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                ComponentSource.this.populateTaggedBookmarks();
            }
        });
        JMenu backMoreMenu = new JMenu();
        backMoreMenu.setAction(new BackMoreAction(this, window, this.actionPool));
        backMoreMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                ComponentSource.this.populateBackMore();
            }
        });
        this.backMoreMenu = backMoreMenu;
        backMoreMenu.setText("Back To");
        JMenu forwardMoreMenu = new JMenu();
        forwardMoreMenu.setAction(new ForwardMoreAction(this, window, this.actionPool));
        forwardMoreMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                ComponentSource.this.populateForwardMore();
            }
        });
        this.forwardMoreMenu = forwardMoreMenu;
        forwardMoreMenu.setText("Forward To");
        JMenu recentHostsMenu = new JMenu();
        recentHostsMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                ComponentSource.this.populateRecentHosts();
            }
        });
        this.recentHostsMenu = recentHostsMenu;
        recentHostsMenu.setAction(new RecentHostsAction(this, window, this.actionPool));
        recentHostsMenu.setText("Recent Hosts");
        JMenu searchersMenu = new JMenu();
        searchersMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                ComponentSource.this.populateSearchers();
            }
        });
        this.searchersMenu = searchersMenu;
        searchersMenu.setText("Searching With");
        searchersMenu.setToolTipText("Select the search engine that is used by the Search button in the address bar.");
    }

    public Component[] getAddressBarComponents() {
        return new Component[]{this.getBackButton(), this.window.createGap(), this.getForwardButton(), this.window.createGap(), this.getStopButton(), this.window.createGap(), this.getRefreshButton(), this.window.createGap(), this.window.createGlueComponent(this.addressField, true), this.window.createGap(), this.getGoButton(), this.window.createGap(), this.searchButton, this.window.createGap()};
    }

    public Component[] getStatusBarComponents() {
        return new Component[]{this.window.createGap(), this.getStatusMessageComponent(), this.window.createGap(), this.getProgressBar(), this.window.createGap()};
    }

    public JMenu getFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menu.add(ComponentSource.menuItem("Save As", 'S', "ctrl S", (Action)new SaveFileAction(this, this.window)));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("Blank Window", 'B', KeyStroke.getKeyStroke(66, 3), (Action)new BlankWindowAction(this, this.window)));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("Cloned Window", 'C', new ClonedWindowAction(this, this.window, this.actionPool)));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("File...", 'F', "ctrl O", (Action)new OpenFileAction(this, this.window)));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("Close", 'C', new ExitAction(this, this.window)));
        return menu;
    }

    public JMenu getEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menu.add(ComponentSource.menuItem("Copy", 'C', "ctrl C", (Action)new CopyAction(this, this.window, this.actionPool)));
        return menu;
    }

    public JMenu getViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic('V');
        menu.add(ComponentSource.menuItem("Page Source", 'S', new SourceAction(this, this.window, this.actionPool)));
        menu.add(ComponentSource.menuItem("Console", 'C', new ConsoleAction(this, this.window)));
        menu.add(this.recentHostsMenu);
        menu.add(this.searchPageSource.getSearchMenu());
        return menu;
    }

    public JMenu getBookmarksMenu() {
        JMenu menu = new JMenu("Bookmarks");
        menu.setMnemonic('B');
        menu.add(ComponentSource.menuItem("Add Bookmark", 'A', "ctrl shift a", (Action)new AddBookmarkAction(this, this.window)));
        menu.add(this.recentBookmarksMenu);
        menu.add(this.taggedBookmarksMenu);
        menu.add(ComponentSource.menuItem("Search Bookmarks", 'S', new SearchBookmarksAction(this, this.window)));
        menu.add(ComponentSource.menuItem("Show All Bookmarks", 'S', new ShowBookmarksAction(this, this.window)));
        return menu;
    }

    public JMenu getNavigationMenu() {
        JMenu menu = new JMenu("Navigation");
        menu.setMnemonic('N');
        menu.add(ComponentSource.menuItem("Back", 'B', "ctrl B", (Action)new BackAction(this, this.window, this.actionPool)));
        menu.add(ComponentSource.menuItem("Forward", 'F', new ForwardAction(this, this.window, this.actionPool)));
        menu.add(ComponentSource.menuItem("Stop", 'S', KeyStroke.getKeyStroke(27, 0), (Action)new StopAction(this, this.window)));
        menu.add(ComponentSource.menuItem("Reload", 'R', KeyStroke.getKeyStroke(116, 0), (Action)new ReloadAction(this, this.window, this.actionPool)));
        menu.addSeparator();
        menu.add(this.backMoreMenu);
        menu.add(this.forwardMoreMenu);
        return menu;
    }

    public JMenu getToolsMenu() {
        JMenu menu = new JMenu("Tools");
        menu.setMnemonic('T');
        menu.add(this.searchersMenu);
        menu.add(ComponentSource.menuItem("Preferences...", 'P', new PreferencesAction(this, this.window)));
        menu.add(ComponentSource.menuItem("Clear Cache", 'M', "ctrl M", (Action)new ClearCacheAction(this, this.window)));
        return menu;
    }

    public JMenu getPageServicesMenu() {
        JMenu menu = new JMenu("Page Services");
        menu.setMnemonic('P');
        menu.add(ComponentSource.menuItem("Java", this.actionPool.createNavigateAction("http://www.java.com")));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("Eclipse", this.actionPool.createNavigateAction("http://www.eclipse.org/")));
        menu.addSeparator();
        return menu;
    }

    public JMenu getHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic('H');
        menu.add(ComponentSource.menuItem("About Lobo", 'A', new AboutAction(this, this.window)));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("Project Home Page", this.actionPool.createNavigateAction("http://sourceforge.net/projects/loboevolution/")));
        menu.addSeparator();
        menu.add(ComponentSource.menuItem("Wiki", this.actionPool.createNavigateAction("http://sourceforge.net/p/loboevolution/wiki/Home/")));
        menu.add(ComponentSource.menuItem("Discussion Forum", this.actionPool.createNavigateAction("http://sourceforge.net/p/loboevolution/discussion/")));
        return menu;
    }

    private Component getBackButton() {
        JButton button = new JButton();
        button.setAction(new BackAction(this, this.window, this.actionPool));
        button.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/navigation/Back16.gif"));
        button.setToolTipText("Back");
        return button;
    }

    private Component getForwardButton() {
        JButton button = new JButton();
        button.setAction(new ForwardAction(this, this.window, this.actionPool));
        button.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/navigation/Forward16.gif"));
        button.setToolTipText("Forward");
        return button;
    }

    private Component getStopButton() {
        JButton button = new JButton();
        button.setAction(new StopAction(this, this.window));
        button.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Stop16.gif"));
        button.setToolTipText("Stop");
        return button;
    }

    private Component getRefreshButton() {
        JButton button = new JButton();
        button.setAction(new ReloadAction(this, this.window, this.actionPool));
        button.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Refresh16.gif"));
        button.setToolTipText("Refresh");
        return button;
    }

    private Component getGoButton() {
        JButton button = new JButton();
        button.setAction(new GoAction(this, this.window));
        button.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/media/Play16.gif"));
        button.setToolTipText("Navigate to URL");
        return button;
    }

    private JButton getSearchButton() {
        JButton button = new JButton();
        button.setAction(new SearchAction(this, this.window));
        button.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Search16.gif"));
        return button;
    }

    private void updateSearchButtonTooltip() {
        JButton button = this.searchButton;
        ToolsSettings settings = ToolsSettings.getInstance();
        SearchEngine currentEngine = settings.getSelectedSearchEngine();
        String name = currentEngine == null ? "[none]" : currentEngine.getName();
        button.setToolTipText("<html><body>Current search engine: " + name + ".</body></html>");
    }

    private Component getStatusMessageComponent() {
        return this.window.createGlueComponent(this.statusMessageComponent, true);
    }

    private Component getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void defaultStatusUpdated(NavigatorWindowEvent event) {
        String defaultStatus = event.getMessage();
        this.defaultStatusMessage = event.getMessage();
        if (this.statusMessage == null) {
            this.statusMessageComponent.setText(defaultStatus);
        }
    }

    private boolean isHistoryRequest(RequestType requestType) {
        return requestType == RequestType.ADDRESS_BAR || requestType == RequestType.CLICK;
    }

    @Override
    public void documentAccessed(NavigatorWindowEvent event) {
        URL url = event.getUrl();
        if ("GET".equals(event.getMethod()) && this.isHistoryRequest(event.getRequestType())) {
            NavigationHistory.getInstance().addAsRecent(url, null);
        }
    }

    @Override
    public void documentRendering(NavigatorWindowEvent event) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("documentRendering(): event=" + event);
        }
        if (this.window.getTopFrame() == event.getNavigatorFrame()) {
            URL url = event.getUrl();
            this.addressField.setUrl(url);
            this.clearState();
            this.actionPool.updateEnabling();
        }
    }

    public void setNavigationEntry(NavigationEntry entry) {
        if (entry != null) {
            if (this.window.getTopFrame() == entry.getNavigatorFrame()) {
                URL url = entry.getUrl();
                this.addressField.setUrl(url);
                this.clearState();
                this.actionPool.updateEnabling();
            }
        } else {
            this.clearState();
            this.addressField.setUrl(null);
            this.actionPool.updateEnabling();
        }
    }

    private void clearState() {
        this.statusMessage = null;
        this.defaultStatusMessage = null;
        this.statusMessageComponent.setText("");
    }

    @Override
    public void progressUpdated(NavigatorProgressEvent event) {
        if (this.window.getTopFrame() == event.getNavigatorFrame()) {
            this.progressBar.updateProgress(event.getProgressType(), event.getCurrentValue(), event.getMaxValue());
        }
        this.statusMessageComponent.setText(ClientletRequestHandler.getProgressMessage(event.getProgressType(), event.getUrl()));
    }

    @Override
    public void statusUpdated(NavigatorWindowEvent event) {
        String status;
        this.statusMessage = status = event.getMessage();
        this.statusMessageComponent.setText(status == null ? this.defaultStatusMessage : status);
    }

    public Collection<String> getPotentialMatches(String urlPrefix, int max) {
        int colonIdx = urlPrefix.indexOf(58);
        String prefix = colonIdx == -1 ? "http://" + urlPrefix : (colonIdx == 1 ? "file://" + urlPrefix : urlPrefix);
        Collection<String> headMatches = NavigationHistory.getInstance().getHeadMatchItems(prefix, max);
        if (headMatches.isEmpty() && colonIdx == -1 && !urlPrefix.startsWith("www")) {
            prefix = "http://www." + urlPrefix;
            headMatches = NavigationHistory.getInstance().getHeadMatchItems(prefix, max);
        }
        return headMatches;
    }

    public Collection<String> getRecentLocations(int max) {
        return NavigationHistory.getInstance().getRecentItems(max);
    }

    public void navigate(String roughLocation, RequestType requestType) {
        try {
            this.window.stop();
            this.clearState();
            this.window.getTopFrame().navigate(roughLocation, requestType);
        }
        catch (MalformedURLException mfu) {
            ExtensionImpl.showError(this.window.getTopFrame(), null, new MalformedURLException(roughLocation));
        }
    }

    public void navigate(URL url) {
        this.window.stop();
        this.clearState();
        this.window.getTopFrame().navigate(url);
    }

    static JMenuItem menuItem(String title, Action action) {
        return ComponentSource.menuItem(title, '\u0000', (KeyStroke)null, action);
    }

    static JMenuItem menuItem(String title, char mnemonic, Action action) {
        return ComponentSource.menuItem(title, mnemonic, (KeyStroke)null, action);
    }

    static JMenuItem menuItem(String title, char mnemonic, KeyStroke accelerator, Action action) {
        JMenuItem item = new JMenuItem();
        item.setAction(action);
        item.setText(title);
        if (mnemonic != '\u0000') {
            item.setMnemonic(mnemonic);
        }
        if (accelerator != null) {
            item.setAccelerator(accelerator);
        }
        return item;
    }

    static JMenuItem menuItem(String title, char mnemonic, String accelerator, Action action) {
        KeyStroke keyStroke = accelerator == null ? null : KeyStroke.getKeyStroke(accelerator);
        return ComponentSource.menuItem(title, mnemonic, keyStroke, action);
    }

    public void populateRecentBookmarks() {
        JMenu bookmarksMenu = this.recentBookmarksMenu;
        bookmarksMenu.removeAll();
        Collection historyEntries = BookmarksHistory.getInstance().getRecentEntries(20);
        for (HistoryEntry hentry : historyEntries) {
            BookmarkInfo binfo = (BookmarkInfo)hentry.getItemInfo();
            String text = binfo.getTitle();
            URL url = binfo.getUrl();
            String urlText = url.toExternalForm();
            if (text == null || text.length() == 0) {
                text = urlText;
            }
            long elapsed = System.currentTimeMillis() - hentry.getTimetstamp();
            text = text + " (" + Timing.getElapsedText(elapsed) + " ago)";
            Action action = this.actionPool.createBookmarkNavigateAction(url);
            JMenuItem menuItem = ComponentSource.menuItem(text, action);
            StringBuffer toolTipText = new StringBuffer();
            toolTipText.append("<html>");
            toolTipText.append(urlText);
            String description = binfo.getDescription();
            if (description != null && description.length() != 0) {
                toolTipText.append("<br>");
                toolTipText.append(description);
            }
            menuItem.setToolTipText(toolTipText.toString());
            bookmarksMenu.add(menuItem);
        }
    }

    public void populateTaggedBookmarks() {
        JMenu bookmarksMenu = this.taggedBookmarksMenu;
        bookmarksMenu.removeAll();
        Collection bookmarkInfoList = BookmarksHistory.getInstance().getRecentItemInfo(400);
        HashMap<String, JMenu> tagMenus = new HashMap<String, JMenu>();
        for (BookmarkInfo binfo : bookmarkInfoList) {
            URL url = binfo.getUrl();
            String urlText = url.toExternalForm();
            String[] tags = binfo.getTags();
            if (tags == null) continue;
            for (String tag : tags) {
                JMenu tagMenu = (JMenu)tagMenus.get(tag);
                if (tagMenu == null && tagMenus.size() < 20) {
                    tagMenu = new JMenu(tag);
                    tagMenus.put(tag, tagMenu);
                    bookmarksMenu.add(tagMenu);
                }
                if (tagMenu == null || tagMenu.getItemCount() >= 20) continue;
                String text = binfo.getTitle();
                if (text == null || text.length() == 0) {
                    text = urlText;
                }
                Action action = this.actionPool.createBookmarkNavigateAction(url);
                JMenuItem menuItem = ComponentSource.menuItem(text, action);
                StringBuffer toolTipText = new StringBuffer();
                toolTipText.append("<html>");
                toolTipText.append(urlText);
                String description = binfo.getDescription();
                if (description != null && description.length() != 0) {
                    toolTipText.append("<br>");
                    toolTipText.append(description);
                }
                menuItem.setToolTipText(toolTipText.toString());
                tagMenu.add(menuItem);
            }
        }
    }

    public void populateBackMore() {
        NavigationEntry[] entries = this.window.getBackNavigationEntries();
        JMenu backMoreMenu = this.backMoreMenu;
        backMoreMenu.removeAll();
        for (NavigationEntry entry : entries) {
            String method = entry.getMethod();
            if (!"GET".equals(method)) continue;
            String title = entry.getTitle();
            URL url = entry.getUrl();
            String text = title == null || title.length() == 0 ? url.toExternalForm() : title;
            Action action = this.actionPool.createGoToAction(entry);
            JMenuItem menuItem = ComponentSource.menuItem(text, action);
            menuItem.setToolTipText(url.toExternalForm());
            backMoreMenu.add(menuItem);
        }
    }

    public void populateForwardMore() {
        NavigationEntry[] entries = this.window.getForwardNavigationEntries();
        JMenu forwardMoreMenu = this.forwardMoreMenu;
        forwardMoreMenu.removeAll();
        for (NavigationEntry entry : entries) {
            String method = entry.getMethod();
            if (!"GET".equals(method)) continue;
            String title = entry.getTitle();
            URL url = entry.getUrl();
            String text = title == null || title.length() == 0 ? url.toExternalForm() : title;
            Action action = this.actionPool.createGoToAction(entry);
            JMenuItem menuItem = ComponentSource.menuItem(text, action);
            menuItem.setToolTipText(url.toExternalForm());
            forwardMoreMenu.add(menuItem);
        }
    }

    public boolean hasRecentEntries() {
        return NavigationHistory.getInstance().hasRecentEntries();
    }

    public void populateRecentHosts() {
        JMenu recentHostsMenu = this.recentHostsMenu;
        recentHostsMenu.removeAll();
        Collection<HostEntry> hostEntries = NavigationHistory.getInstance().getRecentHostEntries(20);
        for (HostEntry entry : hostEntries) {
            String urlText = "http://" + entry.host;
            try {
                URL url = new URL(urlText);
                long elapsed = System.currentTimeMillis() - entry.timestamp;
                String menuText = entry.host + " (" + Timing.getElapsedText(elapsed) + " ago)";
                Action action = this.actionPool.createNavigateAction(url);
                JMenuItem menuItem = ComponentSource.menuItem(menuText, action);
                menuItem.setToolTipText(url.toExternalForm());
                recentHostsMenu.add(menuItem);
            }
            catch (MalformedURLException mfu) {
                logger.log(Level.WARNING, "populateRecentHosts(): Bad URL=" + urlText, mfu);
            }
        }
    }

    public void showSource() {
        String sourceCode = this.window.getTopFrame().getSourceCode();
        if (sourceCode == null) {
            sourceCode = "";
        }
        TextViewerWindow textViewer = new TextViewerWindow(this.window);
        textViewer.setText(sourceCode);
        textViewer.setSize(new Dimension(600, 400));
        textViewer.setLocationByPlatform(true);
        textViewer.setVisible(true);
    }

    public void showConsole() {
        TextViewerWindow textViewer = new TextViewerWindow(this.window);
        textViewer.setScrollsOnAppends(true);
        textViewer.setSwingDocument(ConsoleModel.getStandard());
        textViewer.setSize(new Dimension(600, 400));
        textViewer.setLocationByPlatform(true);
        textViewer.setVisible(true);
    }

    public void go() {
        this.navigateOrSearch();
    }

    public void navigateOrSearch() {
        String addressText = this.addressField.getText();
        if (addressText.indexOf(46) == -1 && addressText.indexOf(47) == -1 && addressText.indexOf(58) == -1) {
            this.search();
        } else {
            this.navigate(addressText, RequestType.ADDRESS_BAR);
        }
    }

    public void search() {
        ToolsSettings settings = ToolsSettings.getInstance();
        SearchEngine searchEngine = settings.getSelectedSearchEngine();
        if (searchEngine != null) {
            try {
                this.navigate(searchEngine.getURL(this.getAddressBarText()));
            }
            catch (MalformedURLException mfu) {
                this.window.getTopFrame().alert("Malformed search URL.");
            }
        }
    }

    private void populateSearchers() {
        JMenu searchersMenu = this.searchersMenu;
        searchersMenu.removeAll();
        final ToolsSettings settings = ToolsSettings.getInstance();
        Collection<SearchEngine> searchEngines = settings.getSearchEngines();
        SearchEngine selectedEngine = settings.getSelectedSearchEngine();
        if (searchEngines != null) {
            Iterator<SearchEngine> iterator = searchEngines.iterator();
            while (iterator.hasNext()) {
                SearchEngine se;
                final SearchEngine finalSe = se = iterator.next();
                JRadioButtonMenuItem item = new JRadioButtonMenuItem();
                item.setAction(new AbstractAction(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        settings.setSelectedSearchEngine(finalSe);
                        settings.save();
                        ComponentSource.this.updateSearchButtonTooltip();
                    }
                });
                item.setSelected(se == selectedEngine);
                item.setText(se.getName());
                item.setToolTipText(se.getDescription());
                searchersMenu.add(item);
            }
        }
    }

    public String getAddressBarText() {
        return this.addressField.getText();
    }
}

