/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.net.URL;
import java.security.Policy;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.primary.clientlets.html.HttpRequestImpl;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.security.LocalSecurityPolicy;
import org.lobobrowser.ua.NavigatorFrame;

public class UserAgentContextImpl
implements UserAgentContext {
    private static final Logger logger = Logger.getLogger(UserAgentContextImpl.class.getName());
    private static final Set<String> mediaNames;
    private final NavigatorFrame frame;

    public UserAgentContextImpl(NavigatorFrame frame) {
        this.frame = frame;
    }

    @Override
    public boolean isMedia(String mediaName) {
        return mediaNames.contains(mediaName.toLowerCase());
    }

    public void warn(String message, Throwable throwable) {
        logger.log(Level.WARNING, message, throwable);
    }

    public void error(String message, Throwable throwable) {
        logger.log(Level.SEVERE, message, throwable);
    }

    public void warn(String message) {
        logger.warning(message);
    }

    public void error(String message) {
        logger.log(Level.SEVERE, message);
    }

    @Override
    public HttpRequest createHttpRequest() {
        return new HttpRequestImpl(this.frame.createNetworkRequest());
    }

    @Override
    public String getAppCodeName() {
        return UserAgentImpl.getInstance().getName();
    }

    @Override
    public String getAppMinorVersion() {
        return UserAgentImpl.getInstance().getMinorVersion();
    }

    @Override
    public String getAppName() {
        return UserAgentImpl.getInstance().getName();
    }

    @Override
    public String getAppVersion() {
        return UserAgentImpl.getInstance().getMajorVersion();
    }

    @Override
    public String getBrowserLanguage() {
        return "EN";
    }

    @Override
    public String getPlatform() {
        return System.getProperty("os.name");
    }

    @Override
    public String getUserAgent() {
        return UserAgentImpl.getInstance().getUserAgentString();
    }

    @Override
    public boolean isCookieEnabled() {
        return true;
    }

    @Override
    public String getCookie(URL url) {
        return RequestEngine.getInstance().getCookie(url);
    }

    @Override
    public boolean isScriptingEnabled() {
        return true;
    }

    @Override
    public void setCookie(URL url, String cookieSpec) {
        RequestEngine.getInstance().setCookie(url, cookieSpec);
    }

    @Override
    public Policy getSecurityPolicy() {
        return LocalSecurityPolicy.getInstance();
    }

    @Override
    public int getScriptingOptimizationLevel() {
        return -1;
    }

    @Override
    public String getVendor() {
        return "The Lobo Project";
    }

    @Override
    public String getProduct() {
        return this.getAppName();
    }

    @Override
    public boolean isExternalCSSEnabled() {
        return true;
    }

    @Override
    public boolean isInternalCSSEnabled() {
        return true;
    }

    static {
        Set<String> mn = mediaNames = new HashSet<String>();
        mn.add("screen");
        mn.add("tv");
        mn.add("tty");
        mn.add("all");
    }
}

