/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.action;

import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.lobobrowser.primary.ext.ActionPool;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.ua.NavigatorWindow;

public class SaveFileAction
extends ActionPool {
    private static final Logger logger = Logger.getLogger(SaveFileAction.class.getName());
    private NavigatorWindow window;
    private static final long serialVersionUID = 1L;

    public SaveFileAction(ComponentSource componentSource, NavigatorWindow window) {
        super(componentSource, window);
        this.window = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        FileNameExtensionFilter filterHtml = new FileNameExtensionFilter("Hyper Text Markup Language", ".html");
        FileNameExtensionFilter filterTxt = new FileNameExtensionFilter("Text", ".txt");
        fileChooser.setFileFilter(filterHtml);
        fileChooser.setFileFilter(filterTxt);
        fileChooser.setAcceptAllFileFilterUsed(true);
        int returnValue = fileChooser.showSaveDialog(this.window.getTopFrame().getComponent());
        if (returnValue == 0) {
            int response;
            File selectedFile = this.getSelectedFileWithExtension(fileChooser);
            if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                return;
            }
            String source = this.window.getTopFrame().getSourceCode();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(source.getBytes());
                FileOutputStream ops = new FileOutputStream(selectedFile);
                baos.writeTo(ops);
                baos.flush();
            }
            catch (IOException e1) {
                logger.severe(e1.getMessage());
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e1) {
                    logger.severe(e1.getMessage());
                }
            }
        }
    }

    private File getSelectedFileWithExtension(JFileChooser c) {
        File file = c.getSelectedFile();
        if (c.getFileFilter() instanceof FileNameExtensionFilter) {
            String[] exts = ((FileNameExtensionFilter)c.getFileFilter()).getExtensions();
            String nameLower = file.getName().toLowerCase();
            for (String ext : exts) {
                if (!nameLower.endsWith('.' + ext.toLowerCase())) continue;
                return file;
            }
            file = new File(file.toString() + exts[0]);
        }
        return file;
    }
}

