/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.main;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.main.Extension;
import org.lobobrowser.main.PlatformInit;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.ua.NavigationEvent;
import org.lobobrowser.ua.NavigationVetoException;
import org.lobobrowser.ua.NavigatorEventType;
import org.lobobrowser.ua.NavigatorExceptionEvent;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.util.CollectionUtilities;
import org.lobobrowser.util.JoinableTask;

public class ExtensionManager {
    private static final Logger logger = Logger.getLogger(ExtensionManager.class.getName());
    private static final ExtensionManager instance = new ExtensionManager();
    private static final String EXT_DIR_NAME = "ext";
    private final Map<String, Extension> extensionById = new HashMap<String, Extension>();
    private final SortedSet<Extension> extensions = new TreeSet<Extension>();
    private final ArrayList<Extension> libraries = new ArrayList();

    private ExtensionManager() {
        this.createExtensions();
    }

    public static ExtensionManager getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    private void createExtensions() {
        File[] extFiles;
        File[] extDirs;
        String extDirsProperty = System.getProperty("ext.dirs");
        if (extDirsProperty == null) {
            File appDir = PlatformInit.getInstance().getApplicationDirectory();
            extDirs = new File[]{new File(appDir, EXT_DIR_NAME)};
        } else {
            StringTokenizer tok = new StringTokenizer(extDirsProperty, ",");
            ArrayList<File> extDirsList = new ArrayList<File>();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                extDirsList.add(new File(token.trim()));
            }
            extDirs = extDirsList.toArray(new File[0]);
        }
        String extFilesProperty = System.getProperty("ext.files");
        if (extFilesProperty == null) {
            extFiles = new File[]{};
        } else {
            StringTokenizer tok = new StringTokenizer(extFilesProperty, ",");
            ArrayList<File> extFilesList = new ArrayList<File>();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                extFilesList.add(new File(token.trim()));
            }
            extFiles = extFilesList.toArray(new File[0]);
        }
        this.createExtensions(extDirs, extFiles);
    }

    private void addExtension(File file) throws IOException {
        if (!file.exists()) {
            logger.warning("addExtension(): File " + file + " does not exist.");
            return;
        }
        Extension ei = new Extension(file);
        this.extensionById.put(ei.getId(), ei);
        if (ei.isLibraryOnly()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("createExtensions(): Loaded library (no lobo-extension.properties): " + ei);
            }
            this.libraries.add(ei);
        } else {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("createExtensions(): Loaded extension: " + ei);
            }
            this.extensions.add(ei);
        }
    }

    private void createExtensions(File[] extDirs, File[] extFiles) {
        SortedSet<Extension> extensions = this.extensions;
        ArrayList<Extension> libraries = this.libraries;
        Map<String, Extension> extensionById = this.extensionById;
        extensions.clear();
        libraries.clear();
        extensionById.clear();
        for (File extDir : extDirs) {
            if (!extDir.exists()) {
                logger.warning("createExtensions(): Directory '" + extDir + "' not found.");
                if (!PlatformInit.getInstance().isCodeLocationDirectory()) continue;
                logger.warning("createExtensions(): The application code location is a directory, which means the application is probably being run from an IDE. Additional setup is required. Please refer to README.txt file.");
                continue;
            }
            File[] extRoots = extDir.listFiles(new ExtFileFilter());
            if (extRoots == null || extRoots.length == 0) {
                logger.warning("createExtensions(): No potential extensions found in " + extDir + " directory.");
                continue;
            }
            for (File file : extRoots) {
                try {
                    this.addExtension(file);
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "createExtensions(): Unable to load '" + file + "'.", ioe);
                }
            }
        }
        for (File file : extFiles) {
            try {
                this.addExtension(file);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "createExtensions(): Unable to load '" + file + "'.", ioe);
            }
        }
        if (this.extensionById.size() == 0) {
            logger.warning("createExtensions(): No extensions found. This is indicative of a setup error. Extension directories scanned are: " + Arrays.asList(extDirs) + ".");
        }
        ClassLoader rootClassLoader = this.getClass().getClassLoader();
        ArrayList<URL> libraryURLCollection = new ArrayList<URL>();
        for (Extension ei : libraries) {
            try {
                libraryURLCollection.add(ei.getCodeSource());
            }
            catch (MalformedURLException thrown) {
                logger.log(Level.SEVERE, "createExtensions()", thrown);
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("createExtensions(): Creating library class loader with URLs=[" + libraryURLCollection + "].");
        }
        URLClassLoader librariesCL = new URLClassLoader(libraryURLCollection.toArray(new URL[0]), rootClassLoader);
        ArrayList<1> tasks = new ArrayList<1>();
        PlatformInit pm = PlatformInit.getInstance();
        for (Extension extension : extensions) {
            final URLClassLoader pcl = librariesCL;
            final Extension fei = extension;
            JoinableTask task = new JoinableTask(){

                @Override
                public void execute() {
                    try {
                        fei.initClassLoader(pcl);
                    }
                    catch (Exception err) {
                        logger.log(Level.WARNING, "Unable to create class loader for " + fei + ".", err);
                    }
                }

                public String toString() {
                    return "createExtensions:" + fei;
                }
            };
            tasks.add(task);
            pm.scheduleTask(task);
        }
        for (JoinableTask joinableTask : tasks) {
            try {
                joinableTask.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ClassLoader getClassLoader(String extensionId) {
        Extension ei = this.extensionById.get(extensionId);
        if (ei != null) {
            return ei.getClassLoader();
        }
        return null;
    }

    public void initExtensions() {
        ArrayList<2> tasks = new ArrayList<2>();
        PlatformInit pm = PlatformInit.getInstance();
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            Extension extension;
            final Extension fei = extension = (Extension)iterator.next();
            JoinableTask task = new JoinableTask(){

                @Override
                public void execute() {
                    fei.initExtension();
                }

                public String toString() {
                    return "initExtensions:" + fei;
                }
            };
            tasks.add(task);
            pm.scheduleTask(task);
        }
        for (JoinableTask joinableTask : tasks) {
            try {
                joinableTask.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void initExtensionsWindow(NavigatorWindow context) {
        for (Extension ei : this.extensions) {
            try {
                ei.initExtensionWindow(context);
            }
            catch (Exception err) {
                logger.log(Level.SEVERE, "initExtensionsWindow(): Extension could not properly initialize a new window.", err);
            }
        }
    }

    public void shutdownExtensionsWindow(NavigatorWindow context) {
        for (Extension ei : this.extensions) {
            try {
                ei.shutdownExtensionWindow(context);
            }
            catch (Exception err) {
                logger.log(Level.SEVERE, "initExtensionsWindow(): Extension could not properly process window shutdown.", err);
            }
        }
    }

    public Clientlet getClientlet(ClientletRequest request, ClientletResponse response) {
        Clientlet clientlet;
        SortedSet<Extension> extensions = this.extensions;
        for (Extension ei : extensions) {
            try {
                clientlet = ei.getClientlet(request, response);
                if (clientlet == null) continue;
                return clientlet;
            }
            catch (Exception thrown) {
                logger.log(Level.SEVERE, "getClientlet(): Extension " + ei + " threw exception.", thrown);
            }
        }
        for (Extension ei : CollectionUtilities.reverse(extensions)) {
            try {
                clientlet = ei.getLastResortClientlet(request, response);
                if (clientlet == null) continue;
                return clientlet;
            }
            catch (Exception thrown) {
                logger.log(Level.SEVERE, "getClientlet(): Extension " + ei + " threw exception.", thrown);
            }
        }
        return null;
    }

    public void handleError(NavigatorFrame frame, final ClientletResponse response, final Throwable exception) {
        final NavigatorExceptionEvent event = new NavigatorExceptionEvent((Object)this, NavigatorEventType.ERROR_OCCURRED, frame, response, exception);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SortedSet ext = ExtensionManager.this.extensions;
                boolean dispatched = false;
                for (Extension ei : ext) {
                    if (!ei.handleError(event)) continue;
                    dispatched = true;
                }
                if (!dispatched && logger.isLoggable(Level.INFO)) {
                    logger.log(Level.WARNING, "No error handlers found for error that occurred while processing response=[" + response + "].", exception);
                }
            }
        });
    }

    public void dispatchBeforeNavigate(NavigationEvent event) throws NavigationVetoException {
        for (Extension ei : this.extensions) {
            try {
                ei.dispatchBeforeLocalNavigate(event);
            }
            catch (NavigationVetoException nve) {
                throw nve;
            }
            catch (Exception other) {
                logger.log(Level.SEVERE, "dispatchBeforeNavigate(): Extension threw an unexpected exception.", other);
            }
        }
    }

    public void dispatchBeforeLocalNavigate(NavigationEvent event) throws NavigationVetoException {
        for (Extension ei : this.extensions) {
            try {
                ei.dispatchBeforeLocalNavigate(event);
            }
            catch (NavigationVetoException nve) {
                throw nve;
            }
            catch (Exception other) {
                logger.log(Level.SEVERE, "dispatchBeforeLocalNavigate(): Extension threw an unexpected exception.", other);
            }
        }
    }

    public void dispatchBeforeWindowOpen(NavigationEvent event) throws NavigationVetoException {
        for (Extension ei : this.extensions) {
            try {
                ei.dispatchBeforeWindowOpen(event);
            }
            catch (NavigationVetoException nve) {
                throw nve;
            }
            catch (Exception other) {
                logger.log(Level.SEVERE, "dispatchBeforeWindowOpen(): Extension threw an unexpected exception.", other);
            }
        }
    }

    public URLConnection dispatchPreConnection(URLConnection connection) {
        for (Extension ei : this.extensions) {
            try {
                connection = ei.dispatchPreConnection(connection);
            }
            catch (Exception other) {
                logger.log(Level.SEVERE, "dispatchPreConnection(): Extension threw an unexpected exception.", other);
            }
        }
        return connection;
    }

    public URLConnection dispatchPostConnection(URLConnection connection) {
        for (Extension ei : this.extensions) {
            try {
                connection = ei.dispatchPostConnection(connection);
            }
            catch (Exception other) {
                logger.log(Level.SEVERE, "dispatchPostConnection(): Extension threw an unexpected exception.", other);
            }
        }
        return connection;
    }

    private static class ExtFileFilter
    implements FileFilter {
        private ExtFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar");
        }
    }
}

