/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderstate;

import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderstate.DisplayRenderState;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.w3c.dom.Node;

public class TableCaptionRenderState
extends DisplayRenderState {
    private int alignXPercent = -1;

    public TableCaptionRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element, 7);
    }

    @Override
    public int getAlignXPercent() {
        int axp = this.alignXPercent;
        if (axp != -1) {
            return axp;
        }
        this.alignXPercent = axp = this.getAlignXPercent(this.element);
        return axp;
    }

    public int getAlignXPercent(HTMLElementImpl htmlElement) {
        Node parent;
        int axp = 50;
        String textAlign = null;
        AbstractCSS2Properties props = htmlElement.getCurrentStyle();
        if (props != null) {
            textAlign = props.getTextAlign();
        }
        if ("center".equalsIgnoreCase(textAlign)) {
            axp = 50;
        } else if ("left".equalsIgnoreCase(textAlign)) {
            axp = 0;
        } else if ("right".equalsIgnoreCase(textAlign)) {
            axp = 100;
        } else if ("inherit".equalsIgnoreCase(textAlign) && (parent = htmlElement.getParentNode()) instanceof HTMLElementImpl) {
            return this.getAlignXPercent((HTMLElementImpl)parent);
        }
        return axp;
    }
}

