/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlLayoutMapping;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.control.HrControl;
import org.lobobrowser.html.control.RUIControl;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.info.FloatingInfo;
import org.lobobrowser.html.layout.MiscLayout;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.ExportableFloat;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingViewportBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.LineBreak;
import org.lobobrowser.html.renderer.MarkupLayout;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.ParentFloatingBoundsSource;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RFloatInfo;
import org.lobobrowser.html.renderer.RInlineBlock;
import org.lobobrowser.html.renderer.RLine;
import org.lobobrowser.html.renderer.RList;
import org.lobobrowser.html.renderer.RListItem;
import org.lobobrowser.html.renderer.RRelative;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RTable;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Range;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.renderer.ZIndexComparator;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.util.ArrayUtilities;

public class RBlockViewport
extends BaseRCollection {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Logger logger = Logger.getLogger(RBlockViewport.class.getName());
    public final RenderableContainer container;
    public final int listNesting;
    public final UserAgentContext userAgentContext;
    public final HtmlRendererContext rendererContext;
    public final FrameContext frameContext;
    private SortedSet<PositionedRenderable> positionedRenderables;
    private ArrayList<RLine> seqRenderables = null;
    private ArrayList<ExportableFloat> exportableFloats = null;
    private RLine currentLine;
    private int maxX;
    private int maxY;
    private int desiredWidth;
    private int desiredHeight;
    private int availContentHeight;
    private int availContentWidth;
    private int yLimit;
    private int positionedOrdinal;
    private int currentCollapsibleMargin;
    private Insets paddingInsets;
    private boolean overrideNoWrap;
    private FloatingBounds floatBounds = null;
    private boolean sizeOnly;
    private BoundableRenderable lastSeqBlock;
    private static final Map<String, Object> elementLayout = HtmlLayoutMapping.layout();
    private static final MarkupLayout miscLayout = new MiscLayout();
    private static final SizeExceededException SEE = new SizeExceededException();
    private BoundableRenderable armedRenderable;
    private Collection<RFloatInfo> pendingFloats = null;
    private Boolean isFloatLimit = null;

    public RBlockViewport(ModelNode modelNode, RenderableContainer container, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RCollection parent) {
        super(container, modelNode);
        this.parent = parent;
        this.userAgentContext = pcontext;
        this.rendererContext = rcontext;
        this.frameContext = frameContext;
        this.container = container;
        this.listNesting = listNesting;
        this.layoutUpTreeCanBeInvalidated = true;
    }

    @Override
    public void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public int getAvailContentWidth() {
        return this.availContentWidth;
    }

    private int initCollapsibleMargin() {
        RCollection parent = this.parent;
        if (!(parent instanceof RBlock)) {
            return 0;
        }
        RBlock parentBlock = (RBlock)parent;
        return parentBlock.getCollapsibleMarginTop();
    }

    public void layout(int desiredWidth, int desiredHeight, Insets paddingInsets, int yLimit, FloatingBounds floatBounds, boolean sizeOnly) {
        SortedSet<PositionedRenderable> posRenderables;
        int maxY;
        int availh;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("layout(): Invoked outside GUI dispatch thread.");
        }
        RenderableContainer container = this.container;
        this.paddingInsets = paddingInsets;
        this.yLimit = yLimit;
        this.desiredHeight = desiredHeight;
        this.desiredWidth = desiredWidth;
        this.floatBounds = floatBounds;
        this.isFloatLimit = null;
        this.pendingFloats = null;
        this.sizeOnly = sizeOnly;
        this.lastSeqBlock = null;
        this.currentCollapsibleMargin = this.initCollapsibleMargin();
        this.maxX = paddingInsets.left;
        this.maxY = paddingInsets.top;
        int availw = desiredWidth - paddingInsets.left - paddingInsets.right;
        if (availw < 0) {
            availw = 0;
        }
        if ((availh = desiredHeight - paddingInsets.top - paddingInsets.bottom) == 0) {
            availh = 0;
        }
        this.availContentHeight = availh;
        this.availContentWidth = availw;
        this.layoutPass((DOMNodeImpl)this.modelNode);
        Collection delayedPairs = container.getDelayedPairs();
        if (delayedPairs != null && delayedPairs.size() > 0) {
            for (DelayedPair pair : delayedPairs) {
                if (pair.targetParent != container) continue;
                this.importDelayedPair(pair);
            }
        }
        int maxYWholeBlock = maxY = this.maxY;
        BoundableRenderable lastSeqBlock = this.lastSeqBlock;
        if (lastSeqBlock != null) {
            int effBlockHeight = this.getEffectiveBlockHeight(lastSeqBlock);
            if (lastSeqBlock.getY() + effBlockHeight > maxY) {
                this.maxY = maxY = lastSeqBlock.getY() + effBlockHeight;
                maxYWholeBlock = lastSeqBlock.getY() + lastSeqBlock.getHeight();
            }
        }
        RLine lastLine = this.currentLine;
        Rectangle lastBounds = lastLine.getBounds();
        if (lastBounds.height > 0 || lastBounds.y > maxYWholeBlock) {
            int lastTopY;
            int lastTopX = lastBounds.x + lastBounds.width;
            if (lastTopX > this.maxX) {
                this.maxX = lastTopX;
            }
            if ((lastTopY = lastBounds.y + lastBounds.height) > maxY) {
                this.maxY = maxY = lastTopY;
            }
        }
        if ((posRenderables = this.positionedRenderables) != null) {
            boolean isFloatLimit = this.isFloatLimit();
            for (PositionedRenderable pr : posRenderables) {
                BoundableRenderable br = pr.renderable;
                if (br.getX() + br.getWidth() > this.maxX) {
                    this.maxX = br.getX() + br.getWidth();
                }
                if (!isFloatLimit && pr.isFloat || br.getY() + br.getHeight() <= maxY) continue;
                this.maxY = maxY = br.getY() + br.getHeight();
            }
        }
        this.width = paddingInsets.right + this.maxX;
        this.height = paddingInsets.bottom + maxY;
    }

    private void layoutPass(DOMNodeImpl rootNode) {
        RenderableContainer container = this.container;
        container.clearDelayedPairs();
        this.positionedOrdinal = 0;
        this.seqRenderables = null;
        this.positionedRenderables = null;
        this.exportableFloats = null;
        this.currentLine = this.addLine(rootNode, null, this.paddingInsets.top);
        this.layoutChildren(rootNode);
        this.lineDone(this.currentLine);
    }

    public void alignX(int alignXPercent, int canvasWidth, Insets paddingInsets) {
        ArrayList<RLine> renderables;
        int prevMaxY = this.maxY;
        if (alignXPercent > 0 && (renderables = this.seqRenderables) != null) {
            Insets insets = this.paddingInsets;
            int numRenderables = renderables.size();
            int yoffset = 0;
            for (int i = 0; i < numRenderables; ++i) {
                int rightOffset;
                boolean isVisibleBlock;
                int leftOffset;
                int actualAvailWidth;
                int difference;
                int newY;
                RLine r = renderables.get(i);
                if (!(r instanceof BoundableRenderable)) continue;
                BoundableRenderable seqRenderable = r;
                int y = seqRenderable.getY();
                if (yoffset > 0) {
                    newY = y + yoffset;
                    seqRenderable.setY(newY);
                    if (newY + seqRenderable.getHeight() > this.maxY) {
                        this.maxY = newY + seqRenderable.getHeight();
                    }
                } else {
                    newY = y;
                }
                if ((difference = (actualAvailWidth = canvasWidth - (leftOffset = (isVisibleBlock = seqRenderable instanceof RBlock && ((RBlock)seqRenderable).isOverflowVisibleX()) ? insets.left : this.fetchLeftOffset(y)) - (rightOffset = isVisibleBlock ? insets.right : this.fetchRightOffset(y))) - seqRenderable.getWidth()) <= 0) continue;
                int shift = difference * alignXPercent / 100;
                if (isVisibleBlock) continue;
                int newX = leftOffset + shift;
                seqRenderable.setX(newX);
            }
        }
        if (prevMaxY != this.maxY) {
            this.height += this.maxY - prevMaxY;
        }
    }

    public void alignY(int alignYPercent, int canvasHeight, Insets paddingInsets) {
        int usedHeight;
        int availContentHeight;
        int difference;
        int prevMaxY = this.maxY;
        if (alignYPercent > 0 && (difference = (availContentHeight = canvasHeight - paddingInsets.top - paddingInsets.bottom) - (usedHeight = this.maxY - paddingInsets.top)) > 0) {
            SortedSet<PositionedRenderable> others;
            int shift = difference * alignYPercent / 100;
            ArrayList<RLine> rlist = this.seqRenderables;
            if (rlist != null) {
                for (RLine r : rlist) {
                    if (!(r instanceof BoundableRenderable)) continue;
                    BoundableRenderable line = r;
                    int newY = line.getY() + shift;
                    line.setY(newY);
                    if (newY + line.getHeight() <= this.maxY) continue;
                    this.maxY = newY + line.getHeight();
                }
            }
            if ((others = this.positionedRenderables) != null) {
                for (PositionedRenderable pr : others) {
                    if (!pr.verticalAlignable) continue;
                    BoundableRenderable br = pr.renderable;
                    int newY = br.getY() + shift;
                    br.setY(newY);
                    if (newY + br.getHeight() <= this.maxY) continue;
                    this.maxY = newY + br.getHeight();
                }
            }
        }
        if (prevMaxY != this.maxY) {
            this.height += this.maxY - prevMaxY;
        }
    }

    private RLine addLine(ModelNode startNode, RLine prevLine, int newLineY) {
        boolean initialAllowOverflow;
        int leftOffset;
        this.lineDone(prevLine);
        this.checkY(newLineY);
        int newX = leftOffset = this.fetchLeftOffset(newLineY);
        int newMaxWidth = this.desiredWidth - this.fetchRightOffset(newLineY) - leftOffset;
        if (prevLine == null) {
            int textIndent;
            RenderState rs = this.modelNode.getRenderState();
            initialAllowOverflow = rs == null ? false : rs.getWhiteSpace() == 2;
            int n = textIndent = rs == null ? 0 : rs.getTextIndent(this.availContentWidth);
            if (textIndent != 0) {
                newMaxWidth += leftOffset - (newX += textIndent);
            }
        } else {
            int prevLineHeight = prevLine.getHeight();
            if (prevLineHeight > 0) {
                this.currentCollapsibleMargin = 0;
            }
            initialAllowOverflow = prevLine.isAllowOverflow();
            if (prevLine.x + prevLine.width > this.maxX) {
                this.maxX = prevLine.x + prevLine.width;
            }
        }
        RLine rline = new RLine(startNode, this.container, newX, newLineY, newMaxWidth, 0, initialAllowOverflow);
        rline.setParent(this);
        ArrayList<RLine> sr = this.seqRenderables;
        if (sr == null) {
            this.seqRenderables = sr = new ArrayList(1);
        }
        sr.add(rline);
        this.currentLine = rline;
        return rline;
    }

    public void layoutMarkup(DOMNodeImpl node) {
        RLine line;
        RenderState rs = node.getRenderState();
        Insets marginInsets = null;
        Insets paddingInsets = null;
        if (rs != null) {
            HtmlInsets mi = rs.getMarginInsets();
            marginInsets = mi == null ? null : mi.getSimpleAWTInsets(this.availContentWidth, this.availContentHeight);
            HtmlInsets pi = rs.getPaddingInsets();
            paddingInsets = pi == null ? null : pi.getSimpleAWTInsets(this.availContentWidth, this.availContentHeight);
        }
        int leftSpacing = 0;
        int rightSpacing = 0;
        if (marginInsets != null) {
            leftSpacing += marginInsets.left;
            rightSpacing += marginInsets.right;
        }
        if (paddingInsets != null) {
            leftSpacing += paddingInsets.left;
            rightSpacing += paddingInsets.right;
        }
        if (leftSpacing > 0) {
            line = this.currentLine;
            line.addSpacing(new RSpacing(node, this.container, leftSpacing, line.height));
        }
        this.layoutChildren(node);
        if (rightSpacing > 0) {
            line = this.currentLine;
            line.addSpacing(new RSpacing(node, this.container, rightSpacing, line.height));
        }
    }

    public void layoutChildren(DOMNodeImpl node) {
        DOMNodeImpl[] childrenArray = node.getChildrenArray();
        if (childrenArray != null) {
            for (DOMNodeImpl child : childrenArray) {
                short nodeType = child.getNodeType();
                if (nodeType == 3) {
                    this.layoutText(child);
                    continue;
                }
                if (nodeType == 1) {
                    this.currentLine.addStyleChanger(new RStyleChanger(child));
                    String nodeName = child.getNodeName().toUpperCase();
                    MarkupLayout ml = (MarkupLayout)elementLayout.get(nodeName);
                    if (ml == null) {
                        ml = miscLayout;
                    }
                    ml.layoutMarkup(this, (HTMLElementImpl)child);
                    this.currentLine.addStyleChanger(new RStyleChanger(node));
                    continue;
                }
                if (nodeType == 8 || nodeType == 7) continue;
                throw new IllegalStateException("Unknown node: " + child);
            }
        }
    }

    public final void positionRBlock(HTMLElementImpl markupElement, RBlock renderable) {
        if (!this.addElsewhereIfPositioned(renderable, markupElement, false, true, false)) {
            int availContentWidth;
            int availContentHeight = this.availContentHeight;
            RLine line = this.currentLine;
            this.lineDone(line);
            Insets paddingInsets = this.paddingInsets;
            int newLineY = line == null ? paddingInsets.top : line.y + line.height;
            int expectedWidth = availContentWidth = this.availContentWidth;
            int blockShiftRight = paddingInsets.right;
            int newX = paddingInsets.left;
            int newY = newLineY;
            FloatingBounds floatBounds = this.floatBounds;
            ParentFloatingBoundsSource floatBoundsSource = floatBounds == null ? null : new ParentFloatingBoundsSource(blockShiftRight, expectedWidth, newX, newY, floatBounds);
            renderable.layout(availContentWidth, availContentHeight, true, false, floatBoundsSource, this.sizeOnly);
            this.addAsSeqBlock(renderable, false, false, false, false);
            FloatingInfo floatingInfo = renderable.getExportableFloatingInfo();
            if (floatingInfo != null) {
                this.importFloatingInfo(floatingInfo, renderable);
            }
            this.addLineAfterBlock(renderable, false);
        }
    }

    public final void positionRElement(HTMLElementImpl markupElement, RElement renderable, boolean usesAlignAttribute, boolean obeysFloats, boolean alignCenterAttribute) {
        if (!this.addElsewhereIfPositioned(renderable, markupElement, usesAlignAttribute, true, true)) {
            int availContentWidth = this.availContentWidth;
            int availContentHeight = this.availContentHeight;
            RLine line = this.currentLine;
            this.lineDone(line);
            if (obeysFloats) {
                int newLineY = line == null ? this.paddingInsets.top : line.y + line.height;
                int leftOffset = this.fetchLeftOffset(newLineY);
                int rightOffset = this.fetchRightOffset(newLineY);
                availContentWidth = this.desiredWidth - leftOffset - rightOffset;
            }
            renderable.layout(availContentWidth, availContentHeight, this.sizeOnly);
            boolean centerBlock = false;
            if (alignCenterAttribute) {
                String align = markupElement.getAttribute("align");
                centerBlock = align != null && align.equalsIgnoreCase("center");
            }
            this.addAsSeqBlock(renderable, obeysFloats, false, true, centerBlock);
        }
    }

    public final void layoutRBlock(HTMLElementImpl markupElement) {
        RBlock renderable = (RBlock)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RBlock(markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(markupElement, renderable);
    }

    public final void layoutRTable(HTMLElementImpl markupElement) {
        RElement renderable = (RElement)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RTable(markupElement, this.userAgentContext, this.rendererContext, this.frameContext, this.container);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRElement(markupElement, renderable, markupElement instanceof HTMLTableElementImpl, true, true);
    }

    public final void layoutListItem(HTMLElementImpl markupElement) {
        RListItem renderable = (RListItem)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RListItem(markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(markupElement, renderable);
    }

    public final void layoutList(HTMLElementImpl markupElement) {
        RList renderable = (RList)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RList(markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(markupElement, renderable);
    }

    public void addLineBreak(ModelNode startNode, int breakType) {
        int newLineY;
        RLine line = this.currentLine;
        if (line == null) {
            Insets insets = this.paddingInsets;
            this.addLine(startNode, null, insets.top);
            line = this.currentLine;
        }
        if (line.getHeight() == 0) {
            RenderState rs = startNode.getRenderState();
            int fontHeight = rs.getFontMetrics().getHeight();
            line.setHeight(fontHeight);
        }
        line.setLineBreak(new LineBreak(breakType, startNode));
        FloatingBounds fb = this.floatBounds;
        if (breakType == 0 || fb == null) {
            newLineY = line == null ? this.paddingInsets.top : line.y + line.height;
        } else {
            int prevY = line == null ? this.paddingInsets.top : line.y + line.height;
            switch (breakType) {
                case 1: {
                    newLineY = fb.getLeftClearY(prevY);
                    break;
                }
                case 2: {
                    newLineY = fb.getRightClearY(prevY);
                    break;
                }
                default: {
                    newLineY = fb.getClearY(prevY);
                }
            }
        }
        this.currentLine = this.addLine(startNode, line, newLineY);
    }

    private boolean addElsewhereIfFloat(BoundableRenderable renderable, HTMLElementImpl element, boolean usesAlignAttribute, AbstractCSS2Properties style, boolean layout) {
        String align = null;
        if (style != null && (align = style.getFloat()) != null && align.length() == 0) {
            align = null;
        }
        if (align == null && usesAlignAttribute) {
            align = element.getAttribute("align");
        }
        if (align != null) {
            if ("left".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, layout, true);
                return true;
            }
            if ("right".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, layout, false);
                return true;
            }
        }
        return false;
    }

    final RBlockViewport getParentViewport() {
        RCollection parent;
        for (parent = this.getOriginalOrCurrentParent(); parent != null && !(parent instanceof RBlockViewport); parent = parent.getOriginalOrCurrentParent()) {
        }
        return (RBlockViewport)parent;
    }

    private static int getPosition(HTMLElementImpl element) {
        RenderState rs = element.getRenderState();
        return rs == null ? 0 : rs.getPosition();
    }

    private boolean addElsewhereIfPositioned(RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute, boolean layoutIfPositioned, boolean obeysFloats) {
        boolean relative;
        AbstractCSS2Properties style = element.getCurrentStyle();
        int position = RBlockViewport.getPosition(element);
        boolean absolute = position == 1;
        boolean bl = relative = position == 2;
        if (absolute || relative) {
            int newLeft;
            int lineBottomY;
            if (layoutIfPositioned) {
                if (renderable instanceof RBlock) {
                    RBlock block = (RBlock)renderable;
                    ParentFloatingBoundsSource inheritedFloatBoundsSource = null;
                    if (relative) {
                        Insets paddingInsets = this.paddingInsets;
                        RLine line = this.currentLine;
                        this.lineDone(line);
                        int newY = line == null ? paddingInsets.top : line.y + line.height;
                        int expectedWidth = this.availContentWidth;
                        int blockShiftRight = paddingInsets.right;
                        int newX = paddingInsets.left;
                        FloatingBounds floatBounds = this.floatBounds;
                        inheritedFloatBoundsSource = floatBounds == null ? null : new ParentFloatingBoundsSource(blockShiftRight, expectedWidth, newX, newY, floatBounds);
                    }
                    block.layout(this.availContentWidth, this.availContentHeight, false, false, inheritedFloatBoundsSource, this.sizeOnly);
                } else {
                    renderable.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
                }
            }
            RenderState rs = element.getRenderState();
            String leftText = style.getLeft();
            RLine line = this.currentLine;
            int n = lineBottomY = line == null ? 0 : line.getY() + line.getHeight();
            if (leftText != null) {
                newLeft = HtmlValues.getPixelSize(leftText, rs, 0, this.availContentWidth);
            } else {
                String rightText = style.getRight();
                if (rightText != null) {
                    int right = HtmlValues.getPixelSize(rightText, rs, 0, this.availContentWidth);
                    newLeft = this.desiredWidth - right - renderable.getWidth();
                } else {
                    newLeft = 0;
                }
            }
            int newTop = relative ? 0 : lineBottomY;
            String topText = style.getTop();
            if (topText != null) {
                newTop = HtmlValues.getPixelSize(topText, rs, newTop, this.availContentHeight);
            } else {
                String bottomText = style.getBottom();
                if (bottomText != null) {
                    int bottom = HtmlValues.getPixelSize(bottomText, rs, 0, this.availContentHeight);
                    newTop = this.desiredHeight - bottom - renderable.getHeight();
                    if (!relative && newTop < 0) {
                        newTop = 0;
                    }
                }
            }
            if (relative) {
                RRelative rrel = new RRelative(this.container, element, renderable, newLeft, newTop);
                rrel.assignDimension();
                if (!this.addElsewhereIfFloat(rrel, element, usesAlignAttribute, style, true)) {
                    boolean centerBlock = false;
                    if (renderable instanceof RTable) {
                        String align = element.getAttribute("align");
                        centerBlock = align != null && align.equalsIgnoreCase("center");
                    }
                    this.addAsSeqBlock(rrel, obeysFloats, true, true, centerBlock);
                    FloatingInfo floatingInfo = rrel.getExportableFloatingInfo();
                    if (floatingInfo != null) {
                        this.importFloatingInfo(floatingInfo, rrel);
                    }
                } else {
                    rrel.assignDimension();
                }
            } else {
                this.scheduleAbsDelayedPair(renderable, newLeft, newTop);
                return true;
            }
            int newBottomY = renderable.getY() + renderable.getHeight();
            this.checkY(newBottomY);
            if (newBottomY > this.maxY) {
                this.maxY = newBottomY;
            }
            return true;
        }
        return this.addElsewhereIfFloat(renderable, element, usesAlignAttribute, style, layoutIfPositioned);
    }

    public void addRenderableToLineCheckStyle(RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute) {
        if (this.addElsewhereIfPositioned(renderable, element, usesAlignAttribute, true, true)) {
            return;
        }
        renderable.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
        this.addRenderableToLine(renderable);
    }

    private void addRenderableToLine(Renderable renderable) {
        block4: {
            renderable.getModelNode().getRenderState();
            RLine line = this.currentLine;
            int liney = line.y;
            boolean emptyLine = line.isEmpty();
            FloatingBounds floatBounds = this.floatBounds;
            int cleary = floatBounds != null ? floatBounds.getFirstClearY(liney) : liney + line.height;
            try {
                line.add(renderable);
                if (floatBounds == null || cleary <= liney) break block4;
                int rightOffset = this.fetchRightOffset(liney);
                int topLineX = this.desiredWidth - rightOffset;
                if (line.getX() + line.getWidth() <= topLineX) break block4;
                line.setY(cleary);
            }
            catch (OverflowException oe) {
                int nextY = emptyLine ? cleary : liney + line.height;
                this.addLine(renderable.getModelNode(), line, nextY);
                Collection renderables = oe.getRenderables();
                for (Renderable r : renderables) {
                    this.addRenderableToLine(r);
                }
            }
        }
        if (renderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)renderable).widget.getComponent());
        }
    }

    private void addWordToLine(RWord renderable) {
        block3: {
            RLine line = this.currentLine;
            int liney = line.y;
            boolean emptyLine = line.isEmpty();
            FloatingBounds floatBounds = this.floatBounds;
            int cleary = floatBounds != null ? floatBounds.getFirstClearY(liney) : liney + line.height;
            try {
                line.addWord(renderable);
                if (floatBounds == null || cleary <= liney) break block3;
                int rightOffset = this.fetchRightOffset(liney);
                int topLineX = this.desiredWidth - rightOffset;
                if (line.getX() + line.getWidth() <= topLineX) break block3;
                line.setY(cleary);
            }
            catch (OverflowException oe) {
                int nextY = emptyLine ? cleary : liney + line.height;
                this.addLine(renderable.getModelNode(), line, nextY);
                Collection renderables = oe.getRenderables();
                for (Renderable r : renderables) {
                    this.addRenderableToLine(r);
                }
            }
        }
    }

    private void addAsSeqBlockCheckStyle(RElement block, HTMLElementImpl element, boolean usesAlignAttribute) {
        if (this.addElsewhereIfPositioned(block, element, usesAlignAttribute, false, true)) {
            return;
        }
        this.addAsSeqBlock(block);
    }

    private void addAsSeqBlock(RElement block) {
        this.addAsSeqBlock(block, true, true, true, false);
    }

    private int getNewBlockY(BoundableRenderable newBlock, int expectedY) {
        if (!(newBlock instanceof RElement)) {
            return expectedY;
        }
        RElement block = (RElement)newBlock;
        int ccm = this.currentCollapsibleMargin;
        int topMargin = block.getMarginTop();
        if (topMargin == 0 && ccm == 0) {
            return expectedY;
        }
        return expectedY - Math.min(topMargin, ccm);
    }

    private int getEffectiveBlockHeight(BoundableRenderable block) {
        if (!(block instanceof RElement)) {
            return block.getHeight();
        }
        RCollection parent = this.getParent();
        if (!(parent instanceof RElement)) {
            return block.getHeight();
        }
        int blockMarginBottom = ((RElement)block).getMarginBottom();
        int parentMarginBottom = ((RElement)parent).getCollapsibleMarginBottom();
        return block.getHeight() - Math.min(blockMarginBottom, parentMarginBottom);
    }

    private void addAsSeqBlock(BoundableRenderable block, boolean obeysFloats, boolean informLineDone, boolean addLine, boolean centerBlock) {
        int blockX;
        boolean initialAllowOverflow;
        RLine prevLine;
        Insets insets = this.paddingInsets;
        int insetsl = insets.left;
        ArrayList<RLine> sr = this.seqRenderables;
        if (sr == null) {
            sr = new ArrayList(1);
            this.seqRenderables = sr;
        }
        if ((prevLine = this.currentLine) != null) {
            initialAllowOverflow = prevLine.isAllowOverflow();
            if (informLineDone) {
                this.lineDone(prevLine);
            }
            if (prevLine.x + prevLine.width > this.maxX) {
                this.maxX = prevLine.x + prevLine.width;
            }
        } else {
            initialAllowOverflow = false;
        }
        int prevLineHeight = prevLine == null ? 0 : prevLine.height;
        int newLineY = prevLine == null ? insets.top : prevLine.y + prevLineHeight;
        int blockY = prevLineHeight == 0 ? this.getNewBlockY(block, newLineY) : newLineY;
        int blockWidth = block.getWidth();
        if (obeysFloats) {
            int roomX;
            int actualAvailWidth;
            FloatingBounds floatBounds = this.floatBounds;
            if (floatBounds != null) {
                int blockOffset;
                blockX = blockOffset = this.fetchLeftOffset(newLineY);
                int rightOffset = this.fetchRightOffset(newLineY);
                actualAvailWidth = this.desiredWidth - rightOffset - blockOffset;
                if (blockWidth > actualAvailWidth) {
                    blockY = floatBounds.getClearY(newLineY);
                }
            } else {
                actualAvailWidth = this.availContentWidth;
                blockX = insetsl;
            }
            if (centerBlock && (roomX = actualAvailWidth - blockWidth) > 0) {
                blockX += roomX / 2;
            }
        } else {
            blockX = insetsl;
        }
        block.setOrigin(blockX, blockY);
        sr.add((RLine)block);
        block.setParent(this);
        if (blockX + blockWidth > this.maxX) {
            this.maxX = blockX + blockWidth;
        }
        this.lastSeqBlock = block;
        int n = this.currentCollapsibleMargin = block instanceof RElement ? ((RElement)block).getMarginBottom() : 0;
        if (addLine) {
            int leftOffset;
            newLineY = blockY + block.getHeight();
            this.checkY(newLineY);
            int newX = leftOffset = this.fetchLeftOffset(newLineY);
            int newMaxWidth = this.desiredWidth - this.fetchRightOffset(newLineY) - leftOffset;
            ModelNode lineNode = block.getModelNode().getParentModelNode();
            RLine newLine = new RLine(lineNode, this.container, newX, newLineY, newMaxWidth, 0, initialAllowOverflow);
            newLine.setParent(this);
            sr.add(newLine);
            this.currentLine = newLine;
        }
    }

    private void addLineAfterBlock(RBlock block, boolean informLineDone) {
        int leftOffset;
        boolean initialAllowOverflow;
        RLine prevLine;
        ArrayList<RLine> sr = this.seqRenderables;
        if (sr == null) {
            sr = new ArrayList(1);
            this.seqRenderables = sr;
        }
        if ((prevLine = this.currentLine) != null) {
            initialAllowOverflow = prevLine.isAllowOverflow();
            if (informLineDone) {
                this.lineDone(prevLine);
            }
            if (prevLine.x + prevLine.width > this.maxX) {
                this.maxX = prevLine.x + prevLine.width;
            }
        } else {
            initialAllowOverflow = false;
        }
        ModelNode lineNode = block.getModelNode().getParentModelNode();
        int newLineY = block.getY() + block.getHeight();
        this.checkY(newLineY);
        int newX = leftOffset = this.fetchLeftOffset(newLineY);
        int newMaxWidth = this.desiredWidth - this.fetchRightOffset(newLineY) - leftOffset;
        RLine newLine = new RLine(lineNode, this.container, newX, newLineY, newMaxWidth, 0, initialAllowOverflow);
        newLine.setParent(this);
        sr.add(newLine);
        this.currentLine = newLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void layoutText(DOMNodeImpl textNode) {
        RenderState renderState = textNode.getRenderState();
        if (renderState == null) {
            throw new IllegalStateException("RenderState is null for node " + textNode + " with parent " + textNode.getParentNode());
        }
        FontMetrics fm = renderState.getFontMetrics();
        int descent = fm.getDescent();
        int ascentPlusLeading = fm.getAscent() + fm.getLeading();
        int wordHeight = fm.getHeight();
        int blankWidth = fm.charWidth(' ');
        int whiteSpace = this.overrideNoWrap ? 2 : renderState.getWhiteSpace();
        int textTransform = renderState.getTextTransform();
        String text = textNode.getNodeValue();
        if (whiteSpace != 1) {
            boolean prevAllowOverflow = this.currentLine.isAllowOverflow();
            boolean allowOverflow = whiteSpace == 2;
            this.currentLine.setAllowOverflow(allowOverflow);
            try {
                int length = text.length();
                boolean firstWord = true;
                StringBuffer word = new StringBuffer(12);
                block7: for (int i = 0; i < length; ++i) {
                    char ch = text.charAt(i);
                    if (Character.isWhitespace(ch)) {
                        int wlen;
                        if (firstWord) {
                            firstWord = false;
                        }
                        if ((wlen = word.length()) > 0) {
                            RWord rword = new RWord(textNode, word.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight, textTransform);
                            this.addWordToLine(rword);
                            word.delete(0, wlen);
                        }
                        RLine line = this.currentLine;
                        if (line.width > 0) {
                            RBlank rblank = new RBlank(textNode, fm, this.container, ascentPlusLeading, blankWidth, wordHeight);
                            line.addBlank(rblank);
                        }
                        ++i;
                        while (i < length) {
                            ch = text.charAt(i);
                            if (!Character.isWhitespace(ch)) {
                                word.append(ch);
                                continue block7;
                            }
                            ++i;
                        }
                        continue;
                    }
                    word.append(ch);
                }
                if (word.length() <= 0) return;
                RWord rword = new RWord(textNode, word.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight, textTransform);
                this.addWordToLine(rword);
                return;
            }
            finally {
                this.currentLine.setAllowOverflow(prevAllowOverflow);
            }
        }
        int length = text.length();
        boolean lastCharSlashR = false;
        StringBuffer line = new StringBuffer();
        block9: for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    lastCharSlashR = true;
                    continue block9;
                }
                case '\n': {
                    int llen = line.length();
                    if (llen > 0) {
                        RWord rword = new RWord(textNode, line.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight, textTransform);
                        this.addWordToLine(rword);
                        line.delete(0, line.length());
                    }
                    RLine prevLine = this.currentLine;
                    prevLine.setLineBreak(new LineBreak(0, textNode));
                    this.addLine(textNode, prevLine, prevLine.y + prevLine.height);
                    continue block9;
                }
                default: {
                    if (lastCharSlashR) {
                        line.append('\r');
                        lastCharSlashR = false;
                    }
                    line.append(ch);
                }
            }
        }
        if (line.length() <= 0) return;
        RWord rword = new RWord(textNode, line.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight, textTransform);
        this.addWordToLine(rword);
    }

    private void populateZIndexGroups(Collection others, Collection seqRenderables, ArrayList destination) {
        this.populateZIndexGroups(others, seqRenderables == null ? null : seqRenderables.iterator(), destination);
    }

    private void populateZIndexGroups(Collection others, Iterator seqRenderablesIterator, ArrayList destination) {
        Iterator i2;
        Iterator i1 = others.iterator();
        BoundableRenderable pending = null;
        while (i1.hasNext()) {
            PositionedRenderable pr = (PositionedRenderable)i1.next();
            BoundableRenderable r = pr.renderable;
            if (r.getZIndex() >= 0) {
                pending = r;
                break;
            }
            destination.add(r);
        }
        if ((i2 = seqRenderablesIterator) != null) {
            while (i2.hasNext()) {
                destination.add(i2.next());
            }
        }
        if (pending != null) {
            destination.add(pending);
            while (i1.hasNext()) {
                PositionedRenderable pr = (PositionedRenderable)i1.next();
                BoundableRenderable r = pr.renderable;
                destination.add(r);
            }
        }
    }

    public Renderable[] getRenderablesArray() {
        int othersSize;
        SortedSet<PositionedRenderable> others = this.positionedRenderables;
        int n = othersSize = others == null ? 0 : others.size();
        if (othersSize == 0) {
            ArrayList<RLine> sr = this.seqRenderables;
            return sr == null ? Renderable.EMPTY_ARRAY : sr.toArray(Renderable.EMPTY_ARRAY);
        }
        ArrayList allRenderables = new ArrayList();
        this.populateZIndexGroups(others, this.seqRenderables, allRenderables);
        return allRenderables.toArray(Renderable.EMPTY_ARRAY);
    }

    @Override
    public Iterator getRenderables() {
        SortedSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null || others.size() == 0) {
            ArrayList<RLine> sr = this.seqRenderables;
            return sr == null ? null : sr.iterator();
        }
        ArrayList allRenderables = new ArrayList();
        this.populateZIndexGroups(others, this.seqRenderables, allRenderables);
        return allRenderables.iterator();
    }

    public Iterator getRenderables(Rectangle clipBounds) {
        SortedSet<PositionedRenderable> others;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderables(): Invoked outside GUI dispatch thread.");
        }
        ArrayList<RLine> sr = this.seqRenderables;
        Iterator baseIterator = null;
        if (sr != null) {
            Object[] array = sr.toArray(Renderable.EMPTY_ARRAY);
            Range range = MarkupUtilities.findRenderables((Renderable[])array, clipBounds, true);
            baseIterator = ArrayUtilities.iterator(array, range.offset, range.length);
        }
        if ((others = this.positionedRenderables) == null || others.size() == 0) {
            return baseIterator;
        }
        ArrayList<PositionedRenderable> matches = new ArrayList<PositionedRenderable>();
        for (PositionedRenderable pr : others) {
            BoundableRenderable br;
            Rectangle rbounds;
            BoundableRenderable r = pr.renderable;
            if (!(r instanceof BoundableRenderable) || !clipBounds.intersects(rbounds = (br = r).getBounds())) continue;
            matches.add(pr);
        }
        if (matches.size() == 0) {
            return baseIterator;
        }
        ArrayList destination = new ArrayList();
        this.populateZIndexGroups(matches, baseIterator, destination);
        return destination.iterator();
    }

    @Override
    public BoundableRenderable getRenderable(int x, int y) {
        Iterator i = this.getRenderables(x, y);
        return i == null ? null : (i.hasNext() ? (BoundableRenderable)i.next() : null);
    }

    public BoundableRenderable getRenderable(Point point) {
        return this.getRenderable(point.x, point.y);
    }

    public Iterator getRenderables(Point point) {
        return this.getRenderables(point.x, point.y);
    }

    public Iterator getRenderables(int pointx, int pointy) {
        Renderable[] array;
        BoundableRenderable found;
        ArrayList<RLine> sr;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderable(): Invoked outside GUI dispatch thread.");
        }
        LinkedList<BoundableRenderable> result = null;
        SortedSet<PositionedRenderable> others = this.positionedRenderables;
        int size = others == null ? 0 : others.size();
        PositionedRenderable[] otherArray = size == 0 ? null : others.toArray(PositionedRenderable.EMPTY_ARRAY);
        int index = 0;
        if (size != 0) {
            int px = pointx;
            int py = pointy;
            index = size;
            while (--index >= 0) {
                BoundableRenderable br;
                Rectangle rbounds;
                PositionedRenderable pr = otherArray[index];
                BoundableRenderable r = pr.renderable;
                if (r.getZIndex() < 0) break;
                if (!(r instanceof BoundableRenderable) || !(rbounds = (br = r).getBounds()).contains(px, py)) continue;
                if (result == null) {
                    result = new LinkedList();
                }
                result.add(br);
            }
        }
        if ((sr = this.seqRenderables) != null && (found = MarkupUtilities.findRenderable(array = sr.toArray(Renderable.EMPTY_ARRAY), pointx, pointy, true)) != null) {
            if (result == null) {
                result = new LinkedList<BoundableRenderable>();
            }
            result.add(found);
        }
        if (size != 0) {
            int px = pointx;
            int py = pointy;
            while (index >= 0) {
                BoundableRenderable br;
                Rectangle rbounds;
                PositionedRenderable pr = otherArray[index];
                BoundableRenderable r = pr.renderable;
                if (r instanceof BoundableRenderable && (rbounds = (br = r).getBounds()).contains(px, py)) {
                    if (result == null) {
                        result = new LinkedList();
                    }
                    result.add(br);
                }
                --index;
            }
        }
        return result == null ? null : result.iterator();
    }

    private RElement setupNewUIControl(RenderableContainer container, HTMLElementImpl element, UIControl control) {
        RUIControl renderable = new RUIControl(element, control, container, this.frameContext, this.userAgentContext);
        element.setUINode(renderable);
        return renderable;
    }

    public final void addAlignableAsBlock(HTMLElementImpl markupElement, RElement renderable) {
        boolean regularAdd = false;
        String align = markupElement.getAttribute("align");
        if (align != null) {
            if ("left".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, false, true);
            } else if ("right".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, false, false);
            } else {
                regularAdd = true;
            }
        } else {
            regularAdd = true;
        }
        if (regularAdd) {
            this.addAsSeqBlock(renderable);
        }
    }

    public final void layoutHr(HTMLElementImpl markupElement) {
        RElement renderable = (RElement)markupElement.getUINode();
        if (renderable == null) {
            renderable = this.setupNewUIControl(this.container, markupElement, new HrControl(markupElement));
        }
        renderable.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
        this.addAlignableAsBlock(markupElement, renderable);
    }

    public final int fetchLeftOffset(int newLineY) {
        Insets paddingInsets = this.paddingInsets;
        FloatingBounds floatBounds = this.floatBounds;
        if (floatBounds == null) {
            return paddingInsets.left;
        }
        int left = floatBounds.getLeft(newLineY);
        if (left < paddingInsets.left) {
            return paddingInsets.left;
        }
        return left;
    }

    public final int fetchRightOffset(int newLineY) {
        Insets paddingInsets = this.paddingInsets;
        FloatingBounds floatBounds = this.floatBounds;
        if (floatBounds == null) {
            return paddingInsets.right;
        }
        int right = floatBounds.getRight(newLineY);
        if (right < paddingInsets.right) {
            return paddingInsets.right;
        }
        return right;
    }

    public final void checkY(int y) {
        if (this.yLimit != -1 && y > this.yLimit) {
            throw SEE;
        }
    }

    public final void layoutFloat(BoundableRenderable renderable, boolean layout, boolean leftFloat) {
        renderable.setOriginalParent(this);
        if (layout) {
            int availWidth = this.availContentWidth;
            int availHeight = this.availContentHeight;
            if (renderable instanceof RBlock) {
                RBlock block = (RBlock)renderable;
                block.layout(availWidth, availHeight, false, false, null, this.sizeOnly);
            } else if (renderable instanceof RElement) {
                RElement e = (RElement)renderable;
                e.layout(availWidth, availHeight, this.sizeOnly);
            }
        }
        RFloatInfo floatInfo = new RFloatInfo(renderable.getModelNode(), renderable, leftFloat);
        this.currentLine.simplyAdd(floatInfo);
        this.scheduleFloat(floatInfo);
    }

    private void scheduleAbsDelayedPair(BoundableRenderable renderable, int x, int y) {
        RenderableContainer newContainer;
        HTMLElementImpl element;
        int position;
        ModelNode node;
        RenderableContainer container = this.container;
        while (container instanceof Renderable && (node = ((Renderable)((Object)container)).getModelNode()) instanceof HTMLElementImpl && (position = RBlockViewport.getPosition(element = (HTMLElementImpl)node)) == 0 && (newContainer = container.getParentContainer()) != null) {
            container = newContainer;
        }
        DelayedPair pair = new DelayedPair(container, renderable, x, y);
        this.container.addDelayedPair(pair);
    }

    void importDelayedPair(DelayedPair pair) {
        BoundableRenderable r = pair.child;
        r.setOrigin(pair.x, pair.y);
        this.addPositionedRenderable(r, false, false);
    }

    public final void addPositionedRenderable(BoundableRenderable renderable, boolean verticalAlignable, boolean isFloat) {
        SortedSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null) {
            this.positionedRenderables = others = new TreeSet<Object>(new ZIndexComparator());
        }
        others.add(new PositionedRenderable(renderable, verticalAlignable, this.positionedOrdinal++, isFloat));
        renderable.setParent(this);
        if (renderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)renderable).widget.getComponent());
        }
    }

    public int getFirstLineHeight() {
        ArrayList<RLine> renderables = this.seqRenderables;
        if (renderables != null) {
            int size = renderables.size();
            if (size == 0) {
                return 0;
            }
            for (int i = 0; i < size; ++i) {
                BoundableRenderable br = renderables.get(0);
                int height = br.getHeight();
                if (height == 0) continue;
                return height;
            }
        }
        return 1;
    }

    public int getFirstBaselineOffset() {
        ArrayList<RLine> renderables = this.seqRenderables;
        if (renderables != null) {
            for (RLine r : renderables) {
                RBlock block;
                if (r instanceof RLine) {
                    int blo = r.getBaselineOffset();
                    if (blo == 0) continue;
                    return blo;
                }
                if (!(r instanceof RBlock) || (block = (RBlock)((Object)r)).getHeight() <= 0) continue;
                Insets insets = block.getInsets(false, false);
                Insets paddingInsets = this.paddingInsets;
                return block.getFirstBaselineOffset() + insets.top + (paddingInsets == null ? 0 : paddingInsets.top);
            }
        }
        return 0;
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        BoundableRenderable br = this.getRenderable(new Point(x, y));
        if (br != null) {
            return br.getLowestRenderableSpot(x - br.getX(), y - br.getY());
        }
        return new RenderableSpot(this, x, y);
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMouseClick(event, x - bounds.x, y - bounds.y)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onDoubleClick(event, x - bounds.x, y - bounds.y)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable br = this.armedRenderable;
        if (br != null) {
            try {
                boolean bl = br.onMouseDisarmed(event);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMousePressed(event, x - bounds.x, y - bounds.y)) continue;
                this.armedRenderable = br;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        BoundableRenderable oldArmedRenderable;
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMouseReleased(event, x - bounds.x, y - bounds.y)) continue;
                BoundableRenderable oldArmedRenderable2 = this.armedRenderable;
                if (oldArmedRenderable2 != null && br != oldArmedRenderable2) {
                    oldArmedRenderable2.onMouseDisarmed(event);
                    this.armedRenderable = null;
                }
                return false;
            }
        }
        if ((oldArmedRenderable = this.armedRenderable) != null) {
            oldArmedRenderable.onMouseDisarmed(event);
            this.armedRenderable = null;
        }
        return true;
    }

    @Override
    public boolean onKeyPressed(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyDown(KeyEvent event) {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        Iterator i = this.getRenderables(clipBounds);
        if (i != null) {
            while (i.hasNext()) {
                Object robj = i.next();
                if (robj instanceof BoundableRenderable) {
                    BoundableRenderable renderable = (BoundableRenderable)robj;
                    renderable.paintTranslated(g);
                    continue;
                }
                ((Renderable)robj).paint(g);
            }
        }
    }

    @Override
    public boolean isContainedByNode() {
        return false;
    }

    public String toString() {
        return "RBlockViewport[node=" + this.modelNode + "]";
    }

    private void scheduleFloat(RFloatInfo floatInfo) {
        RLine line = this.currentLine;
        if (line == null) {
            int y = line == null ? this.paddingInsets.top : line.getY();
            this.placeFloat(floatInfo.getRenderable(), y, floatInfo.isLeftFloat());
        } else if (line.getWidth() == 0) {
            int y = line.getY();
            this.placeFloat(floatInfo.getRenderable(), y, floatInfo.isLeftFloat());
            int leftOffset = this.fetchLeftOffset(y);
            int rightOffset = this.fetchRightOffset(y);
            line.changeLimits(leftOffset, this.desiredWidth - leftOffset - rightOffset);
        } else {
            Collection<RFloatInfo> c = this.pendingFloats;
            if (c == null) {
                this.pendingFloats = c = new LinkedList<RFloatInfo>();
            }
            c.add(floatInfo);
        }
    }

    private void lineDone(RLine line) {
        int yAfterLine = line == null ? this.paddingInsets.top : line.y + line.height;
        Collection<RFloatInfo> pfs = this.pendingFloats;
        if (pfs != null) {
            this.pendingFloats = null;
            for (RFloatInfo pf : pfs) {
                this.placeFloat(pf.getRenderable(), yAfterLine, pf.isLeftFloat());
            }
        }
    }

    private void addExportableFloat(BoundableRenderable element, boolean leftFloat, int origX, int origY) {
        ArrayList<ExportableFloat> ep = this.exportableFloats;
        if (ep == null) {
            this.exportableFloats = ep = new ArrayList(1);
        }
        ep.add(new ExportableFloat(element, leftFloat, origX, origY));
    }

    private void placeFloat(BoundableRenderable element, int y, boolean leftFloat) {
        int boxX;
        Insets insets = this.paddingInsets;
        int boxY = y;
        int boxWidth = element.getWidth();
        int boxHeight = element.getHeight();
        int desiredWidth = this.desiredWidth;
        while (true) {
            FloatingBounds fb;
            int newY;
            RBlock relement;
            int leftOffset = this.fetchLeftOffset(boxY);
            int rightOffset = this.fetchRightOffset(boxY);
            int n = boxX = leftFloat ? leftOffset : desiredWidth - rightOffset - boxWidth;
            if (leftOffset == insets.left && rightOffset == insets.right) {
                if (leftFloat || boxX >= leftOffset) break;
                boxX = leftOffset;
                break;
            }
            if (boxWidth <= desiredWidth - rightOffset - leftOffset) break;
            if (element instanceof RBlock && !(relement = (RBlock)element).hasDeclaredWidth()) {
                int availableBoxWidth = desiredWidth - rightOffset - leftOffset;
                relement.layout(availableBoxWidth, this.availContentHeight, this.sizeOnly);
                if (relement.getWidth() < boxWidth) {
                    if (relement.getWidth() > desiredWidth - rightOffset - leftOffset) {
                        relement.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
                    } else {
                        boxWidth = relement.getWidth();
                        boxHeight = relement.getHeight();
                        continue;
                    }
                }
            }
            int n2 = newY = (fb = this.floatBounds) == null ? boxY + boxHeight : fb.getFirstClearY(boxY);
            if (newY == boxY) break;
            boxY = newY;
        }
        element.setOrigin(boxX, boxY);
        int offsetFromBorder = leftFloat ? boxX + boxWidth : desiredWidth - boxX;
        this.floatBounds = new FloatingViewportBounds(this.floatBounds, leftFloat, boxY, offsetFromBorder, boxHeight);
        boolean isFloatLimit = this.isFloatLimit();
        if (isFloatLimit) {
            this.addPositionedRenderable(element, true, true);
        } else {
            this.addExportableFloat(element, leftFloat, boxX, boxY);
        }
        if (boxX + boxWidth > this.maxX) {
            this.maxX = boxX + boxWidth;
        }
        if (this.isFloatLimit() && boxY + boxHeight > this.maxY) {
            this.maxY = boxY + boxHeight;
        }
    }

    private boolean isFloatLimit() {
        Boolean fl = this.isFloatLimit;
        if (fl == null) {
            this.isFloatLimit = fl = this.isFloatLimitImpl();
        }
        return fl;
    }

    private Boolean isFloatLimitImpl() {
        int overflowY;
        int floatValue;
        RCollection parent = this.getOriginalOrCurrentParent();
        if (!(parent instanceof RBlock)) {
            return Boolean.TRUE;
        }
        RBlock blockParent = (RBlock)parent;
        RCollection grandParent = blockParent.getOriginalOrCurrentParent();
        if (!(grandParent instanceof RBlockViewport)) {
            return Boolean.TRUE;
        }
        ModelNode node = this.modelNode;
        if (!(node instanceof HTMLElementImpl)) {
            return Boolean.TRUE;
        }
        HTMLElementImpl element = (HTMLElementImpl)node;
        int position = RBlockViewport.getPosition(element);
        if (position == 1 || position == 3) {
            return Boolean.TRUE;
        }
        element.getCurrentStyle();
        RenderState rs = element.getRenderState();
        int n = floatValue = rs == null ? 0 : rs.getFloat();
        if (floatValue != 0) {
            return Boolean.TRUE;
        }
        int overflowX = rs == null ? 0 : rs.getOverflowX();
        int n2 = overflowY = rs == null ? 0 : rs.getOverflowY();
        if (overflowX == 2 || overflowX == 1 || overflowY == 2 || overflowY == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public FloatingInfo getExportableFloatingInfo() {
        ArrayList<ExportableFloat> ef = this.exportableFloats;
        if (ef == null) {
            return null;
        }
        ExportableFloat[] floats = ef.toArray(ExportableFloat.EMPTY_ARRAY);
        return new FloatingInfo(0, 0, floats);
    }

    private void importFloatingInfo(FloatingInfo floatingInfo, BoundableRenderable block) {
        int shiftX = floatingInfo.shiftX + block.getX();
        int shiftY = floatingInfo.shiftY + block.getY();
        for (ExportableFloat ef : floatingInfo.floats) {
            this.importFloat(ef, shiftX, shiftY);
        }
    }

    private void importFloat(ExportableFloat ef, int shiftX, int shiftY) {
        BoundableRenderable renderable = ef.element;
        int newX = ef.origX + shiftX;
        int newY = ef.origY + shiftY;
        renderable.setOrigin(newX, newY);
        FloatingBounds prevBounds = this.floatBounds;
        boolean leftFloat = ef.leftFloat;
        int offsetFromBorder = leftFloat ? newX + renderable.getWidth() : this.desiredWidth - newX;
        this.floatBounds = new FloatingViewportBounds(prevBounds, leftFloat, newY, offsetFromBorder, renderable.getHeight());
        if (this.isFloatLimit()) {
            this.addPositionedRenderable(renderable, true, true);
        } else {
            this.addExportableFloat(renderable, leftFloat, newX, newY);
        }
    }

    public void layoutRInlineBlock(HTMLElementImpl markupElement) {
        RInlineBlock inlineBlock = new RInlineBlock(this.container, markupElement, this.userAgentContext, this.rendererContext, this.frameContext);
        inlineBlock.doLayout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
        this.addRenderableToLine(inlineBlock);
    }

    public FrameContext getFrameContext() {
        return this.frameContext;
    }

    public RenderableContainer getContainer() {
        return this.container;
    }

    public UserAgentContext getUserAgentContext() {
        return this.userAgentContext;
    }

    public HtmlRendererContext getRendererContext() {
        return this.rendererContext;
    }
}

