/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollBar;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.info.FloatingInfo;
import org.lobobrowser.html.layout.LayoutValue;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.ShiftedFloatingBounds;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.renderstate.BlockRenderState;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.RenderThreadState;
import org.lobobrowser.util.Objects;

public class RBlock
extends BaseElementRenderable
implements RenderableContainer,
ImageObserver {
    protected static final Logger logger = Logger.getLogger(RBlock.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private static final int MAX_CACHE_SIZE = 10;
    protected final FrameContext frameContext;
    protected final int listNesting;
    protected final HtmlRendererContext rendererContext;
    protected final RBlockViewport bodyLayout;
    protected final Map<LayoutKey, LayoutValue> cachedLayout = new Hashtable<LayoutKey, LayoutValue>(5);
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected JScrollBar vScrollBar;
    protected JScrollBar hScrollBar;
    protected boolean hasHScrollBar = false;
    protected boolean hasVScrollBar = false;
    protected int defaultOverflowX = 0;
    protected int defaultOverflowY = 0;
    private LayoutValue lastLayoutValue = null;
    private LayoutKey lastLayoutKey = null;
    private boolean resettingScrollBars = false;
    private BoundableRenderable armedRenderable;

    public RBlock(DOMNodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer) {
        super(parentContainer, modelNode, pcontext);
        RBlockViewport bl;
        this.listNesting = listNesting;
        this.frameContext = frameContext;
        this.rendererContext = rcontext;
        this.bodyLayout = bl = new RBlockViewport(modelNode, this, this.getViewportListNesting(listNesting), pcontext, rcontext, frameContext, this);
        bl.setOriginalParent(this);
        bl.setX(Short.MAX_VALUE);
        bl.setY(Short.MAX_VALUE);
    }

    public int getVScrollBarWidth() {
        return 16;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public int getVAlign() {
        return 5;
    }

    public void ensureVisible(Point point) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            boolean hscroll = this.hasHScrollBar;
            boolean vscroll = this.hasVScrollBar;
            int origX = bodyLayout.x;
            int origY = bodyLayout.y;
            Insets insets = this.getInsets(hscroll, vscroll);
            if (hscroll) {
                if (point.x < insets.left) {
                    bodyLayout.x += insets.left - point.x;
                } else if (point.x > this.width - insets.right) {
                    bodyLayout.x -= point.x - this.width + insets.right;
                }
            }
            if (vscroll) {
                if (point.y < insets.top) {
                    bodyLayout.y += insets.top - point.y;
                } else if (point.y > this.height - insets.bottom) {
                    bodyLayout.y -= point.y - this.height + insets.bottom;
                }
            }
            if (hscroll || vscroll) {
                this.correctViewportOrigin(insets, this.width, this.height);
                if (origX != bodyLayout.x || origY != bodyLayout.y) {
                    this.resetScrollBars(null);
                    this.repaint();
                }
            }
        }
    }

    private JScrollBar getHScrollBar() {
        JScrollBar sb = this.hScrollBar;
        if (sb == null) {
            sb = new JScrollBar(0);
            sb.addAdjustmentListener(new LocalAdjustmentListener(0));
            this.hScrollBar = sb;
        }
        return sb;
    }

    private JScrollBar getVScrollBar() {
        JScrollBar sb = this.vScrollBar;
        if (sb == null) {
            sb = new JScrollBar(1);
            sb.addAdjustmentListener(new LocalAdjustmentListener(1));
            this.vScrollBar = sb;
        }
        return sb;
    }

    public final boolean isOverflowVisibleX() {
        int overflow = this.overflowX;
        return overflow == 0 || overflow == 4;
    }

    public final boolean isOverflowVisibleY() {
        int overflow = this.overflowY;
        return overflow == 0 || overflow == 4;
    }

    public int getFirstLineHeight() {
        return this.bodyLayout.getFirstLineHeight();
    }

    public int getFirstBaselineOffset() {
        return this.bodyLayout.getFirstBaselineOffset();
    }

    public void setSelectionEnd(RenderableSpot rpoint) {
        this.endSelection = rpoint;
    }

    public void setSelectionStart(RenderableSpot rpoint) {
        this.startSelection = rpoint;
    }

    public int getViewportListNesting(int blockNesting) {
        return blockNesting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        long time4;
        long time3;
        long time2;
        long time1;
        boolean linfo;
        block24: {
            RenderState rs = this.modelNode.getRenderState();
            if (rs != null && rs.getVisibility() != 0) {
                return;
            }
            linfo = loggableInfo;
            time1 = linfo ? System.currentTimeMillis() : 0L;
            this.prePaint(g);
            time2 = linfo ? System.currentTimeMillis() : 0L;
            time3 = 0L;
            try {
                JScrollBar vsb;
                JScrollBar hsb;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                RBlockViewport bodyLayout = this.bodyLayout;
                if (bodyLayout != null) {
                    int overflowX = this.overflowX;
                    int overflowY = this.overflowY;
                    if (!(overflowX != 0 && overflowX != 4 || overflowY != 0 && overflowY != 4)) {
                        int bx = bodyLayout.x;
                        int by = bodyLayout.y;
                        g.translate(bx, by);
                        try {
                            bodyLayout.paint(g);
                        }
                        finally {
                            g.translate(-bx, -by);
                        }
                    }
                    Graphics newG = g.create(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
                    try {
                        newG.translate(bodyLayout.x - insets.left, bodyLayout.y - insets.top);
                        bodyLayout.paint(newG);
                    }
                    finally {
                        newG.dispose();
                    }
                    if (linfo) {
                        time3 = System.currentTimeMillis();
                    }
                }
                RenderableSpot start = this.startSelection;
                RenderableSpot end = this.endSelection;
                boolean inSelection = false;
                if (start != null && end != null && !start.equals(end)) {
                    this.paintSelection(g, inSelection, start, end);
                }
                if ((hsb = this.hScrollBar) != null) {
                    Graphics sbg = g.create(insets.left, this.height - insets.bottom, this.width - insets.left - insets.right, 16);
                    try {
                        hsb.paint(sbg);
                    }
                    finally {
                        sbg.dispose();
                    }
                }
                if ((vsb = this.vScrollBar) == null) break block24;
                Graphics sbg = g.create(this.width - insets.right, insets.top, 16, this.height - insets.top - insets.bottom);
                try {
                    vsb.paint(sbg);
                }
                finally {
                    sbg.dispose();
                }
            }
            finally {
                super.paint(g);
            }
        }
        if (linfo && (time4 = System.currentTimeMillis()) - time1 > 100L) {
            logger.info("paint(): Elapsed: " + (time4 - time1) + " ms. Prepaint: " + (time2 - time1) + " ms. Viewport: " + (time3 - time2) + " ms. RBlock: " + this + ".");
        }
    }

    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly) {
        this.layout(availWidth, availHeight, expandWidth, expandHeight, null, defaultOverflowX, defaultOverflowY, sizeOnly);
    }

    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, boolean sizeOnly) {
        this.layout(availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, this.defaultOverflowX, this.defaultOverflowY, sizeOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly) {
        try {
            this.doLayout(availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, defaultOverflowX, defaultOverflowY, sizeOnly);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    @Override
    public final void doLayout(int availWidth, int availHeight, boolean sizeOnly) {
        this.doLayout(availWidth, availHeight, true, false, null, this.defaultOverflowX, this.defaultOverflowY, sizeOnly);
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly) {
        this.doLayout(availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, defaultOverflowX, defaultOverflowY, sizeOnly, true);
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly, boolean useCache) {
        RenderState renderState = this.modelNode.getRenderState();
        Font font = renderState == null ? null : renderState.getFont();
        int whiteSpace = renderState == null ? 0 : renderState.getWhiteSpace();
        boolean overrideNoWrap = RenderThreadState.getState().overrideNoWrap;
        LayoutKey key = new LayoutKey(availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, defaultOverflowX, defaultOverflowY, whiteSpace, font, overrideNoWrap);
        Map<LayoutKey, LayoutValue> cachedLayout = this.cachedLayout;
        LayoutValue value = sizeOnly ? (useCache ? cachedLayout.get(key) : null) : (Objects.equals(key, this.lastLayoutKey) ? this.lastLayoutValue : null);
        if (value == null) {
            value = this.forceLayout(renderState, availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, defaultOverflowX, defaultOverflowY, sizeOnly);
            if (sizeOnly) {
                this.lastLayoutKey = null;
                this.lastLayoutValue = null;
                if (cachedLayout.size() > 10) {
                    cachedLayout.clear();
                }
                cachedLayout.put(key, value);
            } else {
                this.lastLayoutKey = key;
                this.lastLayoutValue = value;
            }
        }
        this.width = value.width;
        this.height = value.height;
        this.hasHScrollBar = value.hasHScrollBar;
        this.hasVScrollBar = value.hasVScrollBar;
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    private final boolean correctViewportOrigin(Insets insets, int blockWidth, int blockHeight) {
        RBlockViewport bodyLayout = this.bodyLayout;
        int viewPortX = bodyLayout.x;
        int viewPortY = bodyLayout.y;
        boolean corrected = false;
        if (viewPortX > insets.left) {
            bodyLayout.x = insets.left;
            corrected = true;
        } else if (viewPortX < blockWidth - insets.right - bodyLayout.width) {
            bodyLayout.x = Math.min(insets.left, blockWidth - insets.right - bodyLayout.width);
            corrected = true;
        }
        if (viewPortY > insets.top) {
            bodyLayout.y = insets.top;
            corrected = true;
        } else if (viewPortY < blockHeight - insets.bottom - bodyLayout.height) {
            bodyLayout.y = Math.min(insets.top, blockHeight - insets.bottom - bodyLayout.height);
            corrected = true;
        }
        return corrected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LayoutValue forceLayout(RenderState renderState, int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource blockFloatBoundsSource, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly) {
        int alignmentYPercent;
        int resultingHeight;
        int alignmentXPercent;
        int resultingWidth;
        boolean visibleY;
        int adjDeclaredHeight;
        int desiredViewportHeight;
        int desiredViewportWidth;
        int tentativeHeight;
        int overflowY;
        Insets marginInsets;
        Insets borderInsets;
        RenderState rs = renderState;
        if (rs == null) {
            rs = new BlockRenderState(null);
        }
        this.applyStyle(availWidth, availHeight);
        RBlockViewport bodyLayout = this.bodyLayout;
        DOMNodeImpl node = (DOMNodeImpl)this.modelNode;
        if (node == null || bodyLayout == null) {
            Insets insets = this.getInsets(false, false);
            return new LayoutValue(insets.left + insets.right, insets.bottom + insets.top, false, false);
        }
        Insets paddingInsets = this.paddingInsets;
        if (paddingInsets == null) {
            paddingInsets = RBlockViewport.ZERO_INSETS;
        }
        if ((borderInsets = this.borderInsets) == null) {
            borderInsets = RBlockViewport.ZERO_INSETS;
        }
        if ((marginInsets = this.marginInsets) == null) {
            marginInsets = RBlockViewport.ZERO_INSETS;
        }
        int paddingTotalWidth = paddingInsets.left + paddingInsets.right;
        int paddingTotalHeight = paddingInsets.top + paddingInsets.bottom;
        int overflowX = this.overflowX;
        if (overflowX == 0) {
            overflowX = defaultOverflowX;
        }
        if ((overflowY = this.overflowY) == 0) {
            overflowY = defaultOverflowY;
        }
        boolean vauto = overflowY == 2;
        boolean hscroll = overflowX == 1;
        boolean hauto = overflowX == 2;
        boolean vscroll = overflowY == 1;
        Insets insets = this.getInsets(hscroll, vscroll);
        int insetsTotalWidth = insets.left + insets.right;
        int insetsTotalHeight = insets.top + insets.bottom;
        int actualAvailWidth = availWidth - paddingTotalWidth - insetsTotalWidth;
        int actualAvailHeight = availHeight - paddingTotalHeight - insetsTotalHeight;
        Integer dw = this.getDeclaredWidth(renderState, actualAvailWidth);
        Integer dh = this.getDeclaredHeight(renderState, actualAvailHeight);
        int declaredWidth = -1;
        int declaredHeight = -1;
        if (dw != null) {
            declaredWidth = dw;
        }
        if (dh != null) {
            declaredHeight = dh;
        }
        this.clearGUIComponents();
        int tentativeWidth = declaredWidth == -1 ? availWidth : declaredWidth + insetsTotalWidth + paddingTotalWidth;
        int n = tentativeHeight = declaredHeight == -1 ? availHeight : declaredHeight + insetsTotalHeight + paddingTotalHeight;
        if (declaredWidth == -1 && !expandWidth && availWidth > insetsTotalWidth + paddingTotalWidth) {
            RenderThreadState state = RenderThreadState.getState();
            boolean prevOverrideNoWrap = state.overrideNoWrap;
            if (!prevOverrideNoWrap) {
                state.overrideNoWrap = true;
                try {
                    desiredViewportWidth = paddingTotalWidth;
                    desiredViewportHeight = paddingTotalHeight;
                    bodyLayout.layout(desiredViewportWidth, desiredViewportHeight, paddingInsets, -1, null, true);
                    if (bodyLayout.width + insetsTotalWidth < tentativeWidth) {
                        tentativeWidth = bodyLayout.width + insetsTotalWidth;
                        tentativeHeight = bodyLayout.height + insetsTotalHeight;
                    }
                }
                finally {
                    state.overrideNoWrap = false;
                }
            }
        }
        ShiftedFloatingBounds viewportFloatBounds = null;
        FloatingBounds blockFloatBounds = null;
        if (blockFloatBoundsSource != null) {
            blockFloatBounds = blockFloatBoundsSource.getChildBlockFloatingBounds(tentativeWidth);
            viewportFloatBounds = new ShiftedFloatingBounds(blockFloatBounds, -insets.left, -insets.right, -insets.top);
        }
        desiredViewportWidth = tentativeWidth - insetsTotalWidth;
        desiredViewportHeight = tentativeHeight - insets.top - insets.bottom;
        int maxY = vauto ? (declaredHeight == -1 ? -1 : declaredHeight + paddingInsets.top) : -1;
        try {
            bodyLayout.layout(desiredViewportWidth, desiredViewportHeight, paddingInsets, maxY, viewportFloatBounds, sizeOnly);
        }
        catch (SizeExceededException see) {
            vscroll = true;
            insets = this.getInsets(hscroll, vscroll);
            insetsTotalWidth = insets.left + insets.right;
            actualAvailWidth = availWidth - paddingTotalWidth - insetsTotalWidth;
            dw = this.getDeclaredWidth(renderState, actualAvailWidth);
            declaredWidth = dw == null ? -1 : dw;
            desiredViewportWidth = tentativeWidth - insetsTotalWidth;
            if (blockFloatBounds != null) {
                viewportFloatBounds = new ShiftedFloatingBounds(blockFloatBounds, -insets.left, -insets.right, -insets.top);
            }
            bodyLayout.layout(desiredViewportWidth, desiredViewportHeight, paddingInsets, -1, viewportFloatBounds, sizeOnly);
        }
        int bodyWidth = bodyLayout.width;
        int bodyHeight = bodyLayout.height;
        int prelimBlockWidth = bodyWidth + insetsTotalWidth;
        int prelimBlockHeight = bodyHeight + insetsTotalHeight;
        int adjDeclaredWidth = declaredWidth == -1 ? -1 : declaredWidth + insets.left + insets.right + paddingInsets.left + paddingInsets.right;
        int n2 = adjDeclaredHeight = declaredHeight == -1 ? -1 : declaredHeight + insets.top + insets.bottom + paddingInsets.top + paddingInsets.bottom;
        if (hauto && (adjDeclaredWidth != -1 && prelimBlockWidth > adjDeclaredWidth || prelimBlockWidth > tentativeWidth)) {
            hscroll = true;
            insets = this.getInsets(hscroll, vscroll);
            insetsTotalHeight = insets.top + insets.bottom;
            prelimBlockHeight = bodyHeight + insetsTotalHeight;
        }
        boolean visibleX = overflowX == 4 || overflowX == 0;
        boolean bl = visibleY = overflowY == 4 || overflowY == 0;
        if (adjDeclaredWidth == -1) {
            int n3 = resultingWidth = expandWidth ? Math.max(prelimBlockWidth, tentativeWidth) : prelimBlockWidth;
            if (hscroll && resultingWidth > tentativeWidth) {
                resultingWidth = Math.max(tentativeWidth, 16);
            }
        } else {
            int n4 = resultingWidth = visibleX ? Math.max(prelimBlockWidth, adjDeclaredWidth) : adjDeclaredWidth;
        }
        if (!sizeOnly && (alignmentXPercent = rs.getAlignXPercent()) > 0) {
            int canvasWidth = Math.max(bodyLayout.width, resultingWidth - insets.left - insets.right);
            bodyLayout.alignX(alignmentXPercent, canvasWidth, paddingInsets);
        }
        if (adjDeclaredHeight == -1) {
            int n5 = resultingHeight = expandHeight ? Math.max(prelimBlockHeight, tentativeHeight) : prelimBlockHeight;
            if (vscroll && resultingHeight > tentativeHeight) {
                resultingHeight = Math.max(tentativeHeight, 16);
            }
        } else {
            int n6 = resultingHeight = visibleY ? Math.max(prelimBlockHeight, adjDeclaredHeight) : adjDeclaredHeight;
        }
        if (!sizeOnly && (alignmentYPercent = rs.getAlignYPercent()) > 0) {
            int canvasHeight = Math.max(bodyLayout.height, resultingHeight - insets.top - insets.bottom);
            bodyLayout.alignY(alignmentYPercent, canvasHeight, paddingInsets);
        }
        if (vscroll) {
            JScrollBar sb = this.getVScrollBar();
            this.addComponent(sb);
        }
        if (hscroll) {
            JScrollBar sb = this.getHScrollBar();
            this.addComponent(sb);
        }
        if (hscroll || vscroll) {
            this.correctViewportOrigin(insets, resultingWidth, resultingHeight);
            this.width = resultingWidth;
            this.height = resultingHeight;
            this.resetScrollBars(rs);
        } else {
            bodyLayout.x = insets.left;
            bodyLayout.y = insets.top;
        }
        return new LayoutValue(resultingWidth, resultingHeight, hscroll, vscroll);
    }

    private int getVUnitIncrement(RenderState renderState) {
        if (renderState != null) {
            return renderState.getFontMetrics().getHeight();
        }
        return new BlockRenderState(null).getFontMetrics().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetScrollBars(RenderState renderState) {
        this.resettingScrollBars = true;
        try {
            RBlockViewport bodyLayout = this.bodyLayout;
            if (bodyLayout != null) {
                JScrollBar hsb;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                JScrollBar vsb = this.vScrollBar;
                if (vsb != null) {
                    int newValue = insets.top - bodyLayout.y;
                    int newExtent = this.height - insets.top - insets.bottom;
                    int newMin = 0;
                    int newMax = bodyLayout.height;
                    vsb.setValues(newValue, newExtent, newMin, newMax);
                    vsb.setUnitIncrement(this.getVUnitIncrement(renderState));
                    vsb.setBlockIncrement(newExtent);
                }
                if ((hsb = this.hScrollBar) != null) {
                    int newValue = insets.left - bodyLayout.x;
                    int newExtent = this.width - insets.left - insets.right;
                    int newMin = 0;
                    int newMax = bodyLayout.width;
                    hsb.setValues(newValue, newExtent, newMin, newMax);
                }
            }
        }
        finally {
            this.resettingScrollBars = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Graphics newG = g.create();
        try {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            newG.clipRect(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
            boolean bl = super.paintSelection(newG, inSelection, startPoint, endPoint);
            return bl;
        }
        finally {
            newG.dispose();
        }
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            if (x > insets.left && x < this.width - insets.right && y > insets.top && y < this.height - insets.bottom) {
                return bodyLayout.getLowestRenderableSpot(x - bodyLayout.x, y - bodyLayout.y);
            }
            return new RenderableSpot(this, x, y);
        }
        return new RenderableSpot(this, x, y);
    }

    @Override
    public void invalidateLayoutLocal() {
        JScrollBar vScrollBar;
        super.invalidateLayoutLocal();
        this.cachedLayout.clear();
        this.lastLayoutKey = null;
        this.lastLayoutValue = null;
        JScrollBar hScrollBar = this.hScrollBar;
        if (hScrollBar != null) {
            hScrollBar.invalidate();
        }
        if ((vScrollBar = this.vScrollBar) != null) {
            vScrollBar.invalidate();
        }
    }

    @Override
    protected void clearStyle(boolean isRootBlock) {
        super.clearStyle(isRootBlock);
        this.overflowX = this.defaultOverflowX;
        this.overflowY = this.defaultOverflowY;
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (!HtmlController.getInstance().onMouseClick(this.modelNode, event, bodyLayout, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (!HtmlController.getInstance().onDoubleClick(this.modelNode, event, bodyLayout, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable br = this.armedRenderable;
        if (br != null) {
            try {
                boolean bl = br.onMouseDisarmed(event);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    public BoundableRenderable getArmedRenderable() {
        return this.armedRenderable;
    }

    public void setArmedRenderable(BoundableRenderable armedRenderable) {
        this.armedRenderable = armedRenderable;
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        if (!HtmlController.getInstance().onMouseDown(this.modelNode, event, this, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        if (!HtmlController.getInstance().onMouseUp(this.modelNode, event, this, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    @Override
    public boolean onKeyPressed(KeyEvent event) {
        return HtmlController.getInstance().onKeyPress(this.modelNode, event);
    }

    @Override
    public boolean onKeyUp(KeyEvent event) {
        return HtmlController.getInstance().onKeyUp(this.modelNode, event);
    }

    @Override
    public boolean onKeyDown(KeyEvent event) {
        return HtmlController.getInstance().onKeyDown(this.modelNode, event);
    }

    @Override
    public Color getPaintedBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public Iterator<?> getRenderables() {
        final RBlockViewport bodyLayout = this.bodyLayout;
        return new Iterator<Object>(){
            private RBlockViewport bl;
            {
                this.bl = bodyLayout;
            }

            @Override
            public boolean hasNext() {
                return this.bl != null;
            }

            @Override
            public Object next() {
                if (this.bl == null) {
                    throw new NoSuchElementException();
                }
                try {
                    RBlockViewport rBlockViewport = this.bl;
                    return rBlockViewport;
                }
                finally {
                    this.bl = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    @Override
    public void updateWidgetBounds(int guiX, int guiY) {
        super.updateWidgetBounds(guiX, guiY);
        boolean hscroll = this.hasHScrollBar;
        boolean vscroll = this.hasVScrollBar;
        if (hscroll || vscroll) {
            JScrollBar vsb;
            JScrollBar hsb;
            Insets insets = this.getInsets(hscroll, vscroll);
            if (hscroll && (hsb = this.hScrollBar) != null) {
                hsb.setBounds(guiX + insets.left, guiY + this.height - insets.bottom, this.width - insets.left - insets.right, 16);
            }
            if (vscroll && (vsb = this.vScrollBar) != null) {
                vsb.setBounds(guiX + this.width - insets.right, guiY + insets.top, 16, this.height - insets.top - insets.bottom);
            }
        }
    }

    public void scrollHorizontalTo(int newX) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int viewPortX = newX;
            bodyLayout.x = viewPortX > insets.left ? insets.left : (viewPortX < this.width - insets.right - bodyLayout.width ? Math.min(insets.left, this.width - insets.right - bodyLayout.width) : viewPortX);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollVerticalTo(int newY) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int viewPortY = newY;
            bodyLayout.y = viewPortY > insets.top ? insets.top : (viewPortY < this.height - insets.bottom - bodyLayout.height ? Math.min(insets.top, this.height - insets.bottom - bodyLayout.height) : viewPortY);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollByUnits(int orientation, int units) {
        int offset = orientation == 1 ? this.getVUnitIncrement(null) * units : units;
        this.scrollBy(orientation, offset);
    }

    public void scrollBy(int orientation, int offset) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            switch (orientation) {
                case 0: {
                    this.scrollHorizontalTo(bodyLayout.x - offset);
                    break;
                }
                case 1: {
                    this.scrollVerticalTo(bodyLayout.y - offset);
                }
            }
        }
    }

    public void scrollTo(Rectangle bounds, boolean xIfNeeded, boolean yIfNeeded) {
        boolean hscroll = this.hasHScrollBar;
        boolean vscroll = this.hasVScrollBar;
        if (hscroll || vscroll) {
            RBlockViewport bv = this.bodyLayout;
            Insets insets = this.getInsets(hscroll, vscroll);
            int vpheight = this.height - insets.top - insets.bottom;
            int vpwidth = this.width - insets.left - insets.right;
            int tentativeX = insets.left - bounds.x;
            int tentativeY = insets.top - bounds.y;
            boolean needCorrection = false;
            if (!xIfNeeded || tentativeX > bv.x || -tentativeX + bv.x + bounds.width > vpwidth) {
                bv.setX(tentativeX);
                needCorrection = true;
            }
            if (!yIfNeeded || tentativeY > bv.y || -tentativeY + bv.y + bounds.height > vpheight) {
                bv.setY(tentativeY);
                needCorrection = true;
            }
            if (needCorrection) {
                this.correctViewportOrigin(insets, this.width, this.height);
            }
        }
    }

    private void scrollToSBValue(int orientation, int value) {
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        switch (orientation) {
            case 0: {
                int xOrigin = insets.left - value;
                this.scrollHorizontalTo(xOrigin);
                break;
            }
            case 1: {
                int yOrigin = insets.top - value;
                this.scrollVerticalTo(yOrigin);
            }
        }
    }

    public RBlockViewport getRBlockViewport() {
        return this.bodyLayout;
    }

    @Override
    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        boolean result = super.extractSelectionText(buffer, inSelection, startPoint, endPoint);
        String br = System.getProperty("line.separator");
        if (inSelection) {
            buffer.insert(0, br);
        }
        if (result) {
            buffer.append(br);
        }
        return result;
    }

    public String toString() {
        return "RBlock[node=" + this.modelNode + "]";
    }

    public FloatingInfo getExportableFloatingInfo() {
        FloatingInfo info = this.bodyLayout.getExportableFloatingInfo();
        if (info == null) {
            return null;
        }
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        return new FloatingInfo(info.shiftX + insets.left, info.shiftY + insets.top, info.floats);
    }

    public int getDefaultOverflowX() {
        return this.defaultOverflowX;
    }

    public int getDefaultOverflowY() {
        return this.defaultOverflowY;
    }

    public void setDefaultOverflowX(int defaultOverflowX) {
        this.defaultOverflowX = defaultOverflowX;
    }

    public void setDefaultOverflowY(int defaultOverflowY) {
        this.defaultOverflowY = defaultOverflowY;
    }

    public static class LayoutKey {
        public final int availWidth;
        public final int availHeight;
        public final FloatingBoundsSource floatBoundsSource;
        public final int defaultOverflowX;
        public final int defaultOverflowY;
        public final int whitespace;
        public final Font font;
        public final boolean expandWidth;
        public final boolean expandHeight;
        public final boolean useDeclaredSize;
        public final boolean overrideNoWrap;

        public LayoutKey(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, int defaultOverflowX, int defaultOverflowY, int whitespace, Font font, boolean overrideNoWrap) {
            this.availWidth = availWidth;
            this.availHeight = availHeight;
            this.floatBoundsSource = floatBoundsSource;
            this.defaultOverflowX = defaultOverflowX;
            this.defaultOverflowY = defaultOverflowY;
            this.whitespace = whitespace;
            this.font = font;
            this.expandWidth = expandWidth;
            this.expandHeight = expandHeight;
            this.useDeclaredSize = true;
            this.overrideNoWrap = overrideNoWrap;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LayoutKey)) {
                return false;
            }
            LayoutKey other = (LayoutKey)obj;
            return other.availWidth == this.availWidth && other.availHeight == this.availHeight && other.defaultOverflowX == this.defaultOverflowX && other.defaultOverflowY == this.defaultOverflowY && other.whitespace == this.whitespace && other.expandWidth == this.expandWidth && other.expandHeight == this.expandHeight && other.useDeclaredSize == this.useDeclaredSize && other.overrideNoWrap == this.overrideNoWrap && Objects.equals(other.font, this.font) && Objects.equals(other.floatBoundsSource, this.floatBoundsSource);
        }

        public int hashCode() {
            Font font = this.font;
            return this.availWidth * 1000 + this.availHeight ^ (font == null ? 0 : font.hashCode()) ^ (this.expandWidth ? 2 : 0) ^ (this.expandHeight ? 1 : 0) ^ this.whitespace << 2;
        }
    }

    private class LocalAdjustmentListener
    implements AdjustmentListener {
        private final int orientation;

        public LocalAdjustmentListener(int orientation) {
            this.orientation = orientation;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (RBlock.this.resettingScrollBars) {
                return;
            }
            switch (e.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int value = e.getValue();
                    RBlock.this.scrollToSBValue(this.orientation, value);
                    break;
                }
            }
        }
    }
}

