/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.layout;

import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.control.RUIControl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.layout.CommonWidgetLayout;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.UIControlWrapper;

public class ObjectLayout
extends CommonWidgetLayout {
    private boolean tryToRenderContent;
    private final ThreadLocal<HtmlObject> htmlObject = new ThreadLocal();

    public ObjectLayout(boolean tryToRenderContent, boolean usesAlignAttribute) {
        super(0, usesAlignAttribute);
        this.tryToRenderContent = tryToRenderContent;
    }

    @Override
    public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
        HtmlObject ho = bodyLayout.getRendererContext().getHtmlObject(markupElement);
        if (ho == null && this.tryToRenderContent) {
            bodyLayout.layoutMarkup(markupElement);
        } else if (ho != null) {
            this.htmlObject.set(ho);
            super.layoutMarkup(bodyLayout, markupElement);
        }
    }

    @Override
    protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
        HtmlObject ho = this.htmlObject.get();
        UIControlWrapper uiControl = new UIControlWrapper(ho);
        RUIControl ruiControl = new RUIControl(markupElement, uiControl, bodyLayout.getContainer(), bodyLayout.getFrameContext(), bodyLayout.getUserAgentContext());
        return ruiControl;
    }
}

