/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.layout;

import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.control.InputButtonControl;
import org.lobobrowser.html.control.InputCheckboxControl;
import org.lobobrowser.html.control.InputFileControl;
import org.lobobrowser.html.control.InputImageControl;
import org.lobobrowser.html.control.InputPasswordControl;
import org.lobobrowser.html.control.InputRadioControl;
import org.lobobrowser.html.control.InputTextControl;
import org.lobobrowser.html.control.RUIControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.layout.CommonWidgetLayout;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;

public class InputLayout
extends CommonWidgetLayout {
    public InputLayout() {
        super(0, true);
    }

    @Override
    protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
        HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
        BaseInputControl uiControl = this.createInputControl(bie);
        if (uiControl == null) {
            return null;
        }
        bie.setInputContext(uiControl);
        return new RUIControl(markupElement, uiControl, bodyLayout.getContainer(), bodyLayout.getFrameContext(), bodyLayout.getUserAgentContext());
    }

    private final BaseInputControl createInputControl(HTMLBaseInputElement markupElement) {
        String type = markupElement.getAttribute("type");
        if (type == null) {
            return new InputTextControl(markupElement);
        }
        if ("text".equals(type = type.toLowerCase()) || type.length() == 0) {
            return new InputTextControl(markupElement);
        }
        if ("hidden".equals(type)) {
            return null;
        }
        if ("submit".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("password".equals(type)) {
            return new InputPasswordControl(markupElement);
        }
        if ("radio".equals(type)) {
            return new InputRadioControl(markupElement);
        }
        if ("checkbox".equals(type)) {
            return new InputCheckboxControl(markupElement);
        }
        if ("image".equals(type)) {
            return new InputImageControl(markupElement);
        }
        if ("reset".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("button".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("file".equals(type)) {
            return new InputFileControl(markupElement);
        }
        return null;
    }
}

