/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.js.LocalSecureClassLoader;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class SecurityControllerImpl
extends SecurityController {
    private final URL url;
    private final Policy policy;
    private final CodeSource codesource;
    private static final Logger logger = Logger.getLogger(SecurityControllerImpl.class.getName());

    public SecurityControllerImpl(URL url, Policy policy) {
        this.url = url;
        this.policy = policy;
        Certificate[] certs = new Certificate[]{};
        this.codesource = new CodeSource(this.url, certs);
    }

    @Override
    public Object callWithDomain(Object securityDomain, final Context ctx, final Callable callable, final Scriptable scope, final Scriptable thisObj, final Object[] args) {
        Object obj = null;
        try {
            if (securityDomain != null) {
                PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return callable.call(ctx, scope, thisObj, args);
                    }
                };
                AccessControlContext acctx = new AccessControlContext(new ProtectionDomain[]{(ProtectionDomain)securityDomain});
                return AccessController.doPrivileged(action, acctx);
            }
            obj = callable.call(ctx, scope, thisObj, args);
        }
        catch (MissingResourceException err) {
            logger.log(Level.WARNING, "Missing Resource");
        }
        return obj;
    }

    @Override
    public GeneratedClassLoader createClassLoader(ClassLoader parent, Object staticDomain) {
        return new LocalSecureClassLoader(parent, this.codesource);
    }

    @Override
    public Object getDynamicSecurityDomain(Object securityDomain) {
        Policy policy = this.policy;
        if (policy == null) {
            return null;
        }
        PermissionCollection permissions = this.policy.getPermissions(this.codesource);
        return new ProtectionDomain(this.codesource, permissions);
    }
}

