/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public class WritableLineReader
extends LineNumberReader {
    private StringBuffer writeBuffer = null;

    public WritableLineReader(Reader reader, int bufferSize) {
        super(reader, bufferSize);
    }

    public WritableLineReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        StringBuffer sb = this.writeBuffer;
        if (sb != null && sb.length() > 0) {
            char ch = sb.charAt(0);
            sb.deleteCharAt(0);
            if (sb.length() == 0) {
                this.writeBuffer = null;
            }
            return ch;
        }
        return super.read();
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        StringBuffer sb = this.writeBuffer;
        if (sb != null && sb.length() > 0) {
            int srcEnd = Math.min(sb.length(), len);
            sb.getChars(0, srcEnd, b, off);
            sb.delete(0, srcEnd);
            if (sb.length() == 0) {
                this.writeBuffer = null;
            }
            return srcEnd;
        }
        return super.read(b, off, len);
    }

    @Override
    public boolean ready() throws IOException {
        StringBuffer sb = this.writeBuffer;
        if (sb != null && sb.length() > 0) {
            return true;
        }
        return super.ready();
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer = null;
        super.close();
    }

    public void write(String text) throws IOException {
        StringBuffer sb = this.writeBuffer;
        if (sb == null) {
            this.writeBuffer = sb = new StringBuffer();
        }
        sb.append(text);
    }
}

