/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.lobobrowser.html.w3c.HTMLStyleElement;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;

public class HTMLStyleElementImpl
extends HTMLElementImpl
implements HTMLStyleElement {
    private CSSStyleSheet styleSheet;
    private boolean disabled;

    public HTMLStyleElementImpl() {
        super("STYLE", true);
    }

    public HTMLStyleElementImpl(String name) {
        super(name, true);
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        CSSStyleSheet sheet = this.styleSheet;
        if (sheet != null) {
            sheet.setDisabled(disabled);
        }
    }

    @Override
    public String getMedia() {
        return this.getAttribute("media");
    }

    @Override
    public void setMedia(String media) {
        this.setAttribute("media", media);
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key) && data != Boolean.TRUE) {
            this.processStyle();
        } else if ("styleSheet.disabled.changed".equals(key)) {
            this.informDocumentInvalid();
        }
        return super.setUserData(key, data, handler);
    }

    protected void processStyle() {
        String text;
        this.styleSheet = null;
        UserAgentContext uacontext = this.getUserAgentContext();
        if (uacontext.isInternalCSSEnabled() && CSSUtilities.matchesMedia(this.getMedia(), this.getUserAgentContext()) && (text = this.getRawInnerText(true)) != null && !"".equals(text)) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)this.getOwnerDocument();
            try {
                ArrayList<String> arrText = CSSUtilities.cssText(text);
                for (int i = 0; i < arrText.size(); ++i) {
                    text = arrText.get(i);
                    if (text.length() <= 0 || text.startsWith("/*")) continue;
                    CSSStyleSheet sheet = null;
                    try {
                        sheet = CSSUtilities.parse(this, text, doc.getBaseURI(), false);
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "Unable to parse CSS: " + text);
                    }
                    if (sheet == null) continue;
                    doc.addStyleSheet(sheet);
                    this.styleSheet = sheet;
                    if (sheet instanceof CSSStyleSheetImpl) {
                        CSSStyleSheetImpl sheetImpl = (CSSStyleSheetImpl)sheet;
                        sheetImpl.setDisabled(this.disabled);
                        continue;
                    }
                    sheet.setDisabled(this.disabled);
                }
            }
            catch (Throwable err) {
                this.warn("Unable to parse style sheet", err);
            }
        }
    }

    @Override
    protected void appendInnerTextImpl(StringBuffer buffer) {
    }

    @Override
    public boolean getScoped() {
        String scoped = this.getAttribute("scoped");
        return "scoped".equalsIgnoreCase(scoped);
    }

    @Override
    public void setScoped(boolean scoped) {
        this.setAttribute("scoped", scoped ? "scoped" : null);
    }
}

