/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Color;
import java.awt.Cursor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.renderstate.ColorRenderState;
import org.lobobrowser.html.renderstate.CursorRenderState;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.TextDecorationRenderState;
import org.lobobrowser.html.w3c.DOMTokenList;
import org.lobobrowser.html.w3c.HTMLAnchorElement;
import org.lobobrowser.html.w3c.HTMLBodyElement;
import org.lobobrowser.html.w3c.HTMLDocument;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.gui.ColorFactory;

public class HTMLAnchorElementImpl
extends HTMLAbstractUIElement
implements HTMLAnchorElement {
    private static final Logger logger = Logger.getLogger(HTMLAnchorElementImpl.class.getName());

    public HTMLAnchorElementImpl(String name) {
        super(name);
    }

    @Override
    public String getHref() {
        String href = this.getAttribute("href");
        return href == null ? "" : Urls.removeControlCharacters(href);
    }

    @Override
    public void setHref(String href) {
        this.setAttribute("href", href);
    }

    @Override
    public String getHreflang() {
        return this.getAttribute("hreflang");
    }

    @Override
    public void setHreflang(String hreflang) {
        this.setAttribute("hreflang", hreflang);
    }

    @Override
    public String getMedia() {
        return this.getAttribute("media");
    }

    @Override
    public void setMedia(String media) {
        this.setAttribute("media", media);
    }

    @Override
    public String getRel() {
        return this.getAttribute("rel");
    }

    @Override
    public void setRel(String rel) {
        this.setAttribute("rel", rel);
    }

    @Override
    public String getRev() {
        return this.getAttribute("rev");
    }

    @Override
    public void setRev(String rev) {
        this.setAttribute("rev", rev);
    }

    @Override
    public String getTarget() {
        String target = this.getAttribute("target");
        if (target != null) {
            return target;
        }
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        return doc == null ? null : doc.getDefaultTarget();
    }

    @Override
    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getAbsoluteHref() {
        String href;
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext != null && (href = this.getHref()) != null && href.length() > 0) {
            try {
                URL url = this.getFullURL(href);
                return url == null ? null : url.toExternalForm();
            }
            catch (MalformedURLException mfu) {
                this.warn("Malformed URI: [" + href + "].", mfu);
            }
        }
        return null;
    }

    public void navigate() {
        String href;
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext != null && (href = this.getHref()) != null && href.length() > 0) {
            String target = this.getTarget();
            try {
                URL url = this.getFullURL(href);
                if (url != null) {
                    rcontext.linkClicked(this, url, target);
                }
            }
            catch (MalformedURLException mfu) {
                this.warn("Malformed URI: [" + href + "].", mfu);
            }
        }
    }

    private Color getLinkColor() {
        HTMLBodyElement body;
        HTMLDocument doc = (HTMLDocument)this.document;
        if (doc != null && (body = (HTMLBodyElement)doc.getBody()) != null) {
            HtmlRendererContext rcontext;
            String vlink = body.getVLink();
            String link = body.getLink();
            if ((vlink != null || link != null) && (rcontext = this.getHtmlRendererContext()) != null) {
                String colorText;
                boolean visited = rcontext.isVisitedLink(this);
                String string = colorText = visited ? vlink : link;
                if (colorText != null) {
                    return ColorFactory.getInstance().getColor(colorText);
                }
            }
        }
        return Color.BLUE;
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        if (this.hasAttribute("href")) {
            prevRenderState = new TextDecorationRenderState(prevRenderState, 1);
            prevRenderState = new ColorRenderState(prevRenderState, this.getLinkColor());
            prevRenderState = new CursorRenderState(prevRenderState, Cursor.getPredefinedCursor(12));
        }
        return super.createRenderState(prevRenderState);
    }

    @Override
    public String toString() {
        return this.getHref();
    }

    @Override
    public DOMTokenList getRelList() {
        return null;
    }

    @Override
    public String getCoords() {
        return null;
    }

    @Override
    public void setCoords(String coords) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getShape() {
        return null;
    }

    @Override
    public void setShape(String shape) {
    }

    @Override
    public void setPing(String ping) {
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public String getProtocol() {
        return null;
    }

    @Override
    public void setProtocol(String protocol) {
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public void setHost(String host) {
    }

    @Override
    public String getHostname() {
        return null;
    }

    @Override
    public void setHostname(String hostname) {
    }

    @Override
    public String getPort() {
        return null;
    }

    @Override
    public void setPort(String port) {
    }

    @Override
    public String getPathname() {
        return null;
    }

    @Override
    public void setPathname(String pathname) {
    }

    @Override
    public String getSearch() {
        return null;
    }

    @Override
    public void setSearch(String search) {
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public void setHash(String hash) {
    }
}

