/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.ChildHTMLCollection;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.dombl.NodeVisitor;
import org.lobobrowser.html.dombl.SkipVisitorException;
import org.lobobrowser.html.dombl.StopVisitorException;
import org.lobobrowser.html.dombl.UINode;
import org.lobobrowser.html.domfilter.NodeFilter;
import org.lobobrowser.html.domfilter.TextFilter;
import org.lobobrowser.html.domimpl.DOMElementImpl;
import org.lobobrowser.html.domimpl.DOMNodeListImpl;
import org.lobobrowser.html.domimpl.DOMTextImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class DOMNodeImpl
extends AbstractScriptableDelegate
implements Node,
ModelNode {
    private static final DOMNodeImpl[] EMPTY_ARRAY = new DOMNodeImpl[0];
    private static final RenderState INVALID_RENDER_STATE = new StyleSheetRenderState(null);
    protected static final Logger logger = Logger.getLogger(DOMNodeImpl.class.getName());
    protected UINode uiNode;
    protected ArrayList<Node> nodeList;
    protected volatile Document document;
    private volatile Object treeLock = this;
    private ChildHTMLCollection childrenCollection;
    private Map<String, Object> userData;
    private Map<String, UserDataHandler> userDataHandlers;
    protected volatile boolean notificationsSuspended = false;
    private volatile String prefix;
    protected volatile Node parentNode;
    private RenderState renderState = INVALID_RENDER_STATE;

    public void setUINode(UINode uiNode) {
        this.uiNode = uiNode;
    }

    public UINode getUINode() {
        return this.uiNode;
    }

    public UINode findUINode() {
        UINode uiNode = this.uiNode;
        if (uiNode != null) {
            return uiNode;
        }
        DOMNodeImpl parentNode = (DOMNodeImpl)this.getParentNode();
        return parentNode == null ? null : parentNode.findUINode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node appendChild(Node newChild) throws DOMException {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl == null) {
                this.nodeList = nl = new ArrayList(3);
            }
            nl.add(newChild);
            if (newChild instanceof DOMNodeImpl) {
                ((DOMNodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeAllChildrenImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildrenImpl() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl != null) {
                nl.clear();
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getNodeList(NodeFilter filter) {
        ArrayList<DOMNodeImpl> collection = new ArrayList<DOMNodeImpl>();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.appendChildrenToCollectionImpl(filter, collection);
        }
        return new DOMNodeListImpl(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeImpl[] getChildrenArray() {
        ArrayList<Node> nl = this.nodeList;
        Object object = this.getTreeLock();
        synchronized (object) {
            return nl == null ? null : nl.toArray(EMPTY_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        ArrayList<Node> nl = this.nodeList;
        Object object = this.getTreeLock();
        synchronized (object) {
            return nl == null ? 0 : nl.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildHTMLCollection getChildren() {
        DOMNodeImpl dOMNodeImpl = this;
        synchronized (dOMNodeImpl) {
            ChildHTMLCollection collection = this.childrenCollection;
            if (collection == null) {
                this.childrenCollection = collection = new ChildHTMLCollection(this);
            }
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DOMNodeImpl> getDescendents(NodeFilter filter, boolean nestIntoMatchingNodes) {
        ArrayList<DOMNodeImpl> al = new ArrayList<DOMNodeImpl>();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.extractDescendentsArrayImpl(filter, al, nestIntoMatchingNodes);
        }
        return al;
    }

    private void extractDescendentsArrayImpl(NodeFilter filter, ArrayList<DOMNodeImpl> al, boolean nestIntoMatchingNodes) {
        ArrayList<Node> nl = this.nodeList;
        if (nl != null) {
            for (DOMNodeImpl dOMNodeImpl : nl) {
                if (filter.accept(dOMNodeImpl)) {
                    al.add(dOMNodeImpl);
                    if (!nestIntoMatchingNodes) continue;
                    dOMNodeImpl.extractDescendentsArrayImpl(filter, al, nestIntoMatchingNodes);
                    continue;
                }
                if (dOMNodeImpl.getNodeType() != 1) continue;
                dOMNodeImpl.extractDescendentsArrayImpl(filter, al, nestIntoMatchingNodes);
            }
        }
    }

    private void appendChildrenToCollectionImpl(NodeFilter filter, Collection<DOMNodeImpl> collection) {
        ArrayList<Node> nl = this.nodeList;
        if (nl != null) {
            for (DOMNodeImpl dOMNodeImpl : nl) {
                if (filter.accept(dOMNodeImpl)) {
                    collection.add(dOMNodeImpl);
                }
                dOMNodeImpl.appendChildrenToCollectionImpl(filter, collection);
            }
        }
    }

    protected abstract Node createSimilarNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node cloneNode(boolean deep) {
        try {
            Node newNode = this.createSimilarNode();
            NodeList children = this.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                Node newChild = deep ? child.cloneNode(deep) : child;
                newNode.appendChild(newChild);
            }
            if (newNode instanceof Element) {
                Element elem = (Element)newNode;
                NamedNodeMap nnmap = this.getAttributes();
                if (nnmap != null) {
                    int nnlength = nnmap.getLength();
                    for (int i = 0; i < nnlength; ++i) {
                        Attr attr = (Attr)nnmap.item(i);
                        elem.setAttributeNode((Attr)attr.cloneNode(true));
                    }
                }
            }
            DOMNodeImpl dOMNodeImpl = this;
            synchronized (dOMNodeImpl) {
                if (this.userDataHandlers != null && this.userData != null) {
                    for (Map.Entry<String, UserDataHandler> entry : this.userDataHandlers.entrySet()) {
                        UserDataHandler handler = entry.getValue();
                        handler.handle((short)1, entry.getKey(), this.userData.get(entry.getKey()), this, newNode);
                    }
                }
            }
            return newNode;
        }
        catch (Exception err) {
            throw new IllegalStateException(err.getMessage());
        }
    }

    private int getNodeIndex() {
        DOMNodeImpl parent = (DOMNodeImpl)this.getParentNode();
        return parent == null ? -1 : parent.getChildIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildIndex(Node child) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            return nl == null ? -1 : nl.indexOf(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getChildAtIndex(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            try {
                return nl == null ? null : nl.get(index);
            }
            catch (IndexOutOfBoundsException iob) {
                this.warn("getChildAtIndex(): Bad index=" + index + " for node=" + this + ".");
                return null;
            }
        }
    }

    private boolean isAncestorOf(Node other) {
        DOMNodeImpl parent = (DOMNodeImpl)other.getParentNode();
        if (parent == this) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        return this.isAncestorOf(parent);
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        Node parent = this.getParentNode();
        if (!(other instanceof DOMNodeImpl)) {
            throw new DOMException(9, "Unknwon node implementation");
        }
        if (parent != null && parent == other.getParentNode()) {
            int thisIndex = this.getNodeIndex();
            int otherIndex = ((DOMNodeImpl)other).getNodeIndex();
            if (thisIndex == -1 || otherIndex == -1) {
                return 32;
            }
            if (thisIndex < otherIndex) {
                return 4;
            }
            return 2;
        }
        if (this.isAncestorOf(other)) {
            return 16;
        }
        if (((DOMNodeImpl)other).isAncestorOf(this)) {
            return 8;
        }
        return 1;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.document;
    }

    public void setOwnerDocument(Document value) {
        this.document = value;
        this.setTreeLock(value == null ? this : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwnerDocument(Document value, boolean deep) {
        this.document = value;
        this.setTreeLock(value == null ? this : value);
        if (deep) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ArrayList<Node> nl = this.nodeList;
                if (nl != null) {
                    for (DOMNodeImpl dOMNodeImpl : nl) {
                        dOMNodeImpl.setOwnerDocument(value, deep);
                    }
                }
            }
        }
    }

    protected void visitImpl(NodeVisitor visitor) {
        try {
            visitor.visit(this);
        }
        catch (SkipVisitorException sve) {
            return;
        }
        catch (StopVisitorException sve) {
            throw sve;
        }
        ArrayList<Node> nl = this.nodeList;
        if (nl != null) {
            for (DOMNodeImpl dOMNodeImpl : nl) {
                dOMNodeImpl.visit(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(NodeVisitor visitor) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.visitImpl(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Object object = this.getTreeLock();
        synchronized (object) {
            int idx;
            ArrayList<Node> nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(refChild);
            if (idx == -1) {
                throw new DOMException(8, "refChild not found");
            }
            nl.add(idx, newChild);
            if (newChild instanceof DOMNodeImpl) {
                ((DOMNodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node insertAt(Node newChild, int idx) throws DOMException {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl == null) {
                this.nodeList = nl = new ArrayList();
            }
            nl.add(idx, newChild);
            if (newChild instanceof DOMNodeImpl) {
                ((DOMNodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Object object = this.getTreeLock();
        synchronized (object) {
            int idx;
            ArrayList<Node> nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(oldChild);
            if (idx == -1) {
                throw new DOMException(8, "oldChild not found");
            }
            nl.set(idx, newChild);
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl == null || !nl.remove(oldChild)) {
                throw new DOMException(8, "oldChild not found");
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return oldChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChildAt(int index) throws DOMException {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                ArrayList<Node> nl = this.nodeList;
                if (nl == null) {
                    throw new DOMException(1, "Empty list of children");
                }
                Node n = nl.remove(index);
                if (n == null) {
                    throw new DOMException(1, "No node with that index");
                }
                Node node = n;
                return node;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildNodes() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            return nl != null && !nl.isEmpty();
        }
    }

    @Override
    public String getBaseURI() {
        Document document = this.document;
        return document == null ? null : document.getBaseURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeList getChildNodes() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            return new DOMNodeListImpl(nl == null ? Collections.EMPTY_LIST : nl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getFirstChild() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            try {
                return nl == null ? null : nl.get(0);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getLastChild() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            try {
                return nl == null ? null : nl.get(nl.size() - 1);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getPreviousTo(Node node) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int idx;
            ArrayList<Node> nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(node);
            if (idx == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return nl.get(idx - 1);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNextTo(Node node) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int idx;
            ArrayList<Node> nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(node);
            if (idx == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return nl.get(idx + 1);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    @Override
    public Node getPreviousSibling() {
        DOMNodeImpl parent = (DOMNodeImpl)this.getParentNode();
        return parent == null ? null : parent.getPreviousTo(this);
    }

    @Override
    public Node getNextSibling() {
        DOMNodeImpl parent = (DOMNodeImpl)this.getParentNode();
        return parent == null ? null : parent.getNextTo(this);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key)) {
            boolean ns;
            this.notificationsSuspended = ns = Boolean.TRUE == data;
            if (!ns) {
                this.informNodeLoaded();
            }
        }
        DOMNodeImpl dOMNodeImpl = this;
        synchronized (dOMNodeImpl) {
            if (handler != null) {
                if (this.userDataHandlers == null) {
                    this.userDataHandlers = new HashMap<String, UserDataHandler>();
                } else {
                    this.userDataHandlers.put(key, handler);
                }
            }
            Map<String, Object> userData = this.userData;
            if (data != null) {
                if (userData == null) {
                    this.userData = userData = new HashMap<String, Object>();
                }
                return userData.put(key, data);
            }
            if (userData != null) {
                return userData.remove(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(String key) {
        DOMNodeImpl dOMNodeImpl = this;
        synchronized (dOMNodeImpl) {
            Map<String, Object> ud = this.userData;
            return ud == null ? null : ud.get(key);
        }
    }

    @Override
    public abstract String getLocalName();

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public abstract String getNodeValue() throws DOMException;

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.prefix = prefix;
    }

    @Override
    public abstract void setNodeValue(String var1) throws DOMException;

    @Override
    public abstract short getNodeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTextContent() throws DOMException {
        StringBuffer sb = new StringBuffer();
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl != null) {
                for (Node node : nl) {
                    short type = node.getNodeType();
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 4: {
                            String textContent = node.getTextContent();
                            if (textContent == null) break;
                            sb.append(textContent);
                            break;
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextContent(String textContent) throws DOMException {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeChildrenImpl(new TextFilter());
            if (textContent != null && !"".equals(textContent)) {
                DOMTextImpl t = new DOMTextImpl(textContent);
                t.setOwnerDocument(this.document);
                t.setParentImpl(this);
                ArrayList<Node> nl = this.nodeList;
                if (nl == null) {
                    this.nodeList = nl = new ArrayList();
                }
                nl.add(t);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildren(NodeFilter filter) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeChildrenImpl(filter);
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    protected void removeChildrenImpl(NodeFilter filter) {
        ArrayList<Node> nl = this.nodeList;
        if (nl != null) {
            int len;
            int i = len = nl.size();
            while (--i >= 0) {
                Node node = nl.get(i);
                if (!filter.accept(node)) continue;
                nl.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertAfter(Node newChild, Node refChild) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int idx;
            ArrayList<Node> nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(refChild);
            if (idx == -1) {
                throw new DOMException(8, "refChild not found");
            }
            nl.add(idx + 1, newChild);
            if (newChild instanceof DOMNodeImpl) {
                ((DOMNodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text node, String textContent) {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                ArrayList<Node> nl = this.nodeList;
                if (nl == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int idx = nl.indexOf(node);
                if (idx == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                int firstIdx = idx;
                LinkedList<Node> toDelete = new LinkedList<Node>();
                int adjIdx = idx;
                while (--adjIdx >= 0) {
                    Node child = this.nodeList.get(adjIdx);
                    if (!(child instanceof Text)) continue;
                    firstIdx = adjIdx;
                    toDelete.add(child);
                }
                int length = this.nodeList.size();
                int adjIdx2 = idx;
                while (++adjIdx2 < length) {
                    Node child = this.nodeList.get(adjIdx2);
                    if (!(child instanceof Text)) continue;
                    toDelete.add(child);
                }
                this.nodeList.removeAll(toDelete);
                DOMTextImpl textNode = new DOMTextImpl(textContent);
                textNode.setOwnerDocument(this.document);
                textNode.setParentImpl(this);
                this.nodeList.add(firstIdx, textNode);
                DOMTextImpl dOMTextImpl = textNode;
                return dOMTextImpl;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text node) {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                ArrayList<Node> nl = this.nodeList;
                if (nl == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int idx = nl.indexOf(node);
                if (idx == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                StringBuffer textBuffer = new StringBuffer();
                int firstIdx = idx;
                LinkedList<Node> toDelete = new LinkedList<Node>();
                int adjIdx = idx;
                while (--adjIdx >= 0) {
                    Node child = this.nodeList.get(adjIdx);
                    if (!(child instanceof Text)) continue;
                    firstIdx = adjIdx;
                    toDelete.add(child);
                    textBuffer.append(((Text)child).getNodeValue());
                }
                int length = this.nodeList.size();
                int adjIdx2 = idx;
                while (++adjIdx2 < length) {
                    Node child = this.nodeList.get(adjIdx2);
                    if (!(child instanceof Text)) continue;
                    toDelete.add(child);
                    textBuffer.append(((Text)child).getNodeValue());
                }
                this.nodeList.removeAll(toDelete);
                DOMTextImpl textNode = new DOMTextImpl(textBuffer.toString());
                textNode.setOwnerDocument(this.document);
                textNode.setParentImpl(this);
                this.nodeList.add(firstIdx, textNode);
                DOMTextImpl dOMTextImpl = textNode;
                return dOMTextImpl;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return "HTML".equals(feature) && version.compareTo("4.01") <= 0;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean equalAttributes(Node arg) {
        return false;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return arg instanceof DOMNodeImpl && this.getNodeType() == arg.getNodeType() && Objects.equals(this.getNodeName(), arg.getNodeName()) && Objects.equals(this.getNodeValue(), arg.getNodeValue()) && Objects.equals(this.getLocalName(), arg.getLocalName()) && Objects.equals(this.nodeList, ((DOMNodeImpl)arg).nodeList) && this.equalAttributes(arg);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return namespaceURI == null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl != null) {
                Iterator<Node> i = nl.iterator();
                LinkedList<Node> textNodes = new LinkedList<Node>();
                boolean prevText = false;
                while (i.hasNext()) {
                    Node node = i.next();
                    if (node.getNodeType() == 3) {
                        if (prevText) continue;
                        prevText = true;
                        textNodes.add(node);
                        continue;
                    }
                    prevText = false;
                }
                for (Text text : textNodes) {
                    this.replaceAdjacentTextNodes(text);
                }
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public UserAgentContext getUserAgentContext() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getUserAgentContext();
        }
        return null;
    }

    public HtmlRendererContext getHtmlRendererContext() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getHtmlRendererContext();
        }
        return null;
    }

    protected final void setParentImpl(Node parent) {
        this.parentNode = parent;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    @Override
    public URL getFullURL(String spec) throws MalformedURLException {
        Document doc = this.document;
        String cleanSpec = Urls.encodeIllegalCharacters(spec);
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getFullURL(cleanSpec);
        }
        return new URL(cleanSpec);
    }

    public URL getDocumentURL() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getDocumentURL();
        }
        return null;
    }

    @Override
    public Object getDocumentItem(String name) {
        Document document = this.document;
        return document == null ? null : document.getUserData(name);
    }

    @Override
    public void setDocumentItem(String name, Object value) {
        Document document = this.document;
        if (document == null) {
            return;
        }
        document.setUserData(name, value, null);
    }

    @Override
    public final boolean isEqualOrDescendentOf(ModelNode otherContext) {
        if (otherContext == this) {
            return true;
        }
        Node parent = this.getParentNode();
        if (parent instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)parent).isEqualOrDescendentOf(otherContext);
        }
        return false;
    }

    @Override
    public final ModelNode getParentModelNode() {
        return (ModelNode)((Object)this.parentNode);
    }

    @Override
    public void warn(String message, Throwable err) {
        logger.log(Level.WARNING, message, err);
    }

    public void warn(String message) {
        logger.log(Level.WARNING, message);
    }

    public void informSizeInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.sizeInvalidated(this);
        }
    }

    public void informLookInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.lookInvalidated(this);
        }
    }

    public void informPositionInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.positionInParentInvalidated(this);
        }
    }

    public void informInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.invalidated(this);
        }
    }

    public void informStructureInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.structureInvalidated(this);
        }
    }

    protected void informNodeLoaded() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.nodeLoaded(this);
        }
    }

    protected void informExternalScriptLoading() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.externalScriptLoading(this);
        }
    }

    public void informLayoutInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.invalidated(this);
        }
    }

    public void informDocumentInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.allInvalidated(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenderState getRenderState() {
        Object object = this.getTreeLock();
        synchronized (object) {
            RenderState rs = this.renderState;
            if (rs != INVALID_RENDER_STATE) {
                return rs;
            }
            Node parent = this.parentNode;
            if (parent != null || this instanceof Document) {
                RenderState prs = this.getParentRenderState(parent);
                this.renderState = rs = this.createRenderState(prs);
                return rs;
            }
            return null;
        }
    }

    protected final RenderState getParentRenderState(Object parent) {
        if (parent instanceof DOMNodeImpl) {
            return ((DOMNodeImpl)parent).getRenderState();
        }
        return null;
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return prevRenderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetRenderState() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.renderState != INVALID_RENDER_STATE) {
                this.renderState = INVALID_RENDER_STATE;
                ArrayList<Node> nl = this.nodeList;
                if (nl != null) {
                    Iterator<Node> i = nl.iterator();
                    while (i.hasNext()) {
                        ((DOMNodeImpl)i.next()).forgetRenderState();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerHTML() {
        StringBuffer buffer = new StringBuffer();
        DOMNodeImpl dOMNodeImpl = this;
        synchronized (dOMNodeImpl) {
            this.appendInnerHTMLImpl(buffer);
        }
        return buffer.toString();
    }

    protected void appendInnerHTMLImpl(StringBuffer buffer) {
        int size;
        ArrayList<Node> nl = this.nodeList;
        if (nl != null && (size = nl.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                Node child = nl.get(i);
                if (child instanceof HTMLElementImpl) {
                    ((HTMLElementImpl)child).appendOuterHTMLImpl(buffer);
                    continue;
                }
                if (child instanceof Comment) {
                    buffer.append("<!--" + ((Comment)child).getTextContent() + "-->");
                    continue;
                }
                if (child instanceof Text) {
                    String text = ((Text)child).getTextContent();
                    String encText = this.htmlEncodeChildText(text);
                    buffer.append(encText);
                    continue;
                }
                if (!(child instanceof ProcessingInstruction)) continue;
                buffer.append(child.toString());
            }
        }
    }

    protected String htmlEncodeChildText(String text) {
        return Strings.strictHtmlEncode(text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerText() {
        StringBuffer buffer = new StringBuffer();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.appendInnerTextImpl(buffer);
        }
        return buffer.toString();
    }

    protected void appendInnerTextImpl(StringBuffer buffer) {
        ArrayList<Node> nl = this.nodeList;
        if (nl == null) {
            return;
        }
        int size = nl.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            Node child = nl.get(i);
            if (child instanceof DOMElementImpl) {
                ((DOMElementImpl)child).appendInnerTextImpl(buffer);
            }
            if (child instanceof Comment || !(child instanceof Text)) continue;
            buffer.append(((Text)child).getTextContent());
        }
    }

    public Object getTreeLock() {
        return this.treeLock;
    }

    public void setTreeLock(Object treeLock) {
        this.treeLock = treeLock;
    }
}

