/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.lobobrowser.html.domimpl.DOMAttrImpl;
import org.lobobrowser.html.domimpl.DOMAttrMapImpl;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.DOMNodeListImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.w3c.HTMLMenuElement;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class DOMElementImpl
extends DOMNodeImpl
implements Element {
    private final String name;
    private String id;
    protected Map<String, String> attributes;

    public DOMElementImpl(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedNodeMap getAttributes() {
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attrs = this.attributes;
            if (attrs == null) {
                this.attributes = attrs = new HashMap<String, String>();
            }
            return new DOMAttrMapImpl(this, this.attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttributes() {
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attrs = this.attributes;
            return attrs == null ? false : !attrs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalAttributes(Node arg) {
        if (arg instanceof DOMElementImpl) {
            DOMElementImpl dOMElementImpl = this;
            synchronized (dOMElementImpl) {
                Map<String, String> attrs2;
                Map<String, String> attrs1 = this.attributes;
                if (attrs1 == null) {
                    attrs1 = Collections.emptyMap();
                }
                if ((attrs2 = ((DOMElementImpl)arg).attributes) == null) {
                    attrs2 = Collections.emptyMap();
                }
                return Objects.equals(attrs1, attrs2);
            }
        }
        return false;
    }

    public String getId() {
        String id = this.id;
        return id == null ? "" : id;
    }

    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    public String getLang() {
        return this.getAttribute("lang");
    }

    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    public String getDir() {
        return this.getAttribute("dir");
    }

    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    public boolean getHidden() {
        return this.getAttribute("hidden") == null;
    }

    public String getContentEditable() {
        return this.getAttribute("contenteditable");
    }

    public void setContentEditable(String contenteditable) {
        this.setAttribute("contenteditable", contenteditable);
    }

    public String getSpellcheck() {
        return this.getAttribute("spellcheck");
    }

    public void setSpellcheck(String spellcheck) {
        this.setAttribute("spellcheck", spellcheck);
    }

    public boolean getDraggable() {
        String draggable = this.getAttribute("draggable");
        if (draggable == null) {
            return false;
        }
        return new Boolean(draggable);
    }

    public void setDraggable(boolean draggable) {
        this.setAttribute("draggable", String.valueOf(draggable));
    }

    public boolean getIsContentEditable() {
        String content = this.getAttribute("contenteditable");
        if (content == null) {
            return false;
        }
        return new Boolean(content);
    }

    public boolean getDisabled() {
        return this.getAttribute("disabled") == null;
    }

    public boolean getChecked() {
        return this.getAttribute("checked") == null;
    }

    public boolean getItemScope() {
        String itemscope = this.getAttribute("itemscope");
        if (itemscope == null) {
            return false;
        }
        return new Boolean(itemscope);
    }

    public void setItemScope(boolean itemscope) {
        this.setAttribute("itemscope", String.valueOf(itemscope));
    }

    public String getItemType() {
        return this.getAttribute("itemtype");
    }

    public void setItemType(String itemType) {
        this.setAttribute("itemtype", itemType);
    }

    public String getItemId() {
        return this.getAttribute("itemid");
    }

    public void setItemId(String itemId) {
        this.setAttribute("itemid", itemId);
    }

    public int getTabIndex() {
        try {
            return Integer.parseInt(this.getAttribute("tabindex"));
        }
        catch (Exception err) {
            return 0;
        }
    }

    public void setTabIndex(int tabIndex) {
        this.setAttribute("tabindex", String.valueOf(tabIndex));
    }

    public String getAccessKey() {
        return this.getAttribute("accesskey");
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute("accesskey", accessKey);
    }

    public HTMLMenuElement getContextMenu() {
        return null;
    }

    public void setContextMenu(HTMLMenuElement contextMenu) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getAttribute(String name) {
        String normalName = this.normalizeAttributeName(name);
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attributes = this.attributes;
            return attributes == null ? null : attributes.get(normalName);
        }
    }

    private Attr getAttr(String normalName, String value) {
        return new DOMAttrImpl(normalName, value, true, this, "id".equals(normalName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attr getAttributeNode(String name) {
        String normalName = this.normalizeAttributeName(name);
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attributes = this.attributes;
            String value = attributes == null ? null : attributes.get(normalName);
            return value == null ? null : this.getAttr(normalName, value);
        }
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    protected static boolean isTagName(Node node, String name) {
        return node.getNodeName().equalsIgnoreCase(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeList getElementsByTagName(String name) {
        boolean matchesAll = "*".equals(name);
        LinkedList descendents = new LinkedList();
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                for (Object child : nl) {
                    if (!(child instanceof Element)) continue;
                    Element childElement = (Element)child;
                    if (matchesAll || DOMElementImpl.isTagName(childElement, name)) {
                        descendents.add(child);
                    }
                    NodeList sublist = childElement.getElementsByTagName(name);
                    int length = sublist.getLength();
                    for (int idx = 0; idx < length; ++idx) {
                        descendents.add(sublist.item(idx));
                    }
                }
            }
        }
        return new DOMNodeListImpl(descendents);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "Namespaces not supported");
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute(String name) {
        String normalName = this.normalizeAttributeName(name);
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attributes = this.attributes;
            return attributes == null ? false : attributes.containsKey(normalName);
        }
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attributes = this.attributes;
            if (attributes == null) {
                return;
            }
            attributes.remove(normalName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        String normalName = this.normalizeAttributeName(oldAttr.getName());
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attributes = this.attributes;
            if (attributes == null) {
                return null;
            }
            String oldValue = attributes.remove(normalName);
            Attr attr = oldValue == null ? null : this.getAttr(normalName, oldValue);
            return attr;
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    protected void assignAttributeField(String normalName, String value) {
        boolean isName = false;
        if ("id".equals(normalName) || (isName = "name".equals(normalName))) {
            HTMLDocumentImpl document;
            if (!isName) {
                this.id = value;
            }
            if ((document = (HTMLDocumentImpl)this.document) != null) {
                document.setElementById(value, this);
                if (isName) {
                    String oldName = this.getAttribute("name");
                    if (oldName != null) {
                        document.removeNamedItem(oldName);
                    }
                    document.setNamedItem(value, this);
                }
            }
        }
    }

    protected final String normalizeAttributeName(String name) {
        return name.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, String value) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            Map<String, String> attribs = this.attributes;
            if (attribs == null) {
                this.attributes = attribs = new HashMap<String, String>(2);
            }
            attribs.put(normalName, value);
        }
        this.assignAttributeField(normalName, value);
    }

    public void setAttributeImpl(String name, String value) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        Map<String, String> attribs = this.attributes;
        if (attribs == null) {
            this.attributes = attribs = new HashMap<String, String>(2);
        }
        this.assignAttributeField(normalName, value);
        attribs.put(normalName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        String normalName = this.normalizeAttributeName(newAttr.getName());
        String value = newAttr.getValue();
        DOMElementImpl dOMElementImpl = this;
        synchronized (dOMElementImpl) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(normalName, value);
        }
        this.assignAttributeField(normalName, value);
        return newAttr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        if (!"id".equals(normalName)) {
            throw new DOMException(9, "IdAttribute can't be anything other than ID");
        }
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        String normalName = this.normalizeAttributeName(idAttr.getName());
        if (!"id".equals(normalName)) {
            throw new DOMException(9, "IdAttribute can't be anything other than ID");
        }
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRawInnerText(boolean includeComment) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                Iterator i = nl.iterator();
                StringBuffer sb = null;
                while (i.hasNext()) {
                    Comment cn;
                    String txt;
                    Object node = i.next();
                    if (node instanceof Text) {
                        Text tn = (Text)node;
                        txt = tn.getNodeValue();
                        if ("".equals(txt)) continue;
                        if (sb == null) {
                            sb = new StringBuffer();
                        }
                        sb.append(txt);
                        continue;
                    }
                    if (node instanceof DOMElementImpl) {
                        DOMElementImpl en = (DOMElementImpl)node;
                        txt = en.getRawInnerText(includeComment);
                        if ("".equals(txt)) continue;
                        if (sb == null) {
                            sb = new StringBuffer();
                        }
                        sb.append(txt);
                        continue;
                    }
                    if (!includeComment || !(node instanceof Comment) || "".equals(txt = (cn = (Comment)node).getNodeValue())) continue;
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    sb.append(txt);
                }
                return sb == null ? "" : sb.toString();
            }
            return "";
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNodeName());
        sb.append(" [");
        NamedNodeMap attribs = this.getAttributes();
        int length = attribs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attribs.item(i);
            sb.append(attr.getNodeName());
            sb.append('=');
            sb.append(attr.getNodeValue());
            if (i + 1 >= length) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerText(String newText) {
        Document document = this.document;
        if (document == null) {
            this.warn("setInnerText(): Element " + this + " does not belong to a document.");
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                nl.clear();
            }
        }
        Text textNode = document.createTextNode(newText);
        this.appendChild(textNode);
    }

    @Override
    protected Node createSimilarNode() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        return doc == null ? null : doc.createElement(this.getTagName());
    }

    @Override
    protected String htmlEncodeChildText(String text) {
        if (HtmlParser.isDecodeEntities(this.name)) {
            return Strings.strictHtmlEncode(text, false);
        }
        return text;
    }
}

