/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.domimpl.DOMAttrImpl;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAttrMapImpl
extends AbstractScriptableDelegate
implements NamedNodeMap {
    private final Map<String, Node> attributes = new HashMap<String, Node>();
    private final ArrayList attributeList = new ArrayList();

    public DOMAttrMapImpl(Element owner, Map attribs) {
        for (Map.Entry entry : attribs.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            DOMAttrImpl attr = new DOMAttrImpl(name, value, true, owner, "ID".equals(name));
            this.attributes.put(name, attr);
            this.attributeList.add(attr);
        }
    }

    @Override
    public int getLength() {
        return this.attributeList.size();
    }

    @Override
    public Node getNamedItem(String name) {
        return this.attributes.get(name);
    }

    public Node namedItem(String name) {
        return this.getNamedItem(name);
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "No namespace support");
    }

    @Override
    public Node item(int index) {
        try {
            return (Node)this.attributeList.get(index);
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        return this.attributes.remove(name);
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "No namespace support");
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        Node prevValue = this.attributes.put(arg.getNodeName(), arg);
        if (prevValue != null) {
            this.attributeList.remove(prevValue);
        }
        this.attributeList.add(arg);
        return arg;
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DOMException(9, "No namespace support");
    }
}

