/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.control.RUIControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;

public class InputButtonControl
extends BaseInputControl {
    private static final long serialVersionUID = 1L;
    private final JButton widget;

    public InputButtonControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JButton widget = new JButton();
        widget.setContentAreaFilled(false);
        this.widget = widget;
        if (modelNode.getTitle() != null) {
            widget.setToolTipText(modelNode.getTitle());
        }
        widget.setVisible(modelNode.getHidden());
        widget.applyComponentOrientation(this.direction(modelNode.getDir()));
        widget.setEnabled(!modelNode.getDisabled());
        this.add(widget);
        widget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HtmlController.getInstance().onPressed(InputButtonControl.this.controlElement, null, 0, 0);
            }
        });
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        HTMLInputElementImpl element;
        String text;
        super.reset(availWidth, availHeight);
        RUIControl ruiControl = this.ruicontrol;
        JButton button = this.widget;
        button.setContentAreaFilled(!ruiControl.hasBackground());
        Color foregroundColor = ruiControl.getForegroundColor();
        if (foregroundColor != null) {
            button.setForeground(foregroundColor);
        }
        if ((text = (element = (HTMLInputElementImpl)this.controlElement).getAttribute("value")) == null || text.length() == 0) {
            String type = element.getType();
            text = "submit".equalsIgnoreCase(type) ? "Submit Query" : ("reset".equalsIgnoreCase(type) ? "Reset" : "");
        }
        button.setText(text);
    }

    @Override
    public void click() {
        this.widget.doClick();
    }

    @Override
    public String getValue() {
        return this.widget.getText();
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    @Override
    public void setValue(String value) {
        this.widget.setText(value);
    }

    @Override
    public void resetInput() {
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }
}

