/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import org.lobobrowser.html.control.BaseControl;
import org.lobobrowser.html.domimpl.HTMLCanvasElementImpl;

public class CanvasControl
extends BaseControl {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private ArrayList<int[]> listRectValues;
    private ArrayList<int[]> listStrokeRectValues;
    private ArrayList<Object[]> listTextValues;
    private float[] fractions;
    private Color[] colors;
    private Double[] linearValues;
    private int method;
    private GeneralPath path;
    private int lineWidth;
    private Color color;

    public CanvasControl(HTMLCanvasElementImpl modelNode) {
        super(modelNode);
        this.width = modelNode.getWidth();
        this.height = modelNode.getHeight();
        this.listRectValues = modelNode.getListRectValues();
        this.listTextValues = modelNode.getListTextValues();
        this.listStrokeRectValues = modelNode.getListStrokeRectValues();
        this.method = modelNode.getMethod();
        this.path = modelNode.getPath();
        this.lineWidth = modelNode.getLineWidth();
        this.color = modelNode.getColor();
        this.linearValues = modelNode.getLinearValues();
        this.colors = modelNode.getColors();
        this.fractions = modelNode.getFractions();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawRect(0, 0, new Integer(this.width), new Integer(this.height));
        switch (this.method) {
            case 1: {
                this.fillRect(g2d);
                break;
            }
            case 2: {
                this.fillText(g2d);
                break;
            }
            case 3: {
                this.strokeRect(g2d);
                break;
            }
            case 5: {
                this.stroke(g2d);
                break;
            }
        }
    }

    private void fillRect(Graphics2D g) {
        for (int i = 0; i < this.listRectValues.size(); ++i) {
            int[] val = this.listRectValues.get(i);
            g.setColor(this.color);
            this.paint(g);
            g.fillRect(val[0], val[1], val[2], val[3]);
        }
    }

    private void fillText(Graphics2D g) {
        for (int i = 0; i < this.listTextValues.size(); ++i) {
            Object[] val = this.listTextValues.get(i);
            g.setColor(this.color);
            this.paint(g);
            g.drawString((String)val[0], (int)((Integer)val[1]), (int)((Integer)val[2]));
        }
    }

    private void strokeRect(Graphics2D g) {
        for (int i = 0; i < this.listStrokeRectValues.size(); ++i) {
            int[] val = this.listStrokeRectValues.get(i);
            g.setStroke(new BasicStroke(val[4]));
            g.setColor(this.color);
            this.paint(g);
            g.drawRect(val[0], val[1], val[2], val[3]);
        }
    }

    private void stroke(Graphics2D g) {
        if (this.path != null) {
            g.setStroke(new BasicStroke(this.lineWidth));
            g.setColor(this.color);
            this.paint(g);
            g.draw(this.path);
        }
    }

    private void paint(Graphics2D g) {
        if (this.colors != null) {
            Arrays.sort(this.fractions);
            LinearGradientPaint paint = new LinearGradientPaint(this.linearValues[0].floatValue(), this.linearValues[1].floatValue(), this.linearValues[2].floatValue(), this.linearValues[3].floatValue(), this.fractions, this.colors);
            g.setPaint(paint);
        }
    }
}

