/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.control.RUIControl;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.w3c.HTMLElement;

public class BrowserFrameUIControl
implements UIControl {
    private final Component component;
    private final HTMLElement element;
    private final BrowserFrame browserFrame;
    private RUIControl ruiControl;
    private int availWidth;
    private int availHeight;

    public BrowserFrameUIControl(HTMLElement element, BrowserFrame browserFrame) {
        this.component = browserFrame.getComponent();
        this.browserFrame = browserFrame;
        this.element = element;
    }

    @Override
    public int getVAlign() {
        return 5;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    @Override
    public Color getBackgroundColor() {
        return this.component.getBackground();
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        this.availWidth = availWidth;
        this.availHeight = availHeight;
        RUIControl ruiControl = this.ruiControl;
        if (ruiControl != null) {
            int value;
            ModelNode node = ruiControl.getModelNode();
            HTMLElement element = (HTMLElement)((Object)node);
            RenderState renderState = node.getRenderState();
            HtmlInsets insets = null;
            String marginwidth = element.getAttribute("marginWidth");
            String marginheight = element.getAttribute("marginHeight");
            if (marginwidth != null && marginwidth.length() != 0) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                if ((marginwidth = marginwidth.trim()).endsWith("%")) {
                    try {
                        value = Integer.parseInt(marginwidth.substring(0, marginwidth.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                    insets.left = value;
                    insets.right = value;
                    insets.leftType = 3;
                    insets.rightType = 3;
                } else {
                    try {
                        value = Integer.parseInt(marginwidth);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                    insets.left = value;
                    insets.right = value;
                    insets.leftType = 1;
                    insets.rightType = 1;
                }
            }
            if (marginheight != null && marginheight.length() != 0) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                if ((marginheight = marginheight.trim()).endsWith("%")) {
                    try {
                        value = Integer.parseInt(marginheight.substring(0, marginheight.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                    insets.top = value;
                    insets.bottom = value;
                    insets.topType = 3;
                    insets.bottomType = 3;
                } else {
                    try {
                        value = Integer.parseInt(marginheight);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                    insets.top = value;
                    insets.bottom = value;
                    insets.topType = 1;
                    insets.bottomType = 1;
                }
            }
            Insets awtMarginInsets = insets == null ? null : insets.getSimpleAWTInsets(availWidth, availHeight);
            int overflowX = renderState.getOverflowX();
            int overflowY = renderState.getOverflowY();
            if (awtMarginInsets != null) {
                this.browserFrame.setDefaultMarginInsets(awtMarginInsets);
            }
            if (overflowX != 0) {
                this.browserFrame.setDefaultOverflowX(overflowX);
            }
            if (overflowY != 0) {
                this.browserFrame.setDefaultOverflowY(overflowY);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = HtmlValues.getOldSyntaxPixelSize(this.element.getAttribute("width"), this.availWidth, 100);
        int height = HtmlValues.getOldSyntaxPixelSize(this.element.getAttribute("height"), this.availHeight, 100);
        return new Dimension(width, height);
    }

    @Override
    public void invalidate() {
        this.component.invalidate();
    }

    @Override
    public void paint(Graphics g) {
        this.component.paint(g);
    }

    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return false;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.component.setBounds(x, y, width, height);
    }

    @Override
    public void setRUIControl(RUIControl ruicontrol) {
        this.ruiControl = ruicontrol;
    }
}

