/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSFormat;
import com.steadystate.css.dom.CSSOMObjectImpl;
import com.steadystate.css.dom.CounterImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.RGBColorImpl;
import com.steadystate.css.dom.RectImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LexicalUnitImpl;
import com.steadystate.css.userdata.UserDataConstants;
import com.steadystate.css.util.LangUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSValueImpl
extends CSSOMObjectImpl
implements CSSPrimitiveValue,
CSSValueList {
    private static final long serialVersionUID = 406281136418322579L;
    private Object value_;

    public Object getValue() {
        return this.value_;
    }

    public void setValue(Object value) {
        this.value_ = value;
    }

    public CSSValueImpl(LexicalUnit value, boolean forcePrimitive) {
        Locator locator;
        LexicalUnit parameters = null;
        try {
            parameters = value.getParameters();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.value_ = !forcePrimitive && value.getNextLexicalUnit() != null ? this.getValues(value) : (parameters != null ? (value.getLexicalUnitType() == 38 ? new RectImpl(value.getParameters()) : (value.getLexicalUnitType() == 27 ? new RGBColorImpl(value.getParameters()) : (value.getLexicalUnitType() == 25 ? new CounterImpl(false, value.getParameters()) : (value.getLexicalUnitType() == 26 ? new CounterImpl(true, value.getParameters()) : value)))) : value);
        if (value instanceof LexicalUnitImpl && (locator = ((LexicalUnitImpl)value).getLocator()) != null) {
            this.setUserData(UserDataConstants.KEY_LOCATOR, locator);
        }
    }

    public CSSValueImpl() {
    }

    private List<CSSValueImpl> getValues(LexicalUnit value) {
        ArrayList<CSSValueImpl> values = new ArrayList<CSSValueImpl>();
        for (LexicalUnit lu = value; lu != null; lu = lu.getNextLexicalUnit()) {
            if (lu.getLexicalUnitType() == 0 || lu.getLexicalUnitType() == 4) continue;
            values.add(new CSSValueImpl(lu, true));
        }
        return values;
    }

    public CSSValueImpl(LexicalUnit value) {
        this(value, false);
    }

    @Override
    public String getCssText() {
        return this.getCssText(null);
    }

    public String getCssText(CSSFormat format) {
        if (this.getCssValueType() == 2) {
            StringBuilder sb = new StringBuilder();
            List list = (List)this.value_;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                CSSValueImpl cssValue = (CSSValueImpl)o;
                if (cssValue.value_ instanceof LexicalUnit) {
                    LexicalUnit lu = (LexicalUnit)cssValue.value_;
                    sb.append(lu.toString());
                    LexicalUnit prev = lu;
                    lu = lu.getNextLexicalUnit();
                    if (lu != null && (lu.getLexicalUnitType() == 0 || lu.getLexicalUnitType() == 4 || prev.getLexicalUnitType() == 4)) {
                        sb.append(lu.toString());
                    }
                } else {
                    sb.append(o);
                }
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
        return this.value_ != null ? this.value_.toString() : "";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSValueImpl v2 = (CSSValueImpl)parser.parsePropertyValue(is);
            this.value_ = v2.value_;
            this.setUserDataMap(v2.getUserDataMap());
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public short getCssValueType() {
        if (this.value_ instanceof List) {
            return 2;
        }
        if (this.value_ instanceof LexicalUnit && ((LexicalUnit)this.value_).getLexicalUnitType() == 12) {
            return 0;
        }
        return 1;
    }

    @Override
    public short getPrimitiveType() {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            switch (lu.getLexicalUnitType()) {
                case 12: {
                    return 21;
                }
                case 13: 
                case 14: {
                    return 1;
                }
                case 15: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 17: {
                    return 5;
                }
                case 18: {
                    return 8;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 2;
                }
                case 24: {
                    return 20;
                }
                case 25: {
                    return 23;
                }
                case 28: {
                    return 11;
                }
                case 29: {
                    return 13;
                }
                case 30: {
                    return 12;
                }
                case 31: {
                    return 14;
                }
                case 32: {
                    return 15;
                }
                case 33: {
                    return 16;
                }
                case 34: {
                    return 17;
                }
                case 35: {
                    return 21;
                }
                case 36: {
                    return 19;
                }
                case 37: {
                    return 22;
                }
                case 39: 
                case 40: 
                case 41: {
                    return 19;
                }
                case 42: {
                    return 18;
                }
            }
            return 0;
        }
        if (this.value_ instanceof RectImpl) {
            return 24;
        }
        if (this.value_ instanceof RGBColorImpl) {
            return 25;
        }
        if (this.value_ instanceof CounterImpl) {
            return 23;
        }
        return 0;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this.value_ = LexicalUnitImpl.createNumber(null, floatValue);
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            return lu.getFloatValue();
        }
        throw new DOMExceptionImpl(15, 10);
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: {
                this.value_ = LexicalUnitImpl.createString(null, stringValue);
                break;
            }
            case 20: {
                this.value_ = LexicalUnitImpl.createURI(null, stringValue);
                break;
            }
            case 21: {
                this.value_ = LexicalUnitImpl.createIdent(null, stringValue);
                break;
            }
            case 22: {
                throw new DOMExceptionImpl(9, 19);
            }
            default: {
                throw new DOMExceptionImpl(15, 11);
            }
        }
    }

    @Override
    public String getStringValue() throws DOMException {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            if (lu.getLexicalUnitType() == 35 || lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 24 || lu.getLexicalUnitType() == 12 || lu.getLexicalUnitType() == 37) {
                return lu.getStringValue();
            }
        } else if (this.value_ instanceof List) {
            return null;
        }
        throw new DOMExceptionImpl(15, 11);
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        if (this.value_ instanceof Counter) {
            return (Counter)this.value_;
        }
        throw new DOMExceptionImpl(15, 12);
    }

    @Override
    public Rect getRectValue() throws DOMException {
        if (this.value_ instanceof Rect) {
            return (Rect)this.value_;
        }
        throw new DOMExceptionImpl(15, 13);
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        if (this.value_ instanceof RGBColor) {
            return (RGBColor)this.value_;
        }
        throw new DOMExceptionImpl(15, 14);
    }

    @Override
    public int getLength() {
        if (this.value_ instanceof List) {
            return ((List)this.value_).size();
        }
        return 0;
    }

    @Override
    public CSSValue item(int index) {
        if (this.value_ instanceof List) {
            List list = (List)this.value_;
            return (CSSValue)list.get(index);
        }
        return null;
    }

    public String toString() {
        return this.getCssText(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSValue)) {
            return false;
        }
        CSSValue cv = (CSSValue)obj;
        return super.equals(obj) && this.getCssValueType() == cv.getCssValueType() && LangUtils.equals(this.getCssText(), cv.getCssText());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.value_);
        return hash;
    }
}

