/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.utils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.ig.psiutils.ParenthesesUtils;

class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = exp;
        while (ancestor.getParent() instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)ancestor.getParent();
        }
        return ancestor.getParent() instanceof PsiPrefixExpression && (prefixAncestor = (PsiPrefixExpression)ancestor.getParent()).getOperationTokenType().equals(JavaTokenType.EXCL);
    }

    public static PsiExpression findNegation(PsiExpression exp) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = exp;
        while (ancestor.getParent() instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)ancestor.getParent()).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isNegation(PsiExpression exp) {
        if (!(exp instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)exp;
        return prefixExp.getOperationTokenType().equals(JavaTokenType.EXCL);
    }

    public static PsiExpression getNegated(PsiExpression exp) {
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)exp;
        PsiExpression operand = prefixExp.getOperand();
        return ParenthesesUtils.stripParentheses((PsiExpression)operand);
    }
}

