/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model.beans;

import com.intellij.guice.utils.GuiceUtils;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BindDescriptor {
    private PsiMethodCallExpression myCallExpression;
    private NullableLazyValue<PsiClass> myBoundClass;
    private NullableLazyValue<PsiClass> myBindingClass;

    public BindDescriptor(@NotNull PsiMethodCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/guice/model/beans/BindDescriptor", "<init>"));
        }
        this.myBoundClass = new NullableLazyValue<PsiClass>(){

            @Nullable
            protected PsiClass compute() {
                return GuiceUtils.findImplementedClassForBinding(BindDescriptor.this.getBindExpression());
            }
        };
        this.myBindingClass = new NullableLazyValue<PsiClass>(){

            @Nullable
            protected PsiClass compute() {
                return BindDescriptor.this.calculateBindingClass();
            }
        };
        this.myCallExpression = callExpression;
    }

    @Nullable
    public PsiClass getBoundClass() {
        return (PsiClass)this.myBoundClass.getValue();
    }

    @Nullable
    public PsiClass getBindingClass() {
        return (PsiClass)this.myBindingClass.getValue();
    }

    @Nullable
    public abstract PsiClass calculateBindingClass();

    @NotNull
    public PsiMethodCallExpression getBindExpression() {
        PsiMethodCallExpression psiMethodCallExpression = this.myCallExpression;
        if (psiMethodCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/beans/BindDescriptor", "getBindExpression"));
        }
        return psiMethodCallExpression;
    }

    public boolean isValid() {
        return this.myCallExpression.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindDescriptor)) {
            return false;
        }
        BindDescriptor that = (BindDescriptor)o;
        return !(this.myCallExpression != null ? !this.myCallExpression.equals(that.myCallExpression) : that.myCallExpression != null);
    }

    public int hashCode() {
        return this.myCallExpression != null ? this.myCallExpression.hashCode() : 0;
    }
}

