/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.intentions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.intentions.MutablyNamedIntention;
import com.intellij.guice.intentions.PsiElementPredicate;
import com.intellij.guice.intentions.ToggleInjectionRequiredPredicate;
import com.intellij.guice.utils.MutationUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ToggleInjectionRequiredIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAnnotation annotation = (PsiAnnotation)element;
        PsiAnnotationMemberValue value = annotation.findAttributeValue("optional");
        if (value == null) {
            return GuiceBundle.message("make.injection.optional", new Object[0]);
        }
        if (value instanceof PsiLiteralExpression) {
            if (value.getText().equals("false")) {
                return GuiceBundle.message("make.injection.optional", new Object[0]);
            }
            return GuiceBundle.message("make.injection.mandatory", new Object[0]);
        }
        return GuiceBundle.message("toggle.required", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = GuiceBundle.message("toggle.injection.required.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/ToggleInjectionRequiredIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ToggleInjectionRequiredPredicate toggleInjectionRequiredPredicate = new ToggleInjectionRequiredPredicate();
        if (toggleInjectionRequiredPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/ToggleInjectionRequiredIntention", "getElementPredicate"));
        }
        return toggleInjectionRequiredPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/guice/intentions/ToggleInjectionRequiredIntention", "processIntention"));
        }
        PsiAnnotation annotation = (PsiAnnotation)element;
        PsiAnnotationMemberValue value = annotation.findAttributeValue("optional");
        if (value == null) {
            MutationUtils.replaceAnnotation(annotation, "@com.google.inject.Inject(optional = true)");
        } else if (value instanceof PsiLiteralExpression) {
            if (value.getText().equals("false")) {
                MutationUtils.replaceAnnotation(annotation, "@com.google.inject.Inject(optional = true)");
            } else {
                MutationUtils.replaceAnnotation(annotation, "@com.google.inject.Inject");
            }
        } else {
            MutationUtils.negateExpression((PsiExpression)value);
        }
    }
}

