/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.intentions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.intentions.PsiElementPredicate;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;

public class MoveProviderBindingToClassPredicate
implements PsiElementPredicate {
    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!GuiceUtils.isBinding(element)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (GuiceUtils.findProvidingClassForBinding(call) == null) {
            return false;
        }
        PsiClass implementedClass = GuiceUtils.findImplementedClassForBinding(call);
        if (implementedClass == null || !implementedClass.getManager().isInProject((PsiElement)implementedClass)) {
            return false;
        }
        return !AnnotationUtil.isAnnotated((PsiModifierListOwner)implementedClass, (String)"com.google.inject.ImplementedBy", (boolean)true) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)implementedClass, (String)"com.google.inject.ProvidedBy", (boolean)true);
    }
}

