/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.inspections.DeleteBindingFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryStaticInjectionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("unnecessary.static.injection.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/UnnecessaryStaticInjectionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return new DeleteBindingFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression[] args;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"requestStaticInjection".equals(methodName)) {
                return;
            }
            for (PsiExpression arg : args = expression.getArgumentList().getExpressions()) {
                PsiClass classToBindStatically;
                PsiTypeElement classTypeElement;
                PsiType classType;
                if (!(arg instanceof PsiClassObjectAccessExpression) || !((classType = (classTypeElement = ((PsiClassObjectAccessExpression)arg).getOperand()).getType()) instanceof PsiClassType) || (classToBindStatically = ((PsiClassType)classType).resolve()) == null || Visitor.classHasStaticInjects(classToBindStatically)) continue;
                this.registerError((PsiElement)classTypeElement, new Object[0]);
            }
        }

        private static boolean classHasStaticInjects(PsiClass aClass) {
            PsiField[] fields;
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!method.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, GuiceAnnotations.INJECTS, (boolean)true)) continue;
                return true;
            }
            for (PsiField field : fields = aClass.getFields()) {
                if (!field.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)field, GuiceAnnotations.INJECTS, (boolean)true)) continue;
                return true;
            }
            return false;
        }
    }
}

