/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.inspections.DeleteBindingFix;
import com.intellij.guice.utils.AnnotationUtils;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantToProviderBindingInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("redundant.to.provider.binding.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/RedundantToProviderBindingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return new DeleteBindingFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toProvider".equals(methodName)) {
                return;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiTypeElement classTypeElement = ((PsiClassObjectAccessExpression)arg).getOperand();
            PsiType classType = classTypeElement.getType();
            if (!(classType instanceof PsiClassType)) {
                return;
            }
            PsiClass referentClass = ((PsiClassType)classType).resolve();
            if (referentClass == null) {
                return;
            }
            PsiClass boundClass = GuiceUtils.findImplementedClassForBinding(expression);
            if (boundClass == null) {
                return;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)boundClass, (String)"com.google.inject.ProvidedBy", (boolean)true)) {
                return;
            }
            PsiAnnotation providedByAnnotation = boundClass.getModifierList().findAnnotation("com.google.inject.ProvidedBy");
            if (providedByAnnotation != null) {
                PsiElement defaultValue = AnnotationUtils.findDefaultValue(providedByAnnotation);
                if (defaultValue == null) {
                    return;
                }
                if (!(defaultValue instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiTypeElement providedByClassElement = ((PsiClassObjectAccessExpression)defaultValue).getOperand();
                PsiType providedByClassType = providedByClassElement.getType();
                if (!(providedByClassType instanceof PsiClassType)) {
                    return;
                }
                PsiClass providedByClass = ((PsiClassType)providedByClassType).resolve();
                if (referentClass.equals(providedByClass)) {
                    this.registerError((PsiElement)classTypeElement, new Object[0]);
                }
            }
        }
    }
}

