/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;

public class GuiceImplicitUsageProvider
implements ImplicitUsageProvider {
    private static Collection<String> GUICE_INJECTION_POINT = ContainerUtil.immutableList((Object[])new String[]{"com.google.inject.Inject", "javax.inject.Inject"});
    private static Collection<String> GUICE_IMPLICIT_READ = ContainerUtil.immutableList((Object[])new String[]{"com.google.inject.Provides"});

    public boolean isImplicitUsage(PsiElement element) {
        return this.isImplicitRead(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        if (element instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), GUICE_INJECTION_POINT)) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), GUICE_IMPLICIT_READ);
        }
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (element instanceof PsiModifierListOwner) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), GUICE_INJECTION_POINT);
        }
        return false;
    }
}

