/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsProcessor
extends BaseRefactoringProcessor {
    private final Module myModule;
    private final Map<AndroidAttributeInfo, String> myAttrMap;
    private final String myStyleName;
    private final XmlTag myStyleTag;
    private final XmlAttributeValue myStyleNameAttrValue;
    private final PsiElement myParentStyleNameAttrValue;
    private final PsiFile myContext;
    private boolean mySearchOnlyInCurrentModule;
    private VirtualFile myFileToScan;

    protected AndroidFindStyleApplicationsProcessor(@NotNull Module module, @NotNull Map<AndroidAttributeInfo, String> attrMap, @NotNull String styleName, @NotNull XmlTag styleTag, @NotNull XmlAttributeValue styleNameAttrValue, @Nullable PsiElement parentStyleNameAttrValue, @Nullable PsiFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "<init>"));
        }
        if (attrMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrMap", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "<init>"));
        }
        if (styleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleName", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "<init>"));
        }
        if (styleTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleTag", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "<init>"));
        }
        if (styleNameAttrValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleNameAttrValue", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "<init>"));
        }
        super(module.getProject());
        this.myModule = module;
        this.myAttrMap = attrMap;
        this.myStyleName = styleName;
        this.myStyleTag = styleTag;
        this.myParentStyleNameAttrValue = parentStyleNameAttrValue;
        this.myStyleNameAttrValue = styleNameAttrValue;
        this.myContext = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "createUsageViewDescriptor"));
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{AndroidFindStyleApplicationsProcessor.this.myStyleTag};
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return "Style to use";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Tags the reference to the style will be added to " + UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount);
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        List<UsageInfo> usages = this.findAllStyleApplications();
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "preprocessUsages"));
        }
        super.preprocessUsages(refUsages);
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)("IDEA has not found any possible applications of style '" + this.myStyleName + "'"), (String)AndroidBundle.message("android.find.style.applications.title", new Object[0]));
            return false;
        }
        return true;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "performRefactoring"));
        }
        HashSet attrsInStyle = new HashSet();
        for (AndroidAttributeInfo info : this.myAttrMap.keySet()) {
            attrsInStyle.add(Pair.create((Object)info.getNamespace(), (Object)info.getName()));
        }
        for (UsageInfo usage : usages) {
            DomElement domElement;
            PsiElement element = usage.getElement();
            DomElement domElement2 = domElement = element instanceof XmlTag ? DomManager.getDomManager((Project)this.myProject).getDomElement((XmlTag)element) : null;
            if (!(domElement instanceof LayoutViewElement)) continue;
            final ArrayList<XmlAttribute> attributesToDelete = new ArrayList<XmlAttribute>();
            for (XmlAttribute attribute : ((XmlTag)element).getAttributes()) {
                if (!attrsInStyle.contains(Pair.create((Object)attribute.getNamespace(), (Object)attribute.getLocalName()))) continue;
                attributesToDelete.add(attribute);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (XmlAttribute attribute : attributesToDelete) {
                        attribute.delete();
                    }
                    ((LayoutViewElement)domElement).getStyle().setStringValue("@style/" + AndroidFindStyleApplicationsProcessor.this.myStyleName);
                }
            });
        }
        PsiFile file = this.myStyleTag.getContainingFile();
        if (file != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        if (this.myContext != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)this.myContext);
        }
    }

    protected String getCommandName() {
        return "Use Style '" + this.myStyleName + "' Where Possible";
    }

    @NotNull
    static List<Module> getAllModulesToScan(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "getAllModulesToScan"));
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module m : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
            if (!m.equals(module) && !ModuleRootManager.getInstance((Module)m).isDependsOn(module)) continue;
            result.add(module);
        }
        ArrayList<Module> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "getAllModulesToScan"));
        }
        return arrayList;
    }

    public Collection<PsiFile> collectFilesToProcess() {
        Project project = this.myModule.getProject();
        ArrayList<VirtualFile> resDirs = new ArrayList<VirtualFile>();
        if (this.mySearchOnlyInCurrentModule) {
            AndroidFindStyleApplicationsProcessor.collectResDir(this.myModule, this.myStyleNameAttrValue, this.myStyleName, resDirs);
        } else {
            for (Module m : AndroidFindStyleApplicationsProcessor.getAllModulesToScan(this.myModule)) {
                AndroidFindStyleApplicationsProcessor.collectResDir(m, this.myStyleNameAttrValue, this.myStyleName, resDirs);
            }
        }
        List<VirtualFile> subdirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.LAYOUT, resDirs.toArray(new VirtualFile[resDirs.size()]));
        ArrayList<VirtualFile> filesToProcess = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : subdirs) {
            for (VirtualFile child : virtualFile.getChildren()) {
                if (child.getFileType() != XmlFileType.INSTANCE || this.myFileToScan != null && !this.myFileToScan.equals(child)) continue;
                filesToProcess.add(child);
            }
        }
        if (filesToProcess.size() == 0) {
            return Collections.emptyList();
        }
        HashSet psiFilesToProcess = new HashSet();
        for (VirtualFile file : filesToProcess) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) continue;
            psiFilesToProcess.add(psiFile);
        }
        CacheManager cacheManager = CacheManager.SERVICE.getInstance((Project)project);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        for (Map.Entry<AndroidAttributeInfo, String> entry : this.myAttrMap.entrySet()) {
            AndroidFindStyleApplicationsProcessor.filterFilesToScan(cacheManager, entry.getKey().getName(), (Set<PsiFile>)psiFilesToProcess, projectScope);
            AndroidFindStyleApplicationsProcessor.filterFilesToScan(cacheManager, entry.getValue(), (Set<PsiFile>)psiFilesToProcess, projectScope);
        }
        return psiFilesToProcess;
    }

    @NotNull
    private List<UsageInfo> findAllStyleApplications() {
        Collection<PsiFile> psiFilesToProcess = this.collectFilesToProcess();
        if (psiFilesToProcess.size() == 0) {
            List<UsageInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "findAllStyleApplications"));
            }
            return list;
        }
        int n = psiFilesToProcess.size();
        boolean i = false;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText("Searching for style applications");
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiFile psiFile : psiFilesToProcess) {
            ProgressManager.checkCanceled();
            VirtualFile vFile = psiFile.getVirtualFile();
            if (vFile == null) continue;
            if (indicator != null) {
                indicator.setFraction((double)i / (double)n);
                indicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)this.myProject));
            }
            this.findAllStyleApplications(vFile, usages);
        }
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "findAllStyleApplications"));
        }
        return arrayList;
    }

    private static void collectResDir(Module module, XmlAttributeValue styleNameAttrValue, String styleName, List<VirtualFile> resDirs) {
        XmlAttributeValue resolvedStyleNameElement;
        AndroidFacet f = AndroidFacet.getInstance(module);
        if (f == null) {
            return;
        }
        List<ValueResourceInfoImpl> resolvedStyles = f.getLocalResourceManager().findValueResourceInfos(ResourceType.STYLE.getName(), styleName, true, false);
        if (resolvedStyles.size() == 1 && (resolvedStyleNameElement = resolvedStyles.get(0).computeXmlElement()) != null && resolvedStyleNameElement.equals(styleNameAttrValue)) {
            resDirs.addAll(f.getAllResourceDirectories());
        }
    }

    private static void filterFilesToScan(CacheManager cacheManager, String s, Set<PsiFile> result, GlobalSearchScope scope) {
        for (String word : StringUtil.getWordsInStringLongestFirst((String)s)) {
            PsiFile[] files = cacheManager.getFilesWithWord(word, (short)255, scope, true);
            result.retainAll(Arrays.asList(files));
        }
    }

    private void findAllStyleApplications(final VirtualFile layoutVFile, final List<UsageInfo> usages) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile layoutFile = PsiManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).findFile(layoutVFile);
                if (!(layoutFile instanceof XmlFile)) {
                    return;
                }
                if (!(DomManager.getDomManager((Project)AndroidFindStyleApplicationsProcessor.this.myProject).getDomFileDescription((XmlFile)layoutFile) instanceof LayoutDomFileDescription)) {
                    return;
                }
                AndroidFindStyleApplicationsProcessor.this.collectPossibleStyleApplications(layoutFile, usages);
                PsiManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).dropFileCaches(layoutFile);
            }
        });
    }

    public void collectPossibleStyleApplications(PsiFile layoutFile, final List<UsageInfo> usages) {
        layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (AndroidFindStyleApplicationsProcessor.this.isPossibleApplicationOfStyle(tag)) {
                    usages.add(new UsageInfo((PsiElement)tag));
                }
            }
        });
    }

    @Nullable
    private static PsiElement getStyleNameAttrValueForTag(@NotNull LayoutViewElement element) {
        PsiElement[] styleElements;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "getStyleNameAttrValueForTag"));
        }
        AndroidResourceReferenceBase styleRef = AndroidDomUtil.getAndroidResourceReference(element.getStyle(), false);
        if (styleRef != null && (styleElements = styleRef.computeTargetElements()).length == 1) {
            return styleElements[0];
        }
        return null;
    }

    private boolean isPossibleApplicationOfStyle(XmlTag candidate) {
        DomElement domCandidate = DomManager.getDomManager((Project)this.myProject).getDomElement(candidate);
        if (!(domCandidate instanceof LayoutViewElement)) {
            return false;
        }
        LayoutViewElement candidateView = (LayoutViewElement)domCandidate;
        HashMap attrsInCandidateMap = new HashMap();
        List<XmlAttribute> attrsInCandidate = AndroidExtractStyleAction.getExtractableAttributes(candidate);
        if (attrsInCandidate.size() < this.myAttrMap.size()) {
            return false;
        }
        for (XmlAttribute xmlAttribute : attrsInCandidate) {
            String attrValue = xmlAttribute.getValue();
            if (attrValue == null) continue;
            attrsInCandidateMap.put(Pair.create((Object)xmlAttribute.getNamespace(), (Object)xmlAttribute.getLocalName()), attrValue);
        }
        for (Map.Entry entry : this.myAttrMap.entrySet()) {
            String ns = ((AndroidAttributeInfo)entry.getKey()).getNamespace();
            String name = ((AndroidAttributeInfo)entry.getKey()).getName();
            String value = (String)entry.getValue();
            String valueInCandidate = (String)attrsInCandidateMap.get(Pair.create((Object)ns, (Object)name));
            if (valueInCandidate != null && valueInCandidate.equals(value)) continue;
            return false;
        }
        if (candidateView.getStyle().getStringValue() != null) {
            if (this.myParentStyleNameAttrValue == null) {
                return false;
            }
            PsiElement styleNameAttrValueForTag = AndroidFindStyleApplicationsProcessor.getStyleNameAttrValueForTag(candidateView);
            if (styleNameAttrValueForTag == null || !this.myParentStyleNameAttrValue.equals(styleNameAttrValueForTag)) {
                return false;
            }
        } else if (this.myParentStyleNameAttrValue != null) {
            return false;
        }
        return true;
    }

    public void setSearchOnlyInCurrentModule(boolean searchOnlyInCurrentModule) {
        this.mySearchOnlyInCurrentModule = searchOnlyInCurrentModule;
    }

    public void setFileToScan(VirtualFile fileToScan) {
        this.myFileToScan = fileToScan;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "getModule"));
        }
        return module;
    }

    @NotNull
    public String getStyleName() {
        String string = this.myStyleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsProcessor", "getStyleName"));
        }
        return string;
    }

    public void configureScope(MyScope scope, @Nullable VirtualFile context) {
        if (scope == MyScope.MODULE) {
            this.setSearchOnlyInCurrentModule(true);
        } else if (scope == MyScope.FILE) {
            this.setSearchOnlyInCurrentModule(true);
            this.setFileToScan(context);
        }
    }

    static enum MyScope {
        PROJECT,
        MODULE,
        FILE;

    }
}

