/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.maven;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.service.notification.hyperlink.CustomNotificationListener;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.intellij.facet.FacetType;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompilerConfiguration;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidExternalApklibDependenciesManager;
import org.jetbrains.android.maven.AndroidMavenProviderImpl;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.maven.MavenArtifactResolvedInfo;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.jps.android.model.impl.AndroidImportableProperty;
import org.jetbrains.jps.util.JpsPathUtil;

public abstract class AndroidFacetImporterBase
extends FacetImporter<AndroidFacet, AndroidFacetConfiguration, AndroidFacetType> {
    private static final String DEX_CORE_LIBRARY_PROPERTY = "dexCoreLibrary";
    public static volatile String ANDROID_SDK_PATH_TEST = null;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.maven.AndroidFacetImporterBase");
    private static final Key<Boolean> MODULE_IMPORTED = Key.create((String)"ANDROID_NEWLY_CREATED_KEY");
    @NonNls
    private static final String DEFAULT_NATIVE_ARCHITECTURE = "armeabi";
    private static final Key<Boolean> DELETE_OBSOLETE_MODULE_TASK_KEY = Key.create((String)"DELETE_OBSOLETE_MODULE_TASK");
    private static final Key<Set<MavenId>> RESOLVED_APKLIB_ARTIFACTS_KEY = Key.create((String)"RESOLVED_APKLIB_ARTIFACTS");
    private static final Key<Map<MavenId, String>> IMPORTED_AAR_ARTIFACTS = Key.create((String)"IMPORTED_AAR_ARTIFACTS");

    public AndroidFacetImporterBase(@NotNull String groupId, @NotNull String pluginId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/android/maven/AndroidFacetImporterBase", "<init>"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "org/jetbrains/android/maven/AndroidFacetImporterBase", "<init>"));
        }
        super(groupId, pluginId, FacetType.findInstance(AndroidFacetType.class));
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return ArrayUtil.find((Object[])AndroidFacetImporterBase.getSupportedPackagingTypes(), (Object)mavenProject.getPackaging()) >= 0 && super.isApplicable(mavenProject);
    }

    public void getSupportedPackagings(Collection<String> result) {
        result.addAll(Arrays.asList(AndroidFacetImporterBase.getSupportedPackagingTypes()));
    }

    @NotNull
    private static String[] getSupportedPackagingTypes() {
        String[] stringArray = new String[]{"apk", "apklib", "aar"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/maven/AndroidFacetImporterBase", "getSupportedPackagingTypes"));
        }
        return stringArray;
    }

    public void getSupportedDependencyTypes(Collection<String> result, SupportedRequestType type) {
        result.add("apksources");
        result.add("apklib");
        result.add("aar");
    }

    protected void setupFacet(AndroidFacet facet, MavenProject mavenProject) {
        String mavenProjectDirPath = FileUtil.toSystemIndependentName((String)mavenProject.getDirectory());
        ((AndroidFacetConfiguration)facet.getConfiguration()).init(facet.getModule(), mavenProjectDirPath);
        AndroidMavenProviderImpl.setPathsToDefault(mavenProject, facet.getModule(), (AndroidFacetConfiguration)facet.getConfiguration());
        boolean hasApkSources = AndroidMavenProviderImpl.hasApkSourcesDependency(mavenProject);
        AndroidMavenProviderImpl.configureAaptCompilation(mavenProject, facet.getModule(), (AndroidFacetConfiguration)facet.getConfiguration(), hasApkSources);
        String packaging = mavenProject.getPackaging();
        if ("apklib".equals(packaging) || "aar".equals(packaging)) {
            facet.setLibraryProject(true);
        }
        ((AndroidFacetConfiguration)facet.getConfiguration()).setIncludeAssetsFromLibraries(true);
        if (hasApkSources) {
            AndroidUtils.reportImportErrorToEventLog("'apksources' dependency is deprecated and can be poorly supported by IDE. It is strongly recommended to use 'apklib' dependency instead.", facet.getModule().getName(), facet.getModule().getProject());
        }
        if (Boolean.parseBoolean(this.findConfigValue(mavenProject, DEX_CORE_LIBRARY_PROPERTY))) {
            AndroidDexCompilerConfiguration.getInstance((Project)facet.getModule().getProject()).CORE_LIBRARY = true;
        }
    }

    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, AndroidFacet facet, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        this.configurePaths(facet, mavenProject);
        facet.getProperties().ENABLE_MANIFEST_MERGING = Boolean.parseBoolean(this.findConfigValue(mavenProject, "mergeManifests"));
        facet.getProperties().COMPILE_CUSTOM_GENERATED_SOURCES = false;
        this.configureAndroidPlatform(facet, mavenProject, modelsProvider);
        Project project = module.getProject();
        AndroidFacetImporterBase.importExternalAndroidLibDependencies(project, rootModel, modelsProvider, mavenTree, mavenProject, mavenProjectToModuleName, postTasks);
        if (AndroidFacetImporterBase.hasAndroidLibDependencies(mavenProject) && MavenProjectsManager.getInstance((Project)project).getImportingSettings().isUseMavenOutput()) {
            rootModel.useModuleOutput(mavenProject.getBuildDirectory() + "/idea-classes", mavenProject.getBuildDirectory() + "/idea-test-classes");
        }
        project.putUserData(DELETE_OBSOLETE_MODULE_TASK_KEY, (Object)Boolean.TRUE);
        postTasks.add(new MyDeleteObsoleteApklibModulesTask(project));
        AndroidFacetConfiguration defaultConfig = new AndroidFacetConfiguration();
        AndroidMavenProviderImpl.setPathsToDefault(mavenProject, module, defaultConfig);
        if (!defaultConfig.getState().GEN_FOLDER_RELATIVE_PATH_APT.equals(facet.getProperties().GEN_FOLDER_RELATIVE_PATH_APT)) {
            String rPath = mavenProject.getGeneratedSourcesDirectory(false) + "/r";
            rootModel.unregisterAll(rPath, false, true);
            rootModel.addExcludedFolder(rPath);
        }
        if (!defaultConfig.getState().GEN_FOLDER_RELATIVE_PATH_AIDL.equals(facet.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL)) {
            String aidlPath = mavenProject.getGeneratedSourcesDirectory(false) + "/aidl";
            rootModel.unregisterAll(aidlPath, false, true);
            rootModel.addExcludedFolder(aidlPath);
        }
        if (facet.getProperties().LIBRARY_PROJECT) {
            AndroidFacetImporterBase.removeAttachedJarDependency(modelsProvider, mavenTree, mavenProject);
        }
    }

    private static void removeAttachedJarDependency(IdeModifiableModelsProvider modelsProvider, MavenProjectsTree mavenTree, MavenProject mavenProject) {
        for (MavenArtifact depArtifact : mavenProject.getDependencies()) {
            Library.ModifiableModel attachedJarsLibModel;
            String attachedJarsLibName;
            Library attachedJarsLib;
            MavenProject depProject = mavenTree.findProject(depArtifact);
            if (depProject == null || (attachedJarsLib = modelsProvider.getLibraryByName(attachedJarsLibName = MavenModuleImporter.getAttachedJarsLibName((MavenArtifact)depArtifact))) == null || (attachedJarsLibModel = modelsProvider.getModifiableLibraryModel(attachedJarsLib)) == null) continue;
            String targetJarPath = depProject.getBuildDirectory() + "/" + depProject.getFinalName() + ".jar";
            for (String url : attachedJarsLibModel.getUrls(OrderRootType.CLASSES)) {
                if (!FileUtil.pathsEqual((String)targetJarPath, (String)JpsPathUtil.urlToPath((String)url))) continue;
                attachedJarsLibModel.removeRoot(url, OrderRootType.CLASSES);
            }
        }
    }

    private void importNativeDependencies(@NotNull AndroidFacet facet, @NotNull MavenProject mavenProject, @NotNull String moduleDirPath) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importNativeDependencies"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importNativeDependencies"));
        }
        if (moduleDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDirPath", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importNativeDependencies"));
        }
        ArrayList<AndroidNativeLibData> additionalNativeLibs = new ArrayList<AndroidNativeLibData>();
        String localRepository = MavenProjectsManager.getInstance((Project)facet.getModule().getProject()).getLocalRepository().getPath();
        String defaultArchitecture = this.getPathFromConfig(facet.getModule(), mavenProject, moduleDirPath, "nativeLibrariesDependenciesHardwareArchitectureDefault", false, true);
        if (defaultArchitecture == null) {
            defaultArchitecture = DEFAULT_NATIVE_ARCHITECTURE;
        }
        String forcedArchitecture = this.getPathFromConfig(facet.getModule(), mavenProject, moduleDirPath, "nativeLibrariesDependenciesHardwareArchitectureOverride", false, true);
        for (MavenArtifact depArtifact : mavenProject.getDependencies()) {
            String classifier;
            if (!"so".equals(depArtifact.getType())) continue;
            String architecture = forcedArchitecture != null ? forcedArchitecture : ((classifier = depArtifact.getClassifier()) != null ? classifier : defaultArchitecture);
            String path = FileUtil.toSystemIndependentName((String)(localRepository + '/' + depArtifact.getRelativePath()));
            String artifactId = depArtifact.getArtifactId();
            String targetFileName = artifactId.startsWith("lib") ? artifactId + ".so" : "lib" + artifactId + ".so";
            additionalNativeLibs.add(new AndroidNativeLibData(architecture, path, targetFileName));
        }
        ((AndroidFacetConfiguration)facet.getConfiguration()).setAdditionalNativeLibraries(additionalNativeLibs);
    }

    private static boolean hasAndroidLibDependencies(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/android/maven/AndroidFacetImporterBase", "hasAndroidLibDependencies"));
        }
        for (MavenArtifact depArtifact : mavenProject.getDependencies()) {
            String type = depArtifact.getType();
            if (!"apklib".equals(type) && !"aar".equals(type)) continue;
            return true;
        }
        return false;
    }

    private static void importExternalAndroidLibDependencies(Project project, MavenRootModelAdapter rootModelAdapter, IdeModifiableModelsProvider modelsProvider, MavenProjectsTree mavenTree, MavenProject mavenProject, Map<MavenProject, String> mavenProject2ModuleName, List<MavenProjectsProcessorTask> tasks) {
        ModifiableRootModel rootModel = rootModelAdapter.getRootModel();
        AndroidFacetImporterBase.removeUselessDependencies(rootModel, modelsProvider, mavenProject);
        for (MavenArtifact depArtifact : mavenProject.getDependencies()) {
            if (mavenTree.findProject(depArtifact) != null) continue;
            String type = depArtifact.getType();
            if ("apklib".equals(type)) {
                DependencyScope scope;
                AndroidExternalApklibDependenciesManager.MavenDependencyInfo depInfo = AndroidExternalApklibDependenciesManager.MavenDependencyInfo.create(depArtifact);
                String apklibModuleName = AndroidFacetImporterBase.doImportExternalApklibDependency(project, modelsProvider, mavenTree, mavenProject, mavenProject2ModuleName, tasks, depInfo);
                if (ArrayUtil.find((Object[])rootModel.getDependencyModuleNames(), (Object)apklibModuleName) >= 0 || (scope = AndroidFacetImporterBase.getApklibModuleDependencyScope(depArtifact)) == null) continue;
                AndroidFacetImporterBase.addModuleDependency(modelsProvider, rootModel, apklibModuleName, scope);
                continue;
            }
            if (!"aar".equals(type) || !"compile".equals(depArtifact.getScope())) continue;
            AndroidFacetImporterBase.importExternalAarDependency(depArtifact, mavenProject, mavenTree, rootModelAdapter, modelsProvider, project, tasks);
        }
    }

    @Nullable
    private static String findExtractedAarDirectory(@NotNull List<MavenProject> allProjects, @NotNull String dirName) {
        if (allProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allProjects", "org/jetbrains/android/maven/AndroidFacetImporterBase", "findExtractedAarDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "org/jetbrains/android/maven/AndroidFacetImporterBase", "findExtractedAarDirectory"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (MavenProject project : allProjects) {
            VirtualFile file = lfs.refreshAndFindFileByPath(AndroidMavenUtil.getGenExternalApklibDirInProject(project) + "/" + dirName);
            if (file == null) continue;
            return file.getPath();
        }
        return null;
    }

    private static void importExternalAarDependency(@NotNull MavenArtifact artifact, @NotNull MavenProject mavenProject, @NotNull MavenProjectsTree mavenTree, @NotNull MavenRootModelAdapter rootModelAdapter, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, @NotNull List<MavenProjectsProcessorTask> postTasks) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        if (mavenTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenTree", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        if (rootModelAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModelAdapter", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        if (postTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postTasks", "org/jetbrains/android/maven/AndroidFacetImporterBase", "importExternalAarDependency"));
        }
        Library aarLibrary = rootModelAdapter.findLibrary(artifact);
        if (aarLibrary == null) {
            return;
        }
        MavenId mavenId = artifact.getMavenId();
        Map importedAarArtifacts = (Map)project.getUserData(IMPORTED_AAR_ARTIFACTS);
        if (importedAarArtifacts == null) {
            importedAarArtifacts = new HashMap();
            project.putUserData(IMPORTED_AAR_ARTIFACTS, (Object)importedAarArtifacts);
            postTasks.add(new MavenProjectsProcessorTask(){

                public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    project.putUserData(IMPORTED_AAR_ARTIFACTS, null);
                }
            });
        }
        List allProjects = mavenTree.getProjects();
        String aarDirPath = (String)importedAarArtifacts.get(mavenId);
        if (aarDirPath == null) {
            String aarDirName = AndroidMavenUtil.getMavenIdStringForFileName(mavenId);
            aarDirPath = AndroidFacetImporterBase.findExtractedAarDirectory(allProjects, aarDirName);
            if (aarDirPath == null) {
                String genDirPath = AndroidMavenUtil.computePathForGenExternalApklibsDir(mavenId, mavenProject, allProjects);
                if (genDirPath == null) {
                    return;
                }
                aarDirPath = genDirPath + "/" + aarDirName;
            }
            importedAarArtifacts.put(mavenId, aarDirPath);
            AndroidFacetImporterBase.extractArtifact(artifact.getPath(), aarDirPath, project, mavenProject.getName());
        }
        Library.ModifiableModel aarLibModel = modelsProvider.getModifiableLibraryModel(aarLibrary);
        String classesJarPath = aarDirPath + "/" + "classes.jar";
        String classesJarUrl = VirtualFileManager.constructUrl((String)"jar", (String)classesJarPath) + "!/";
        String resDirUrl = VfsUtilCore.pathToUrl((String)(aarDirPath + "/" + "res"));
        HashSet urlsToAdd = new HashSet(Arrays.asList(classesJarUrl, resDirUrl));
        AndroidFacetImporterBase.collectJarsInAarLibsFolder(aarDirPath, (Set<String>)urlsToAdd);
        for (String url : aarLibModel.getUrls(OrderRootType.CLASSES)) {
            if (urlsToAdd.remove(url)) continue;
            aarLibModel.removeRoot(url, OrderRootType.CLASSES);
        }
        for (String url : urlsToAdd) {
            aarLibModel.addRoot(url, OrderRootType.CLASSES);
        }
    }

    private static void collectJarsInAarLibsFolder(@NotNull String aarDirPath, @NotNull Set<String> urlsToAdd) {
        if (aarDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aarDirPath", "org/jetbrains/android/maven/AndroidFacetImporterBase", "collectJarsInAarLibsFolder"));
        }
        if (urlsToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlsToAdd", "org/jetbrains/android/maven/AndroidFacetImporterBase", "collectJarsInAarLibsFolder"));
        }
        File libsFolder = new File(aarDirPath, "libs");
        if (!libsFolder.isDirectory()) {
            return;
        }
        File[] children = libsFolder.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)"jar")) continue;
                String url = VirtualFileManager.constructUrl((String)"jar", (String)FileUtil.toSystemIndependentName((String)child.getPath())) + "!/";
                urlsToAdd.add(url);
            }
        }
    }

    private static String doImportExternalApklibDependency(Project project, IdeModifiableModelsProvider modelsProvider, MavenProjectsTree mavenTree, MavenProject mavenProject, Map<MavenProject, String> mavenProject2ModuleName, List<MavenProjectsProcessorTask> tasks, AndroidExternalApklibDependenciesManager.MavenDependencyInfo depInfo) {
        String apklibModuleName;
        MavenId depArtifactMavenId = new MavenId(depInfo.getGroupId(), depInfo.getArtifactId(), depInfo.getVersion());
        ModifiableModuleModel moduleModel = modelsProvider.getModifiableModuleModel();
        Module apklibModule = moduleModel.findModuleByName(apklibModuleName = AndroidMavenUtil.getModuleNameForExtApklibArtifact(depArtifactMavenId));
        if ((apklibModule == null || apklibModule.getUserData(MODULE_IMPORTED) == null) && "compile".equals(depInfo.getScope()) && (apklibModule = AndroidFacetImporterBase.importExternalApklibArtifact(project, apklibModule, modelsProvider, mavenProject, mavenTree, depArtifactMavenId, depInfo.getPath(), moduleModel, mavenProject2ModuleName)) != null) {
            apklibModule.putUserData(MODULE_IMPORTED, (Object)Boolean.TRUE);
            final Module finalGenModule = apklibModule;
            tasks.add(new MavenProjectsProcessorTask(){

                public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    finalGenModule.putUserData(MODULE_IMPORTED, null);
                }
            });
            MavenArtifactResolvedInfo resolvedDepArtifact = AndroidExternalApklibDependenciesManager.getInstance(project).getResolvedInfoForArtifact(depArtifactMavenId);
            if (resolvedDepArtifact != null) {
                for (AndroidExternalApklibDependenciesManager.MavenDependencyInfo depDepInfo : resolvedDepArtifact.getDependencies()) {
                    MavenId depDepMavenId = new MavenId(depDepInfo.getGroupId(), depDepInfo.getArtifactId(), depDepInfo.getVersion());
                    if (!"apklib".equals(depDepInfo.getType()) || mavenTree.findProject(depDepMavenId) != null) continue;
                    AndroidFacetImporterBase.doImportExternalApklibDependency(project, modelsProvider, mavenTree, mavenProject, mavenProject2ModuleName, tasks, depDepInfo);
                }
            } else {
                AndroidUtils.reportImportErrorToEventLog("Cannot find resolved info for artifact " + depArtifactMavenId.getKey(), apklibModuleName, project);
            }
        }
        return apklibModuleName;
    }

    @Nullable
    private static DependencyScope getApklibModuleDependencyScope(@NotNull MavenArtifact apklibArtifact) {
        if (apklibArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apklibArtifact", "org/jetbrains/android/maven/AndroidFacetImporterBase", "getApklibModuleDependencyScope"));
        }
        String scope = apklibArtifact.getScope();
        if ("compile".equals(scope)) {
            return DependencyScope.COMPILE;
        }
        if ("provided".equals(scope)) {
            return DependencyScope.PROVIDED;
        }
        if ("test".equals(scope)) {
            return DependencyScope.TEST;
        }
        return null;
    }

    private static void removeUselessDependencies(ModifiableRootModel modifiableRootModel, IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject) {
        for (OrderEntry entry : modifiableRootModel.getOrderEntries()) {
            LibraryOrderEntry libOrderEntry;
            if (entry instanceof ModuleOrderEntry) {
                Module depModule = ((ModuleOrderEntry)entry).getModule();
                if (depModule == null || !AndroidMavenUtil.isExtApklibModule(depModule)) continue;
                modifiableRootModel.removeOrderEntry(entry);
                continue;
            }
            if (!(entry instanceof LibraryOrderEntry) || !AndroidFacetImporterBase.containsDependencyOnApklibFile(libOrderEntry = (LibraryOrderEntry)entry, modelsProvider) && !AndroidFacetImporterBase.pointsIntoUnpackedLibsDir(libOrderEntry, modelsProvider, mavenProject)) continue;
            modifiableRootModel.removeOrderEntry(entry);
        }
    }

    private static boolean pointsIntoUnpackedLibsDir(@NotNull LibraryOrderEntry entry, @NotNull IdeModifiableModelsProvider provider, @NotNull MavenProject mavenProject) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/android/maven/AndroidFacetImporterBase", "pointsIntoUnpackedLibsDir"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/maven/AndroidFacetImporterBase", "pointsIntoUnpackedLibsDir"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/android/maven/AndroidFacetImporterBase", "pointsIntoUnpackedLibsDir"));
        }
        Library library = entry.getLibrary();
        if (library == null) {
            return false;
        }
        Library.ModifiableModel libraryModel = provider.getModifiableLibraryModel(library);
        String[] urls = libraryModel.getUrls(OrderRootType.CLASSES);
        String unpackedLibsDir = FileUtil.toCanonicalPath((String)mavenProject.getBuildDirectory()) + "/unpacked-libs";
        for (String url : urls) {
            if (!VfsUtilCore.urlToPath((String)url).startsWith(unpackedLibsDir)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDependencyOnApklibFile(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String[] urls;
        if (libraryOrderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryOrderEntry", "org/jetbrains/android/maven/AndroidFacetImporterBase", "containsDependencyOnApklibFile"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/android/maven/AndroidFacetImporterBase", "containsDependencyOnApklibFile"));
        }
        Library library = libraryOrderEntry.getLibrary();
        if (library == null) {
            return false;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (String url : urls = libraryModel.getUrls(OrderRootType.CLASSES)) {
            String fileName = PathUtil.getFileName((String)PathUtil.toPresentableUrl((String)url));
            if (!FileUtilRt.extensionEquals((String)fileName, (String)"apklib")) continue;
            return true;
        }
        return false;
    }

    private static void addModuleDependency(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModifiableRootModel rootModel, @NotNull String moduleName, @NotNull DependencyScope compile) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addModuleDependency"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addModuleDependency"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addModuleDependency"));
        }
        if (compile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compile", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addModuleDependency"));
        }
        if (AndroidFacetImporterBase.findModuleDependency(rootModel, moduleName) != null) {
            return;
        }
        Module module = modelsProvider.getModifiableModuleModel().findModuleByName(moduleName);
        ModuleOrderEntry entry = module != null ? rootModel.addModuleOrderEntry(module) : rootModel.addInvalidModuleEntry(moduleName);
        entry.setScope(compile);
    }

    private static ModuleOrderEntry findModuleDependency(ModifiableRootModel rootModel, final String moduleName) {
        final Ref result = Ref.create(null);
        rootModel.orderEntries().forEach((Processor)new Processor<OrderEntry>(){

            public boolean process(OrderEntry entry) {
                ModuleOrderEntry moduleEntry;
                String name;
                if (entry instanceof ModuleOrderEntry && moduleName.equals(name = (moduleEntry = (ModuleOrderEntry)entry).getModuleName())) {
                    result.set((Object)moduleEntry);
                }
                return true;
            }
        });
        return (ModuleOrderEntry)result.get();
    }

    @Nullable
    private static Module importExternalApklibArtifact(Project project, Module apklibModule, IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, MavenProjectsTree mavenTree, MavenId artifactMavenId, String artifactFilePath, ModifiableModuleModel moduleModel, Map<MavenProject, String> mavenProject2ModuleName) {
        String genModuleName = AndroidMavenUtil.getModuleNameForExtApklibArtifact(artifactMavenId);
        String genExternalApklibsDirPath = null;
        String targetDirPath = null;
        if (apklibModule == null) {
            genExternalApklibsDirPath = AndroidMavenUtil.computePathForGenExternalApklibsDir(artifactMavenId, mavenProject, mavenTree.getProjects());
            targetDirPath = genExternalApklibsDirPath != null ? genExternalApklibsDirPath + '/' + AndroidMavenUtil.getMavenIdStringForFileName(artifactMavenId) : null;
        } else {
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)apklibModule).getContentRoots();
            if (contentRoots.length == 1) {
                targetDirPath = contentRoots[0].getPath();
            } else {
                String moduleDir = new File(apklibModule.getModuleFilePath()).getParent();
                if (moduleDir != null) {
                    targetDirPath = moduleDir + '/' + AndroidMavenUtil.getMavenIdStringForFileName(artifactMavenId);
                }
            }
        }
        if (targetDirPath == null) {
            return null;
        }
        if (!AndroidFacetImporterBase.extractArtifact(artifactFilePath, targetDirPath, project, genModuleName)) {
            return null;
        }
        AndroidExternalApklibDependenciesManager adm = AndroidExternalApklibDependenciesManager.getInstance(project);
        adm.setArtifactFilePath(artifactMavenId, FileUtil.toSystemIndependentName((String)artifactFilePath));
        VirtualFile vApklibDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(targetDirPath);
        if (vApklibDir == null) {
            LOG.error("Cannot find file " + targetDirPath + " in VFS");
            return null;
        }
        if (apklibModule == null) {
            String genModuleFilePath = genExternalApklibsDirPath + '/' + genModuleName + ".iml";
            apklibModule = moduleModel.newModule(genModuleFilePath, StdModuleTypes.JAVA.getId());
        }
        ModifiableRootModel apklibModuleModel = modelsProvider.getModifiableRootModel(apklibModule);
        ContentEntry contentEntry = apklibModuleModel.addContentEntry(vApklibDir);
        VirtualFile sourceRoot = vApklibDir.findChild("src");
        if (sourceRoot != null) {
            contentEntry.addSourceFolder(sourceRoot, false);
        }
        AndroidFacet facet = AndroidUtils.addAndroidFacet(apklibModuleModel.getModule(), vApklibDir, true);
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        String s = AndroidRootUtil.getPathRelativeToModuleDir(apklibModule, vApklibDir.getPath());
        if (s != null) {
            s = s.length() > 0 ? '/' + s + '/' : "/";
            configuration.getState().RES_FOLDER_RELATIVE_PATH = s + "res";
            configuration.getState().LIBS_FOLDER_RELATIVE_PATH = s + "libs";
            configuration.getState().MANIFEST_FILE_RELATIVE_PATH = s + "AndroidManifest.xml";
        }
        AndroidFacetImporterBase.importSdkAndDependenciesForApklibArtifact(project, apklibModuleModel, modelsProvider, mavenTree, artifactMavenId, mavenProject2ModuleName);
        return apklibModule;
    }

    private static boolean extractArtifact(String zipFilePath, String targetDirPath, Project project, String moduleName) {
        File targetDir = new File(targetDirPath);
        if (targetDir.exists() && !FileUtil.delete((File)targetDir)) {
            AndroidUtils.reportImportErrorToEventLog("Cannot delete old " + targetDirPath, moduleName, project);
            return false;
        }
        if (!targetDir.mkdirs()) {
            AndroidUtils.reportImportErrorToEventLog("Cannot create directory " + targetDirPath, moduleName, project);
            return false;
        }
        File artifactFile = new File(zipFilePath);
        if (artifactFile.exists()) {
            try {
                ZipUtil.extract((File)artifactFile, (File)targetDir, null);
            }
            catch (IOException e) {
                AndroidFacetImporterBase.reportIoErrorToEventLog(e, moduleName, project);
                return false;
            }
        } else {
            AndroidUtils.reportImportErrorToEventLog("Cannot find file " + artifactFile.getPath(), moduleName, project);
        }
        return true;
    }

    private static void reportIoErrorToEventLog(IOException e, String moduleName, Project project) {
        String message = e.getMessage();
        if (message == null) {
            LOG.error((Throwable)e);
        } else {
            AndroidUtils.reportImportErrorToEventLog("I/O error: " + message, moduleName, project);
        }
    }

    private static void importSdkAndDependenciesForApklibArtifact(Project project, ModifiableRootModel apklibModuleModel, IdeModifiableModelsProvider modelsProvider, MavenProjectsTree mavenTree, MavenId artifactMavenId, Map<MavenProject, String> mavenProject2ModuleName) {
        String apklibModuleName = apklibModuleModel.getModule().getName();
        AndroidExternalApklibDependenciesManager adm = AndroidExternalApklibDependenciesManager.getInstance(project);
        MavenArtifactResolvedInfo resolvedInfo = adm.getResolvedInfoForArtifact(artifactMavenId);
        for (OrderEntry entry : apklibModuleModel.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry) && !(entry instanceof LibraryOrderEntry)) continue;
            apklibModuleModel.removeOrderEntry(entry);
        }
        if (resolvedInfo != null) {
            String apiLevel = resolvedInfo.getApiLevel();
            Sdk sdk = AndroidFacetImporterBase.findOrCreateAndroidPlatform(apiLevel, null);
            if (sdk != null) {
                apklibModuleModel.setSdk(sdk);
            } else {
                AndroidFacetImporterBase.reportCannotFindAndroidPlatformError(apklibModuleName, apiLevel, project);
            }
            for (AndroidExternalApklibDependenciesManager.MavenDependencyInfo depArtifactInfo : resolvedInfo.getDependencies()) {
                MavenId depMavenId = new MavenId(depArtifactInfo.getGroupId(), depArtifactInfo.getArtifactId(), depArtifactInfo.getVersion());
                String type = depArtifactInfo.getType();
                String scope = depArtifactInfo.getScope();
                String path = depArtifactInfo.getPath();
                String libName = depArtifactInfo.getLibName();
                if ("apklib".equals(type) && "compile".equals(scope)) {
                    MavenProject depProject = mavenTree.findProject(depMavenId);
                    if (depProject != null) {
                        String depModuleName = mavenProject2ModuleName.get(depProject);
                        if (depModuleName == null) continue;
                        AndroidFacetImporterBase.addModuleDependency(modelsProvider, apklibModuleModel, depModuleName, DependencyScope.COMPILE);
                        continue;
                    }
                    String depApklibGenModuleName = AndroidMavenUtil.getModuleNameForExtApklibArtifact(depMavenId);
                    AndroidFacetImporterBase.addModuleDependency(modelsProvider, apklibModuleModel, depApklibGenModuleName, DependencyScope.COMPILE);
                    continue;
                }
                DependencyScope depScope = MavenModuleImporter.selectScope((String)scope);
                if (scope != null) {
                    AndroidFacetImporterBase.addLibraryDependency(libName, depScope, modelsProvider, apklibModuleModel, path);
                    continue;
                }
                LOG.info("Unknown Maven scope " + depScope);
            }
        } else {
            AndroidUtils.reportImportErrorToEventLog("Cannot find sdk info for artifact " + artifactMavenId.getKey(), apklibModuleName, project);
        }
    }

    private static void addLibraryDependency(@NotNull String libraryName, @NotNull DependencyScope scope, @NotNull IdeModifiableModelsProvider provider, @NotNull ModifiableRootModel model, @NotNull String path) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addLibraryDependency"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addLibraryDependency"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addLibraryDependency"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/android/maven/AndroidFacetImporterBase", "addLibraryDependency"));
        }
        Library library = provider.getLibraryByName(libraryName);
        if (library == null) {
            library = provider.createLibrary(libraryName);
        }
        Library.ModifiableModel libraryModel = provider.getModifiableLibraryModel(library);
        AndroidFacetImporterBase.updateUrl(libraryModel, path);
        LibraryOrderEntry entry = model.addLibraryEntry(library);
        entry.setScope(scope);
    }

    private static void updateUrl(@NotNull Library.ModifiableModel library, @NotNull String path) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/android/maven/AndroidFacetImporterBase", "updateUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/android/maven/AndroidFacetImporterBase", "updateUrl"));
        }
        OrderRootType type = OrderRootType.CLASSES;
        String newUrl = VirtualFileManager.constructUrl((String)"jar", (String)path) + "!/";
        boolean urlExists = false;
        for (String url : library.getUrls(type)) {
            if (newUrl.equals(url)) {
                urlExists = true;
                continue;
            }
            library.removeRoot(url, type);
        }
        if (!urlExists) {
            library.addRoot(newUrl, type);
        }
    }

    private static void reportCannotFindAndroidPlatformError(String moduleName, @Nullable String apiLevel, Project project) {
        OpenAndroidSdkManagerHyperlink hyperlink = new OpenAndroidSdkManagerHyperlink();
        AndroidUtils.reportImportErrorToEventLog("Cannot find appropriate Android platform" + (apiLevel != null ? " for API level " + apiLevel : "") + ". " + hyperlink.toHtml(), moduleName, project, (NotificationListener)new CustomNotificationListener(project, hyperlink));
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        AndroidExternalApklibDependenciesManager adm = AndroidExternalApklibDependenciesManager.getInstance(project);
        for (MavenArtifact depArtifact : mavenProject.getDependencies()) {
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
            if (!"apklib".equals(depArtifact.getType()) || mavenProjectsManager.findProject(depArtifact) != null || !"compile".equals(depArtifact.getScope())) continue;
            Set resolvedArtifacts = (Set)context.getUserData(RESOLVED_APKLIB_ARTIFACTS_KEY);
            if (resolvedArtifacts == null) {
                resolvedArtifacts = new HashSet();
                context.putUserData(RESOLVED_APKLIB_ARTIFACTS_KEY, (Object)resolvedArtifacts);
            }
            if (!resolvedArtifacts.add(depArtifact.getMavenId())) continue;
            this.doResolveApklibArtifact(project, depArtifact, embedder, mavenProjectsManager, mavenProject.getName(), adm, context);
        }
    }

    @Nullable
    private static File buildFakeArtifactPomFile(@NotNull MavenArtifact artifact, @Nullable String moduleName, @NotNull Project project) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/maven/AndroidFacetImporterBase", "buildFakeArtifactPomFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/maven/AndroidFacetImporterBase", "buildFakeArtifactPomFile"));
        }
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile((String)"intellij_fake_artifat_pom", (String)"tmp");
            FileUtil.writeToFile((File)tmpFile, (String)("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>intellij-fake-artifact-group</groupId>\n  <artifactId>intellij-fake-artifact</artifactId>\n  <version>1.0-SNAPSHOT</version>\n  <packaging>jar</packaging>\n  <name>Fake</name>  <dependencies>    <dependency>      <groupId>" + artifact.getGroupId() + "</groupId>      <artifactId>" + artifact.getArtifactId() + "</artifactId>      <version>" + artifact.getVersion() + "</version>    </dependency>  </dependencies></project>"));
            return tmpFile;
        }
        catch (IOException e) {
            AndroidFacetImporterBase.reportIoErrorToEventLog(e, moduleName, project);
            if (tmpFile != null) {
                FileUtil.delete((File)tmpFile);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolveApklibArtifact(Project project, MavenArtifact artifact, MavenEmbedderWrapper embedder, MavenProjectsManager mavenProjectsManager, String moduleName, AndroidExternalApklibDependenciesManager adm, ResolveContext context) throws MavenProcessCanceledException {
        File fakePomFile;
        File depArtifacetFile = new File(FileUtil.getNameWithoutExtension((String)artifact.getPath()) + ".pom");
        if (!depArtifacetFile.exists()) {
            AndroidUtils.reportImportErrorToEventLog("Cannot find file " + depArtifacetFile.getPath(), moduleName, project);
            return;
        }
        VirtualFile vDepArtifactFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(depArtifacetFile);
        if (vDepArtifactFile == null) {
            AndroidUtils.reportImportErrorToEventLog("Cannot find file " + depArtifacetFile.getPath() + " in VFS", moduleName, project);
            return;
        }
        MavenProject projectForExternalApklib = new MavenProject(vDepArtifactFile);
        MavenGeneralSettings generalSettings = mavenProjectsManager.getGeneralSettings();
        MavenProjectReader mavenProjectReader = new MavenProjectReader(project);
        MavenProjectReaderProjectLocator locator = new MavenProjectReaderProjectLocator(){

            @Nullable
            public VirtualFile findProjectFile(MavenId coordinates) {
                return null;
            }
        };
        MavenArtifactResolvedInfo info = new MavenArtifactResolvedInfo();
        MavenId mavenId = artifact.getMavenId();
        adm.setResolvedInfoForArtifact(mavenId, info);
        projectForExternalApklib.read(generalSettings, mavenProjectsManager.getExplicitProfiles(), mavenProjectReader, locator);
        projectForExternalApklib.resolve(project, generalSettings, embedder, mavenProjectReader, locator, context);
        String apiLevel = this.getPlatformFromConfig(projectForExternalApklib);
        ArrayList<AndroidExternalApklibDependenciesManager.MavenDependencyInfo> dependencies = new ArrayList<AndroidExternalApklibDependenciesManager.MavenDependencyInfo>();
        List deps = projectForExternalApklib.getDependencies();
        if (deps.isEmpty() && (fakePomFile = AndroidFacetImporterBase.buildFakeArtifactPomFile(artifact, moduleName, project)) != null) {
            try {
                VirtualFile vFakePomFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(fakePomFile);
                if (vFakePomFile != null) {
                    MavenProject fakeProject = new MavenProject(vFakePomFile);
                    fakeProject.read(generalSettings, mavenProjectsManager.getExplicitProfiles(), mavenProjectReader, locator);
                    fakeProject.resolve(project, generalSettings, embedder, mavenProjectReader, locator, context);
                    deps = fakeProject.getDependencies();
                    Iterator it = deps.iterator();
                    while (it.hasNext()) {
                        MavenArtifact dep = (MavenArtifact)it.next();
                        if (!dep.getMavenId().equals((Object)mavenId)) continue;
                        it.remove();
                    }
                } else {
                    LOG.error("Cannot find file " + fakePomFile.getPath() + " in the VFS");
                }
            }
            finally {
                FileUtil.delete((File)fakePomFile);
            }
        }
        for (MavenArtifact depArtifact : deps) {
            dependencies.add(AndroidExternalApklibDependenciesManager.MavenDependencyInfo.create(depArtifact));
        }
        info.setApiLevel(apiLevel != null ? apiLevel : "");
        info.setDependencies(dependencies);
    }

    private void configureAndroidPlatform(AndroidFacet facet, MavenProject project, IdeModifiableModelsProvider modelsProvider) {
        ModifiableRootModel model = modelsProvider.getModifiableRootModel(facet.getModule());
        this.configureAndroidPlatform(project, model);
    }

    private void configureAndroidPlatform(MavenProject project, ModifiableRootModel model) {
        Sdk currentSdk = model.getSdk();
        if (currentSdk == null || !this.isAppropriateSdk(currentSdk, project)) {
            String predefinedSdkPath;
            String apiLevel = this.getPlatformFromConfig(project);
            Sdk platformLib = AndroidFacetImporterBase.findOrCreateAndroidPlatform(apiLevel, predefinedSdkPath = this.getSdkPathFromConfig(project));
            if (platformLib != null) {
                model.setSdk(platformLib);
            } else {
                AndroidFacetImporterBase.reportCannotFindAndroidPlatformError(model.getModule().getName(), apiLevel, model.getProject());
            }
        }
    }

    private boolean isAppropriateSdk(@NotNull Sdk sdk, MavenProject mavenProject) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/maven/AndroidFacetImporterBase", "isAppropriateSdk"));
        }
        if (!AndroidSdkUtils.isAndroidSdk(sdk)) {
            return false;
        }
        String platformId = this.getPlatformFromConfig(mavenProject);
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        if (androidPlatform == null) {
            return false;
        }
        IAndroidTarget target = androidPlatform.getTarget();
        return (platformId == null || AndroidSdkUtils.targetHasId(target, platformId)) && AndroidSdkUtils.checkSdkRoots(sdk, target, true);
    }

    @Nullable
    private static Sdk findOrCreateAndroidPlatform(String apiLevel, String predefinedSdkPath) {
        Sdk sdk;
        Sdk sdk2;
        if (predefinedSdkPath != null && (sdk2 = AndroidFacetImporterBase.doFindOrCreateAndroidPlatform(predefinedSdkPath, apiLevel)) != null) {
            return sdk2;
        }
        String sdkPath = ApplicationManager.getApplication().isUnitTestMode() ? ANDROID_SDK_PATH_TEST : System.getenv("ANDROID_HOME");
        LOG.info("android home: " + sdkPath);
        if (sdkPath != null && (sdk = AndroidFacetImporterBase.doFindOrCreateAndroidPlatform(sdkPath, apiLevel)) != null) {
            return sdk;
        }
        Collection<String> candidates = AndroidSdkUtils.getAndroidSdkPathsFromExistingPlatforms();
        LOG.info("suggested sdks: " + candidates);
        for (String candidate : candidates) {
            Sdk sdk3 = AndroidFacetImporterBase.doFindOrCreateAndroidPlatform(candidate, apiLevel);
            if (sdk3 == null) continue;
            return sdk3;
        }
        return null;
    }

    @Nullable
    private static Sdk doFindOrCreateAndroidPlatform(@Nullable String sdkPath, @Nullable String apiLevel) {
        AndroidSdkData sdkData;
        if (sdkPath != null && (sdkData = AndroidSdkData.getSdkData(sdkPath)) != null) {
            IAndroidTarget target;
            IAndroidTarget iAndroidTarget = target = apiLevel != null && apiLevel.length() > 0 ? sdkData.findTargetByApiLevel(apiLevel) : AndroidFacetImporterBase.findNewestPlatformTarget(sdkData);
            if (target != null) {
                Sdk library = AndroidSdkUtils.findAppropriateAndroidPlatform(target, sdkData, true);
                if (library == null) {
                    library = AndroidFacetImporterBase.createNewAndroidSdkForMaven(sdkPath, target);
                }
                return library;
            }
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findNewestPlatformTarget(AndroidSdkData data) {
        IAndroidTarget result = null;
        for (IAndroidTarget target : data.getTargets()) {
            if (!target.isPlatform() || result != null && result.getVersion().compareTo(target.getVersion()) >= 0) continue;
            result = target;
        }
        return result;
    }

    @Nullable
    private static Sdk createNewAndroidSdkForMaven(String sdkPath, IAndroidTarget target) {
        String sdkName = "Maven " + AndroidSdkUtils.chooseNameForNewLibrary(target);
        Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, sdkPath, sdkName, false);
        if (sdk == null) {
            return null;
        }
        SdkModificator modificator = sdk.getSdkModificator();
        for (OrderRoot root : AndroidSdkUtils.getLibraryRootsForTarget(target, sdkPath, false)) {
            modificator.addRoot(root.getFile(), root.getType());
        }
        AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
        if (data != null) {
            Sdk javaSdk = data.getJavaSdk();
            if (javaSdk != null) {
                for (VirtualFile file : javaSdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                    modificator.addRoot(file, OrderRootType.CLASSES);
                }
            } else {
                LOG.error("AndroidSdkUtils.createNewAndroidPlatform should return Android SDK with a valid JDK reference, or return null");
            }
        }
        modificator.commitChanges();
        return sdk;
    }

    @Nullable
    private String getPlatformFromConfig(MavenProject project) {
        Element platform;
        Element sdkRoot = this.getConfig(project, "sdk");
        if (sdkRoot != null && (platform = sdkRoot.getChild("platform")) != null) {
            return platform.getValue();
        }
        String platformFromProperty = project.getProperties().getProperty("android.sdk.platform");
        if (platformFromProperty != null) {
            return platformFromProperty;
        }
        return null;
    }

    @Nullable
    private String getSdkPathFromConfig(MavenProject project) {
        Element path;
        Element sdkRoot = this.getConfig(project, "sdk");
        if (sdkRoot != null && (path = sdkRoot.getChild("path")) != null) {
            return path.getValue();
        }
        String pathFromProperty = project.getProperties().getProperty("android.sdk.path");
        if (pathFromProperty != null) {
            return pathFromProperty;
        }
        return null;
    }

    private void configurePaths(AndroidFacet facet, MavenProject project) {
        String nativeLibsFolderRelPath;
        String assetsFolderRelPath;
        Module module = facet.getModule();
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        if (moduleDirPath == null) {
            return;
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        if (configuration.isImportedProperty(AndroidImportableProperty.RESOURCES_DIR_PATH)) {
            String resFolderForCompilerRelPath;
            String resFolderRelPath = this.getPathFromConfig(module, project, moduleDirPath, "resourceDirectory", true, true);
            if (resFolderRelPath != null && AndroidFacetImporterBase.isFullyResolved(resFolderRelPath)) {
                configuration.getState().RES_FOLDER_RELATIVE_PATH = '/' + resFolderRelPath;
            }
            if ((resFolderForCompilerRelPath = this.getPathFromConfig(module, project, moduleDirPath, "resourceDirectory", false, true)) != null && !resFolderForCompilerRelPath.equals(resFolderRelPath)) {
                configuration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER = true;
                configuration.getState().CUSTOM_APK_RESOURCE_FOLDER = '/' + resFolderForCompilerRelPath;
                configuration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK = true;
            }
        }
        configuration.getState().RES_OVERLAY_FOLDERS = Arrays.asList("/res-overlay");
        Element resourceOverlayDirectories = this.getConfig(project, "resourceOverlayDirectories");
        if (resourceOverlayDirectories != null) {
            ArrayList<String> dirs = new ArrayList<String>();
            for (Object child : resourceOverlayDirectories.getChildren()) {
                String relativePath;
                String dir = ((Element)child).getTextTrim();
                if (dir == null || dir.length() <= 0 || (relativePath = AndroidFacetImporterBase.getRelativePath(moduleDirPath, this.makePath(project, new String[]{dir}))) == null || relativePath.length() <= 0) continue;
                dirs.add('/' + relativePath);
            }
            if (dirs.size() > 0) {
                configuration.getState().RES_OVERLAY_FOLDERS = dirs;
            }
        } else {
            String resOverlayFolderRelPath = this.getPathFromConfig(module, project, moduleDirPath, "resourceOverlayDirectory", true, true);
            if (resOverlayFolderRelPath != null && AndroidFacetImporterBase.isFullyResolved(resOverlayFolderRelPath)) {
                configuration.getState().RES_OVERLAY_FOLDERS = Arrays.asList('/' + resOverlayFolderRelPath);
            }
        }
        if (configuration.isImportedProperty(AndroidImportableProperty.ASSETS_DIR_PATH) && (assetsFolderRelPath = this.getPathFromConfig(module, project, moduleDirPath, "assetsDirectory", false, true)) != null && AndroidFacetImporterBase.isFullyResolved(assetsFolderRelPath)) {
            configuration.getState().ASSETS_FOLDER_RELATIVE_PATH = '/' + assetsFolderRelPath;
        }
        if (configuration.isImportedProperty(AndroidImportableProperty.MANIFEST_FILE_PATH)) {
            String manifestFileForCompilerRelPath;
            String manifestFileRelPath = this.getPathFromConfig(module, project, moduleDirPath, "androidManifestFile", true, false);
            if (manifestFileRelPath != null && AndroidFacetImporterBase.isFullyResolved(manifestFileRelPath)) {
                configuration.getState().MANIFEST_FILE_RELATIVE_PATH = '/' + manifestFileRelPath;
            }
            if ((manifestFileForCompilerRelPath = this.getPathFromConfig(module, project, moduleDirPath, "androidManifestFile", false, false)) != null && !manifestFileForCompilerRelPath.equals(manifestFileRelPath) && AndroidFacetImporterBase.isFullyResolved(manifestFileForCompilerRelPath)) {
                configuration.getState().USE_CUSTOM_COMPILER_MANIFEST = true;
                configuration.getState().CUSTOM_COMPILER_MANIFEST = '/' + manifestFileForCompilerRelPath;
                configuration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK = true;
            }
        }
        if (MavenProjectsManager.getInstance((Project)module.getProject()).getImportingSettings().isUseMavenOutput()) {
            String buildDirectory = FileUtil.toSystemIndependentName((String)project.getBuildDirectory());
            String buildDirRelPath = FileUtil.getRelativePath((String)moduleDirPath, (String)buildDirectory, (char)'/');
            configuration.getState().APK_PATH = '/' + buildDirRelPath + '/' + AndroidCompileUtil.getApkName(module);
        } else {
            configuration.getState().APK_PATH = "";
        }
        if (configuration.isImportedProperty(AndroidImportableProperty.NATIVE_LIBS_DIR_PATH) && (nativeLibsFolderRelPath = this.getPathFromConfig(module, project, moduleDirPath, "nativeLibrariesDirectory", false, true)) != null && AndroidFacetImporterBase.isFullyResolved(nativeLibsFolderRelPath)) {
            configuration.getState().LIBS_FOLDER_RELATIVE_PATH = '/' + nativeLibsFolderRelPath;
        }
        this.importNativeDependencies(facet, project, moduleDirPath);
    }

    private static boolean isFullyResolved(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/maven/AndroidFacetImporterBase", "isFullyResolved"));
        }
        return !s.contains("${");
    }

    @Nullable
    private String getPathFromConfig(Module module, MavenProject project, String moduleDirPath, String configTagName, boolean inResourceDir, boolean directory) {
        String resourceDir = this.findConfigValue(project, configTagName);
        if (resourceDir != null) {
            String resFolderRelPath;
            String path = this.makePath(project, new String[]{resourceDir});
            if (inResourceDir) {
                MyResourceProcessor processor = new MyResourceProcessor(path, directory);
                AndroidMavenProviderImpl.processResources(module, project, processor);
                if (processor.myResult != null) {
                    path = processor.myResult.getPath();
                }
            }
            if ((resFolderRelPath = AndroidFacetImporterBase.getRelativePath(moduleDirPath, path)) != null) {
                return resFolderRelPath;
            }
        }
        return null;
    }

    @Nullable
    private static String getRelativePath(String basePath, String absPath) {
        absPath = FileUtil.toSystemIndependentName((String)absPath);
        return FileUtil.getRelativePath((String)basePath, (String)absPath, (char)'/');
    }

    public void collectExcludedFolders(MavenProject mavenProject, List<String> result) {
        result.add(mavenProject.getGeneratedSourcesDirectory(false) + "/combined-resources");
        result.add(mavenProject.getGeneratedSourcesDirectory(false) + "/combined-assets");
        result.add(mavenProject.getGeneratedSourcesDirectory(false) + "/extracted-dependencies");
    }

    private static class MyDeleteObsoleteApklibModulesTask
    implements MavenProjectsProcessorTask {
        private final Project myProject;

        public MyDeleteObsoleteApklibModulesTask(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/maven/AndroidFacetImporterBase$MyDeleteObsoleteApklibModulesTask", "<init>"));
            }
            this.myProject = project;
        }

        public void perform(final Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed() || project.getUserData(DELETE_OBSOLETE_MODULE_TASK_KEY) != Boolean.TRUE) {
                        return;
                    }
                    project.putUserData(DELETE_OBSOLETE_MODULE_TASK_KEY, null);
                    final ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                    HashSet referredModules = new HashSet();
                    for (Module module : moduleModel.getModules()) {
                        if (AndroidMavenUtil.isExtApklibModule(module)) continue;
                        MyDeleteObsoleteApklibModulesTask.collectDependenciesRecursively(module, (Set)referredModules);
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable((Set)referredModules){
                        final /* synthetic */ Set val$referredModules;
                        {
                            this.val$referredModules = set;
                        }

                        @Override
                        public void run() {
                            boolean modelChanged = false;
                            for (Module module : moduleModel.getModules()) {
                                if (!AndroidMavenUtil.isExtApklibModule(module) || this.val$referredModules.contains(module)) continue;
                                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                                if (contentRoots.length > 0) {
                                    VirtualFile contentRoot = contentRoots[0];
                                    try {
                                        contentRoot.delete((Object)myProject);
                                    }
                                    catch (IOException e) {
                                        LOG.error((Throwable)e);
                                    }
                                }
                                moduleModel.disposeModule(module);
                                modelChanged = true;
                            }
                            if (modelChanged) {
                                moduleModel.commit();
                            } else {
                                moduleModel.dispose();
                            }
                        }
                    });
                }
            });
        }

        private static void collectDependenciesRecursively(@NotNull Module root, @NotNull Set<Module> result) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/android/maven/AndroidFacetImporterBase$MyDeleteObsoleteApklibModulesTask", "collectDependenciesRecursively"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/maven/AndroidFacetImporterBase$MyDeleteObsoleteApklibModulesTask", "collectDependenciesRecursively"));
            }
            if (!result.add(root)) {
                return;
            }
            for (Module depModule : ModuleRootManager.getInstance((Module)root).getDependencies()) {
                MyDeleteObsoleteApklibModulesTask.collectDependenciesRecursively(depModule, result);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyDeleteObsoleteApklibModulesTask task = (MyDeleteObsoleteApklibModulesTask)o;
            return this.myProject.equals(task.myProject);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myProject.hashCode();
            return result;
        }
    }

    private static class MyResourceProcessor
    implements AndroidMavenProviderImpl.ResourceProcessor {
        private final String myResourceOutputPath;
        private final boolean myDirectory;
        private VirtualFile myResult;

        private MyResourceProcessor(String resourceOutputPath, boolean directory) {
            this.myResourceOutputPath = resourceOutputPath;
            this.myDirectory = directory;
        }

        @Override
        public boolean process(@NotNull VirtualFile resource, @NotNull String outputPath) {
            if (resource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "org/jetbrains/android/maven/AndroidFacetImporterBase$MyResourceProcessor", "process"));
            }
            if (outputPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/android/maven/AndroidFacetImporterBase$MyResourceProcessor", "process"));
            }
            if (!this.myDirectory && resource.isDirectory()) {
                return false;
            }
            if (outputPath.endsWith("/")) {
                outputPath = outputPath.substring(0, outputPath.length() - 1);
            }
            if (FileUtil.pathsEqual((String)outputPath, (String)this.myResourceOutputPath)) {
                this.myResult = resource;
                return true;
            }
            if (this.myDirectory) {
                String parentPath;
                if (outputPath.toLowerCase().startsWith(this.myResourceOutputPath.toLowerCase()) && FileUtil.pathsEqual((String)(parentPath = outputPath.substring(0, this.myResourceOutputPath.length())), (String)this.myResourceOutputPath)) {
                    if (resource.isDirectory()) {
                        VirtualFile parent = resource.getParent();
                        if (parent != null) {
                            this.myResult = parent;
                            return true;
                        }
                    } else {
                        VirtualFile gp;
                        VirtualFile parent = resource.getParent();
                        VirtualFile virtualFile = gp = parent != null ? parent.getParent() : null;
                        if (gp != null) {
                            this.myResult = gp;
                            return true;
                        }
                    }
                }
                return false;
            }
            return false;
        }
    }
}

