/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintUtil {
    @NonNls
    static final String ATTR_VALUE_VERTICAL = "vertical";
    @NonNls
    static final String ATTR_VALUE_WRAP_CONTENT = "wrap_content";
    @NonNls
    static final String ATTR_LAYOUT_HEIGHT = "layout_height";
    @NonNls
    static final String ATTR_LAYOUT_WIDTH = "layout_width";
    @NonNls
    static final String ATTR_ORIENTATION = "orientation";

    private AndroidLintUtil() {
    }

    @Nullable
    public static Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlighLevelAndInspection(@NotNull Project project, @NotNull Issue issue, @NotNull PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/AndroidLintUtil", "getHighlighLevelAndInspection"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "org/jetbrains/android/inspections/lint/AndroidLintUtil", "getHighlighLevelAndInspection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/AndroidLintUtil", "getHighlighLevelAndInspection"));
        }
        String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
        if (inspectionShortName == null) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionShortName);
        if (key == null) {
            return null;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key, context) && issue.isEnabledByDefault()) {
            return null;
        }
        AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
        if (inspection == null) {
            return null;
        }
        HighlightDisplayLevel errorLevel = profile.getErrorLevel(key, context);
        return Pair.create((Object)((Object)inspection), (Object)(errorLevel != null ? errorLevel : HighlightDisplayLevel.WARNING));
    }
}

