/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;

public class AddTargetVersionCheckQuickFix
implements AndroidLintQuickFix {
    private int myApi;

    public AddTargetVersionCheckQuickFix(int api) {
        this.myApi = api;
    }

    @NotNull
    static String getVersionField(int myApi, boolean fullyQualified) {
        String codeName = SdkVersionInfo.getBuildCode((int)myApi);
        if (codeName == null) {
            String string = Integer.toString(myApi);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "getVersionField"));
            }
            return string;
        }
        if (fullyQualified) {
            String string = "android.os.Build.VERSION_CODES." + codeName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "getVersionField"));
            }
            return string;
        }
        String string = codeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "getVersionField"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Surround with if (VERSION.SDK_INT >= VERSION_CODES." + AddTargetVersionCheckQuickFix.getVersionField(this.myApi, false) + ") { ... }";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "getName"));
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "isApplicable"));
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false);
        return expression != null;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/AddTargetVersionCheckQuickFix", "apply"));
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false);
        if (expression == null) {
            return;
        }
        PsiStatement anchorStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
        Editor editor = PsiUtilBase.findEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false);
        PsiFile file = expression.getContainingFile();
        Project project = expression.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchorStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = "android.os.Build.VERSION.SDK_INT >= " + AddTargetVersionCheckQuickFix.getVersionField(this.myApi, true);
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            documentManager.commitDocument(document);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (owner != null && owner.isValid() && !ApplicationManager.getApplication().isUnitTestMode()) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)owner);
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance(AddTargetVersionCheckQuickFix.class).error((Throwable)e);
        }
    }
}

