/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.ddms.adb.AdbService;
import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.actions.AndroidRunSdkToolAction;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunDdmsAction
extends AndroidRunSdkToolAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.AndroidRunDdmsAction");
    private static volatile OSProcessHandler ourProcessHandler;

    public AndroidRunDdmsAction() {
        super(AndroidBundle.message("android.launch.ddms.title", new Object[0]));
    }

    @Override
    protected void doRunTool(final @NotNull Project project, @NotNull String sdkPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/AndroidRunDdmsAction", "doRunTool"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/actions/AndroidRunDdmsAction", "doRunTool"));
        }
        if (AndroidRunDdmsAction.getDdmsProcessHandler() != null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("android.launch.ddms.already.launched.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        final boolean adbServiceEnabled = AndroidEnableAdbServiceAction.isAdbServiceEnabled();
        if (adbServiceEnabled && !AndroidEnableAdbServiceAction.disableAdbService(project)) {
            return;
        }
        String toolPath = sdkPath + File.separator + AndroidCommonUtils.toolPath((String)AndroidRunDdmsAction.getDdmsCmdName());
        final GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(toolPath);
        LOG.info(commandLine.getCommandLineString());
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidRunDdmsAction.doLaunchDdms(commandLine, project, adbServiceEnabled);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doLaunchDdms(GeneralCommandLine commandLine, Project project, boolean adbServiceWasEnabled) {
        try {
            ourProcessHandler = new OSProcessHandler(commandLine);
            ourProcessHandler.startNotify();
            ourProcessHandler.waitFor();
            ourProcessHandler = null;
            if (!adbServiceWasEnabled) return;
        }
        catch (ExecutionException e) {
            try {
                LOG.info((Throwable)e);
                ourProcessHandler = null;
                if (!adbServiceWasEnabled) return;
            }
            catch (Throwable throwable) {
                ourProcessHandler = null;
                if (!adbServiceWasEnabled) throw throwable;
                ApplicationManager.getApplication().invokeLater(new Runnable(project){
                    final /* synthetic */ Project val$project;
                    {
                        this.val$project = project;
                    }

                    @Override
                    public void run() {
                        if (this.val$project.isDisposed()) {
                            return;
                        }
                        AndroidEnableAdbServiceAction.setAdbServiceEnabled(this.val$project, true);
                        File adb = AndroidSdkUtils.getAdb(this.val$project);
                        if (adb != null) {
                            AdbService.getInstance().getDebugBridge(adb);
                        }
                    }
                });
                throw throwable;
            }
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
        return;
    }

    @Nullable
    public static OSProcessHandler getDdmsProcessHandler() {
        return ourProcessHandler;
    }

    @NotNull
    private static String getDdmsCmdName() {
        String archName = SystemInfo.OS_ARCH.equalsIgnoreCase("x86_64") || SystemInfo.OS_ARCH.equalsIgnoreCase("amd64") ? "x86_64" : "x86";
        String dir = "lib/monitor-" + archName + "/";
        if (SystemInfo.isMac) {
            String string = dir + "monitor.app/Contents/MacOS/monitor";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidRunDdmsAction", "getDdmsCmdName"));
            }
            return string;
        }
        String string = dir + (SystemInfo.isWindows ? "monitor.exe" : "monitor");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidRunDdmsAction", "getDdmsCmdName"));
        }
        return string;
    }
}

