/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.awt.Color;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidColorAnnotator
implements Annotator {
    private static final int ICON_SIZE = 8;
    private static final int MAX_ICON_SIZE = 5000;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        ResourceType type;
        AndroidPsiUtils.ResourceReferenceType referenceType;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/AndroidColorAnnotator", "annotate"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String tagName = tag.getName();
            if (ResourceType.COLOR.getName().equals(tagName) || ResourceType.DRAWABLE.getName().equals(tagName) || ResourceType.MIPMAP.getName().equals(tagName)) {
                DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
                if (domElement instanceof ResourceElement) {
                    String value = tag.getValue().getText().trim();
                    AndroidColorAnnotator.annotateXml(element, holder, value);
                }
            } else if ("item".equals(tagName)) {
                XmlTagValue value = tag.getValue();
                String text = value.getText();
                AndroidColorAnnotator.annotateXml(element, holder, text);
            }
        } else if (element instanceof XmlAttributeValue) {
            XmlAttributeValue v = (XmlAttributeValue)element;
            String value = v.getValue();
            if (value == null || value.isEmpty()) {
                return;
            }
            AndroidColorAnnotator.annotateXml(element, holder, value);
        } else if (element instanceof PsiReferenceExpression && (referenceType = AndroidPsiUtils.getResourceReferenceType(element)) != AndroidPsiUtils.ResourceReferenceType.NONE && ((type = AndroidPsiUtils.getResourceType(element)) == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP)) {
            String name = AndroidPsiUtils.getResourceName(element);
            AndroidColorAnnotator.annotateResourceReference(type, holder, element, name, referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK);
        }
    }

    private static void annotateXml(PsiElement element, AnnotationHolder holder, String value) {
        if (value.startsWith("#")) {
            PsiFile file = element.getContainingFile();
            if (file != null && AndroidResourceUtil.isInResourceSubdirectory(file, null)) {
                if (element instanceof XmlTag) {
                    Annotation annotation = holder.createInfoAnnotation(element, null);
                    annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, null));
                } else {
                    assert (element instanceof XmlAttributeValue);
                    Color color = ResourceHelper.parseColor(value);
                    if (color != null) {
                        Annotation annotation = holder.createInfoAnnotation(element, null);
                        annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, null));
                    }
                }
            }
        } else if (value.startsWith("@color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value.substring("@color/".length()), false);
        } else if (value.startsWith("@android:color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value.substring("@android:color/".length()), true);
        } else if (value.startsWith("@drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value.substring("@drawable/".length()), false);
        } else if (value.startsWith("@android:drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value.substring("@android:drawable/".length()), true);
        } else if (value.startsWith("@mipmap/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.MIPMAP, holder, element, value.substring("@mipmap/".length()), false);
        }
    }

    @Nullable
    public static VirtualFile pickLayoutFile(@NotNull Module module, @NotNull AndroidFacet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/AndroidColorAnnotator", "pickLayoutFile"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/AndroidColorAnnotator", "pickLayoutFile"));
        }
        VirtualFile layout = null;
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)module.getProject()).getOpenFiles();
        for (VirtualFile file : openFiles) {
            if (!file.getName().endsWith(".xml") || file.getParent() == null || !file.getParent().getName().startsWith("layout")) continue;
            layout = file;
            break;
        }
        if (layout == null) {
            for (VirtualFile resourceDir : facet.getAllResourceDirectories()) {
                block2: for (VirtualFile folder : resourceDir.getChildren()) {
                    if (!folder.getName().startsWith("layout") || !folder.isDirectory()) continue;
                    for (VirtualFile file : folder.getChildren()) {
                        if (!file.getName().endsWith(".xml") || file.getParent() == null || !file.getParent().getName().startsWith("layout")) continue;
                        layout = file;
                        continue block2;
                    }
                }
            }
        }
        return layout;
    }

    private static void annotateResourceReference(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String name, boolean isFramework) {
        ResourceResolver resourceResolver;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class);
        if (file == null) {
            return;
        }
        Configuration configuration = AndroidColorAnnotator.pickConfiguration(facet, module, file);
        if (configuration == null) {
            return;
        }
        ResourceValue value = AndroidColorAnnotator.findResourceValue(type, name, isFramework, module, configuration);
        if (value != null && (resourceResolver = configuration.getResourceResolver()) != null) {
            AndroidColorAnnotator.annotateResourceValue(type, holder, element, value, resourceResolver);
        }
    }

    @Nullable
    private static Configuration pickConfiguration(AndroidFacet facet, Module module, PsiFile file) {
        VirtualFile layout;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        String parentName = parent.getName();
        if (!parentName.startsWith("layout")) {
            layout = AndroidColorAnnotator.pickLayoutFile(module, facet);
            if (layout == null) {
                return null;
            }
        } else {
            layout = virtualFile;
        }
        return facet.getConfigurationManager().getConfiguration(layout);
    }

    private static void annotateResourceValue(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull ResourceValue value, @NotNull ResourceResolver resourceResolver) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (resourceResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceResolver", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        Project project = element.getProject();
        if (type == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)resourceResolver, value, project);
            if (color != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, color));
            }
        } else {
            File iconFile;
            assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
            File file = ResourceHelper.resolveDrawable((RenderResources)resourceResolver, value, project);
            if (file != null && file.getPath().endsWith(".xml")) {
                file = AndroidColorAnnotator.pickBitmapFromXml(file, resourceResolver, project);
            }
            if ((iconFile = AndroidColorAnnotator.pickBestBitmap(file)) != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(element, iconFile));
            }
        }
    }

    @Nullable
    private static File pickBitmapFromXml(@NotNull File file, @NotNull ResourceResolver resourceResolver, @NotNull Project project) {
        block14: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/AndroidColorAnnotator", "pickBitmapFromXml"));
            }
            if (resourceResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceResolver", "org/jetbrains/android/AndroidColorAnnotator", "pickBitmapFromXml"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidColorAnnotator", "pickBitmapFromXml"));
            }
            try {
                String src;
                ResourceValue value;
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null || document.getDocumentElement() == null) break block14;
                Element root = document.getDocumentElement();
                String tag = root.getTagName();
                Element target = null;
                String attribute = null;
                if ("vector".equals(tag)) {
                    return file;
                }
                if ("bitmap".equals(tag) || "nine-patch".equals(tag)) {
                    target = root;
                    attribute = "src";
                } else if ("selector".equals(tag) || "level-list".equals(tag) || "layer-list".equals(tag) || "transition".equals(tag)) {
                    NodeList children = root.getChildNodes();
                    for (int i = children.getLength() - 1; i >= 0; --i) {
                        Node item = children.item(i);
                        if (item.getNodeType() != 1 || !"item".equals(item.getNodeName()) || !(target = (Element)item).hasAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) continue;
                        attribute = "drawable";
                        break;
                    }
                } else if ("clip".equals(tag) || "inset".equals(tag) || "scale".equals(tag)) {
                    target = root;
                    attribute = "drawable";
                } else {
                    return null;
                }
                if (attribute != null && target.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute) && (value = resourceResolver.findResValue(src = target.getAttributeNS("http://schemas.android.com/apk/res/android", attribute), false)) != null) {
                    return ResourceHelper.resolveDrawable((RenderResources)resourceResolver, value, project);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static File pickBestBitmap(@Nullable File bitmap) {
        if (bitmap != null && bitmap.exists()) {
            File smallest = AndroidColorAnnotator.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.length();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static File findSmallestDpiVersion(File bitmap) {
        File parentFile = bitmap.getParentFile();
        if (parentFile == null) {
            return null;
        }
        File resFolder = parentFile.getParentFile();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            for (int i = densities.length - 1; i >= 0; --i) {
                String folder;
                Density d = densities[i];
                if (!d.isValidValueForDevice() || !(bitmap = new File(resFolder, (folder = parentName.replace(density.getResourceValue(), d.getResourceValue())) + File.separator + fileName)).exists()) continue;
                if (bitmap.length() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static ResourceValue findResourceValue(ResourceType type, String name, boolean isFramework, Module module, Configuration configuration) {
        if (isFramework) {
            ResourceRepository frameworkResources = configuration.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            if (!frameworkResources.hasResourceItem(type, name)) {
                return null;
            }
            ResourceItem item = frameworkResources.getResourceItem(type, name);
            return item.getResourceValue(type, configuration.getFullConfig(), false);
        }
        AppResourceRepository appResources = AppResourceRepository.getAppResources(module, true);
        if (appResources == null) {
            return null;
        }
        if (!appResources.hasResourceItem(type, name)) {
            return null;
        }
        return appResources.getConfiguredValue(type, name, configuration.getFullConfig());
    }

    private static class MyRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;

        private MyRenderer(@NotNull PsiElement element, @Nullable Color color) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator$MyRenderer", "<init>"));
            }
            this.myElement = element;
            this.myColor = color;
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            Icon icon = color == null ? EmptyIcon.create((int)8) : new ColorIcon(8, color);
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidColorAnnotator$MyRenderer", "getIcon"));
            }
            return icon;
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (this.myColor != null) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Color color;
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null && (color = ColorPicker.showDialog(editor.getComponent(), "Choose Color", this.getCurrentColor(), true, null, false)) != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                XmlAttribute attribute;
                                if (myElement instanceof XmlTag) {
                                    ((XmlTag)myElement).getValue().setText(ResourceHelper.colorToString(color));
                                } else if (myElement instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)myElement, XmlAttribute.class)) != null) {
                                    attribute.setValue(ResourceHelper.colorToString(color));
                                }
                            }
                        });
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyRenderer that = (MyRenderer)((Object)o);
            if (this.myColor != null ? !this.myColor.equals(that.myColor) : that.myColor != null) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            int result = this.myElement.hashCode();
            result = 31 * result + (this.myColor != null ? this.myColor.hashCode() : 0);
            return result;
        }
    }
}

