/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueWithDisplayString {
    public static final String TEXT_APPEARANCE_SUFFIX = "TextAppearance";
    public static final ValueWithDisplayString SEPARATOR = new ValueWithDisplayString("-", "-");
    public static final ValueWithDisplayString UNSET = new ValueWithDisplayString("none", null);
    public static final ValueWithDisplayString[] EMPTY_ARRAY = new ValueWithDisplayString[0];
    private static final Pattern TEXT_APPEARANCE_PATTERN = Pattern.compile("^((@(\\w+:)?)style/)?TextAppearance.(.+)$");
    private final String myDisplay;
    private final String myValue;

    public static ValueWithDisplayString[] create(@NotNull String[] values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "create"));
        }
        ValueWithDisplayString[] array = new ValueWithDisplayString[values.length];
        int index = 0;
        for (String value : values) {
            array[index++] = new ValueWithDisplayString(value, value);
        }
        return array;
    }

    public static ValueWithDisplayString[] create(@NotNull List<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "create"));
        }
        ValueWithDisplayString[] array = new ValueWithDisplayString[values.size()];
        int index = 0;
        for (String value : values) {
            array[index++] = new ValueWithDisplayString(value, value);
        }
        return array;
    }

    public static ValueWithDisplayString create(@Nullable String value, @NotNull NlProperty property) {
        ValueWithDisplayString attr;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "create"));
        }
        if (value == null) {
            return UNSET;
        }
        String display = property.resolveValue(value);
        if ((property.getName().equals("textAppearance") || property.getName().endsWith(TEXT_APPEARANCE_SUFFIX)) && (attr = ValueWithDisplayString.createStyleValue(display, "", value)) != null) {
            return attr;
        }
        return new ValueWithDisplayString(display, value);
    }

    public static ValueWithDisplayString createStyleValue(@NotNull String styleName, @NotNull String defaultPrefix, @Nullable String value) {
        if (styleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleName", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "createStyleValue"));
        }
        if (defaultPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPrefix", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "createStyleValue"));
        }
        String prefix = "";
        String display = styleName;
        String style = styleName;
        Matcher matcher = TEXT_APPEARANCE_PATTERN.matcher(styleName);
        if (matcher.matches()) {
            prefix = matcher.group(1);
            display = matcher.group(4);
            style = matcher.group(0);
        }
        if (value == null) {
            prefix = StringUtil.isEmpty((String)prefix) ? defaultPrefix : "";
            value = prefix + style;
        }
        return new ValueWithDisplayString(display, value);
    }

    public ValueWithDisplayString(@NotNull String display, @Nullable String value) {
        if (display == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "display", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "<init>"));
        }
        this.myDisplay = display;
        this.myValue = value;
    }

    @NotNull
    public String toString() {
        String string = this.myDisplay;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/ValueWithDisplayString", "toString"));
        }
        return string;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    public int hashCode() {
        return Objects.hashCode(this.myValue);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValueWithDisplayString)) {
            return false;
        }
        return Objects.equals(this.myValue, ((ValueWithDisplayString)other).myValue);
    }
}

