/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.assetstudiolib.AndroidVectorIcons;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanIconEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.ValueWithDisplayString;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NlGravityEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private static final int SMALL_WIDTH = 65;
    private static final List<String> ALL_VERTICAL_ITEMS = ImmutableList.of((Object)"top", (Object)"bottom", (Object)"center_vertical", (Object)"center", (Object)"fill_vertical", (Object)"fill");
    private static final List<String> ALL_HORIZONTAL_ITEMS = ImmutableList.of((Object)"start", (Object)"end", (Object)"left", (Object)"right", (Object)"center_horizontal", (Object)"center", (Object)"fill_horizontal", (Object)"fill");
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private final NlBooleanIconEditor myHorizontalClipButton = new NlBooleanIconEditor((Icon)AndroidVectorIcons.LayoutEditorIcons.Clip, "Clip Horizontally");
    private final NlBooleanIconEditor myVerticalClipButton = new NlBooleanIconEditor((Icon)AndroidVectorIcons.LayoutEditorIcons.Clip, "Clip Vertically");
    private final JComboBox<ValueWithDisplayString> myHorizontalGravity = new ComboBox(NlGravityEditor.getHorizontalModel(), 65);
    private final JComboBox<ValueWithDisplayString> myVerticalGravity = new ComboBox(NlGravityEditor.getVerticalModel(), 65);
    private NlFlagPropertyItem myProperty;
    private JLabel myLabel;
    private boolean myUpdatingProperty;

    public NlGravityEditor() {
        super(NlEditingListener.DEFAULT_LISTENER);
        this.myHorizontalGravity.addActionListener(event -> this.comboValuePicked(this.myHorizontalGravity, ALL_HORIZONTAL_ITEMS, "center_vertical", "fill_vertical"));
        this.myVerticalGravity.addActionListener(event -> this.comboValuePicked(this.myVerticalGravity, ALL_VERTICAL_ITEMS, "center_horizontal", "fill_horizontal"));
        this.addRow(0, "Horizontal:", this.myHorizontalGravity, this.myHorizontalClipButton.getComponent());
        this.addRow(1, "Vertical:", this.myVerticalGravity, this.myVerticalClipButton.getComponent());
    }

    private void addRow(int row, @NotNull String direction, @NotNull JComponent comboBox, @NotNull Component button) {
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "addRow"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "addRow"));
        }
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "addRow"));
        }
        JBLabel label = new JBLabel(direction);
        Insets margin = new Insets(0, 20, 0, 0);
        Insets insets = new Insets(0, 0, 0, 0);
        this.myPanel.add((Component)label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, margin, 0, 0));
        this.myPanel.add((Component)comboBox, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.myPanel.add(button, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
    }

    private void comboValuePicked(@NotNull JComboBox combo, @NotNull List<String> allItemsInDirection, @NotNull String oppositeCenter, @NotNull String oppositeFill) {
        if (combo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combo", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "comboValuePicked"));
        }
        if (allItemsInDirection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allItemsInDirection", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "comboValuePicked"));
        }
        if (oppositeCenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oppositeCenter", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "comboValuePicked"));
        }
        if (oppositeFill == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oppositeFill", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "comboValuePicked"));
        }
        if (this.myUpdatingProperty || this.myProperty == null) {
            return;
        }
        HashSet<String> itemsToAdd = new HashSet<String>();
        HashSet<String> itemsToRemove = new HashSet<String>();
        String value = ((ValueWithDisplayString)combo.getSelectedItem()).getValue();
        if (!StringUtil.isEmpty((String)value)) {
            itemsToAdd.add(value);
        }
        itemsToRemove.addAll(allItemsInDirection);
        if (this.myProperty.isItemSet("center")) {
            itemsToAdd.add(oppositeCenter);
        }
        if (this.myProperty.isItemSet("center")) {
            itemsToAdd.add(oppositeFill);
        }
        this.myProperty.updateItems(itemsToAdd, itemsToRemove);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myHorizontalGravity.setEnabled(enabled);
        this.myVerticalGravity.setEnabled(enabled);
        this.myHorizontalClipButton.getComponent().setEnabled(enabled);
        this.myVerticalClipButton.getComponent().setEnabled(enabled);
    }

    @Override
    public void setVisible(boolean visible) {
        this.myPanel.setVisible(visible);
        if (this.myLabel != null) {
            this.myLabel.setVisible(visible);
        }
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "setProperty"));
        }
        this.myUpdatingProperty = true;
        try {
            this.myProperty = (NlFlagPropertyItem)property;
            this.myHorizontalClipButton.setProperty(property.getChildProperty("clip_horizontal"));
            this.myVerticalClipButton.setProperty(property.getChildProperty("clip_vertical"));
            this.myHorizontalGravity.setSelectedItem(this.getSelectedHorizontalValue());
            this.myVerticalGravity.setSelectedItem(this.getSelectedVerticalValue());
        }
        finally {
            this.myUpdatingProperty = false;
        }
    }

    @Override
    public void refresh() {
        if (this.myProperty != null) {
            this.setProperty(this.myProperty);
        }
    }

    @Override
    public void requestFocus() {
        this.myHorizontalGravity.requestFocus();
    }

    @Override
    public NlFlagPropertyItem getProperty() {
        return this.myProperty;
    }

    @Override
    public void setLabel(@NotNull JLabel label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/uibuilder/property/editors/NlGravityEditor", "setLabel"));
        }
        this.myLabel = label;
    }

    @Override
    public JLabel getLabel() {
        return this.myLabel;
    }

    private ValueWithDisplayString getSelectedHorizontalValue() {
        if (this.myProperty.isAnyItemSet("fill", "fill_horizontal")) {
            return new ValueWithDisplayString("fill", "fill_horizontal");
        }
        if (this.myProperty.isAnyItemSet("center", "center_horizontal")) {
            return new ValueWithDisplayString("center", "center_horizontal");
        }
        if (this.myProperty.isAnyItemSet("start", "left")) {
            return new ValueWithDisplayString("start", "start");
        }
        if (this.myProperty.isAnyItemSet("end", "right")) {
            return new ValueWithDisplayString("end", "end");
        }
        return new ValueWithDisplayString("none", "");
    }

    private ValueWithDisplayString getSelectedVerticalValue() {
        if (this.myProperty.isAnyItemSet("fill", "fill_vertical")) {
            return new ValueWithDisplayString("fill", "fill_vertical");
        }
        if (this.myProperty.isAnyItemSet("center", "center_vertical")) {
            return new ValueWithDisplayString("center", "center_vertical");
        }
        if (this.myProperty.isAnyItemSet("top")) {
            return new ValueWithDisplayString("top", "top");
        }
        if (this.myProperty.isAnyItemSet("bottom")) {
            return new ValueWithDisplayString("bottom", "bottom");
        }
        return new ValueWithDisplayString("none", "");
    }

    private static ComboBoxModel<ValueWithDisplayString> getHorizontalModel() {
        return new DefaultComboBoxModel<ValueWithDisplayString>(new ValueWithDisplayString[]{new ValueWithDisplayString("none", ""), new ValueWithDisplayString("start", "start"), new ValueWithDisplayString("end", "end"), new ValueWithDisplayString("center", "center_horizontal"), new ValueWithDisplayString("fill", "fill_horizontal")});
    }

    private static ComboBoxModel<ValueWithDisplayString> getVerticalModel() {
        return new DefaultComboBoxModel<ValueWithDisplayString>(new ValueWithDisplayString[]{new ValueWithDisplayString("none", ""), new ValueWithDisplayString("top", "top"), new ValueWithDisplayString("bottom", "bottom"), new ValueWithDisplayString("center", "center_vertical"), new ValueWithDisplayString("fill", "fill_vertical")});
    }

    public static interface Listener {
        public void valueChanged(@NotNull NlGravityEditor var1);
    }
}

