/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.intellij.ui.ColoredTableCellRenderer;
import java.util.function.Predicate;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class NlPropertyAccumulator {
    private final String myGroupName;
    private final Predicate<NlPropertyItem> myFilter;
    private PTableGroupItem myGroupNode;

    public NlPropertyAccumulator(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "<init>"));
        }
        this.myGroupName = groupName;
        this.myFilter = null;
    }

    public NlPropertyAccumulator(@NotNull String groupName, @NotNull Predicate<NlPropertyItem> isApplicable) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "<init>"));
        }
        if (isApplicable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isApplicable", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "<init>"));
        }
        this.myGroupName = groupName;
        this.myFilter = isApplicable;
    }

    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "getGroupName"));
        }
        return string;
    }

    protected boolean isApplicable(@NotNull NlPropertyItem p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "isApplicable"));
        }
        assert (this.myFilter != null);
        return this.myFilter.test(p);
    }

    public boolean process(@NotNull NlPropertyItem p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "process"));
        }
        if (!this.isApplicable(p)) {
            return false;
        }
        if (this.myGroupNode == null) {
            this.myGroupNode = this.createGroupNode(this.myGroupName);
        }
        this.myGroupNode.addChild(p);
        return true;
    }

    public boolean hasItems() {
        return this.myGroupNode != null && !this.myGroupNode.getChildren().isEmpty();
    }

    @NotNull
    public PTableGroupItem getGroupNode() {
        PTableGroupItem pTableGroupItem = this.myGroupNode == null ? this.createGroupNode(this.myGroupName) : this.myGroupNode;
        if (pTableGroupItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "getGroupNode"));
        }
        return pTableGroupItem;
    }

    @NotNull
    protected PTableGroupItem createGroupNode(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "createGroupNode"));
        }
        GroupNode groupNode = new GroupNode(groupName);
        if (groupNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator", "createGroupNode"));
        }
        return groupNode;
    }

    public static class PropertyNamePrefixAccumulator
    extends NlPropertyAccumulator {
        public PropertyNamePrefixAccumulator(@NotNull String groupName, @NotNull String prefix) {
            if (groupName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator$PropertyNamePrefixAccumulator", "<init>"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator$PropertyNamePrefixAccumulator", "<init>"));
            }
            super(groupName, (NlPropertyItem p) -> {
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator$PropertyNamePrefixAccumulator", "lambda$new$0"));
                }
                return p != null && p.getName().startsWith(prefix);
            });
        }
    }

    private static class GroupNode
    extends PTableGroupItem {
        private static final ColoredTableCellRenderer EMPTY_VALUE_RENDERER = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            }
        };
        private final String myStyleable;

        public GroupNode(@NotNull String styleable) {
            if (styleable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleable", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator$GroupNode", "<init>"));
            }
            this.myStyleable = styleable;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myStyleable;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator$GroupNode", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public TableCellRenderer getCellRenderer() {
            ColoredTableCellRenderer coloredTableCellRenderer = EMPTY_VALUE_RENDERER;
            if (coloredTableCellRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyAccumulator$GroupNode", "getCellRenderer"));
            }
            return coloredTableCellRenderer;
        }
    }
}

