/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconPreviewFactory {
    private static final Logger LOG = Logger.getInstance(IconPreviewFactory.class);
    private static final int SHADOW_SIZE = 6;
    private static final int PREVIEW_LIMIT = 4000;
    private static final int DEFAULT_X_DIMENSION = 1080;
    private static final int DEFAULT_Y_DIMENSION = 1920;
    private static final String DEFAULT_THEME = "AppTheme";
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String CONTAINER_ID = "TopLevelContainer";
    private static final String LINEAR_LAYOUT = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
    private static IconPreviewFactory ourInstance;

    @NotNull
    public static IconPreviewFactory get() {
        if (ourInstance == null) {
            ourInstance = new IconPreviewFactory();
        }
        IconPreviewFactory iconPreviewFactory = ourInstance;
        if (iconPreviewFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "get"));
        }
        return iconPreviewFactory;
    }

    private IconPreviewFactory() {
    }

    @Nullable
    public BufferedImage getImage(@NotNull Palette.Item item, @NotNull Configuration configuration, double scale) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getImage"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getImage"));
        }
        BufferedImage image = IconPreviewFactory.readImage(item.getId(), configuration);
        if (image == null) {
            return null;
        }
        if (scale != 1.0) {
            image = ImageUtils.scale(image, scale, scale);
        }
        return image;
    }

    @Nullable
    public BufferedImage renderDragImage(@NotNull Palette.Item item, @NotNull ScreenView screenView) {
        XmlTag tag;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "renderDragImage"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "renderDragImage"));
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)screenView.getModel().getProject());
        String xml = item.getDragPreviewXml();
        if (xml.equals("")) {
            return null;
        }
        try {
            tag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        NlModel model = screenView.getModel();
        NlComponent component = (NlComponent)ApplicationManager.getApplication().runWriteAction(() -> {
            if (screenView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "lambda$renderDragImage$0"));
            }
            return model.createComponent(screenView, tag, null, null, InsertType.CREATE_PREVIEW);
        });
        if (component == null) {
            return null;
        }
        xml = String.format(LINEAR_LAYOUT, CONTAINER_ID, component.getTag().getText());
        RenderResult result = IconPreviewFactory.renderImage(xml, model.getConfiguration());
        if (result == null) {
            return null;
        }
        BufferedImage image = result.getRenderedImage();
        if (image == null) {
            return null;
        }
        List infos = result.getRootViews();
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        if ((infos = infos.get(0).getChildren()) == null || infos.isEmpty()) {
            return null;
        }
        ViewInfo view = (ViewInfo)infos.get(0);
        if (image.getHeight() < view.getBottom() || image.getWidth() < view.getRight() || view.getBottom() <= view.getTop() || view.getRight() <= view.getLeft()) {
            return null;
        }
        int shadowWitdh = 6 * screenView.getConfiguration().getDensity().getDpiValue() / 160;
        int shadowIncrement = 1 + Coordinates.getSwingDimension(screenView, shadowWitdh);
        return image.getSubimage(view.getLeft(), view.getTop(), Math.min(view.getRight() + shadowIncrement, image.getWidth()), Math.min(view.getBottom() + shadowIncrement, image.getHeight()));
    }

    private static BufferedImage readImage(@NotNull String id, @NotNull Configuration configuration) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "readImage"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "readImage"));
        }
        File file = new File(IconPreviewFactory.getPreviewCacheDirForConfiguration(configuration), id + ".png");
        if (!file.exists()) {
            return null;
        }
        try {
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void dropCache() {
        FileUtil.delete((File)IconPreviewFactory.getPreviewCacheDir());
    }

    public boolean load(@NotNull Configuration configuration, @NotNull Palette palette, boolean reload) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "load"));
        }
        if (palette == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "palette", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "load"));
        }
        return this.load(configuration, palette, reload, null, null);
    }

    boolean load(final @NotNull Configuration configuration, final @NotNull Palette palette, boolean reload, final @Nullable List<String> requestedIds, final @Nullable List<String> generatedIds) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "load"));
        }
        if (palette == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "palette", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "load"));
        }
        File cacheDir = IconPreviewFactory.getPreviewCacheDirForConfiguration(configuration);
        String[] files = cacheDir.list();
        if (files != null && files.length > 0) {
            if (!reload) {
                return false;
            }
            FileUtil.delete((File)cacheDir);
        }
        ApplicationManager.getApplication().runReadAction((Computable)new Computable<Void>(){

            public Void compute() {
                ArrayList sources = Lists.newArrayList();
                IconPreviewFactory.loadSources(sources, requestedIds, palette.getItems());
                for (StringBuilder source : sources) {
                    String preview = String.format(IconPreviewFactory.LINEAR_LAYOUT, IconPreviewFactory.CONTAINER_ID, source);
                    RenderResult result = IconPreviewFactory.renderImage(preview, configuration);
                    IconPreviewFactory.addResultToCache(result, generatedIds, configuration);
                }
                return null;
            }
        });
        return true;
    }

    private static void loadSources(@NotNull List<StringBuilder> sources, @Nullable List<String> ids, List<Palette.BaseItem> items) {
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "loadSources"));
        }
        boolean previousRenderedSeparately = false;
        for (Palette.BaseItem base : items) {
            StringBuilder last;
            Palette.Item item;
            String preview;
            if (base instanceof Palette.Group) {
                Palette.Group group = (Palette.Group)base;
                IconPreviewFactory.loadSources(sources, ids, group.getItems());
                continue;
            }
            if (!(base instanceof Palette.Item) || (preview = (item = (Palette.Item)base).getPreviewXml()).equals("")) continue;
            StringBuilder stringBuilder = last = sources.isEmpty() ? null : sources.get(sources.size() - 1);
            if (last == null || last.length() > 4000 || last.length() > 0 && (item.isPreviewRenderedSeparately() || previousRenderedSeparately)) {
                last = new StringBuilder();
                sources.add(last);
            }
            previousRenderedSeparately = item.isPreviewRenderedSeparately();
            last.append(preview);
            if (ids == null) continue;
            ids.add(item.getId());
        }
    }

    @NotNull
    private static File getPreviewCacheDir() {
        File file = new File(PathUtil.getCanonicalPath((String)PathManager.getSystemPath()) + File.separator + "android-palette" + File.separator + "v1" + File.separator + "image-cache");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getPreviewCacheDir"));
        }
        return file;
    }

    @NotNull
    private static File getPreviewCacheDirForConfiguration(@NotNull Configuration configuration) {
        ScreenOrientation orientation;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getPreviewCacheDirForConfiguration"));
        }
        int density = configuration.getDensity().getDpiValue();
        State state = configuration.getDeviceState();
        Screen screen = state != null ? state.getHardware().getScreen() : null;
        int xDimension = 1080;
        int yDimension = 1920;
        if (screen != null) {
            xDimension = screen.getXDimension();
            yDimension = screen.getYDimension();
            density = screen.getPixelDensity().getDpiValue();
        }
        ScreenOrientation screenOrientation = orientation = state != null ? state.getOrientation() : ScreenOrientation.PORTRAIT;
        if (orientation == ScreenOrientation.LANDSCAPE && xDimension < yDimension || orientation == ScreenOrientation.PORTRAIT && xDimension > yDimension) {
            int temp = xDimension;
            xDimension = yDimension;
            yDimension = temp;
        }
        String theme = IconPreviewFactory.getTheme(configuration);
        String apiVersion = IconPreviewFactory.getApiVersion(configuration);
        String cacheFolder = theme + File.separator + xDimension + "x" + yDimension + "-" + density + "-" + apiVersion;
        File file = new File(IconPreviewFactory.getPreviewCacheDir(), cacheFolder);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getPreviewCacheDirForConfiguration"));
        }
        return file;
    }

    @NotNull
    private static String getTheme(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getTheme"));
        }
        String theme = configuration.getTheme();
        if (theme == null) {
            theme = DEFAULT_THEME;
        } else if (theme.startsWith("@style/")) {
            theme = theme.substring("@style/".length());
        } else if (theme.startsWith("@android:style/")) {
            theme = theme.substring("@android:style/".length());
        }
        String string = theme;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getTheme"));
        }
        return string;
    }

    private static String getApiVersion(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "getApiVersion"));
        }
        IAndroidTarget target = configuration.getTarget();
        return target == null ? "24U" : target.getVersion().getApiString();
    }

    private static void addResultToCache(@Nullable RenderResult result, @Nullable List<String> ids, @NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "addResultToCache"));
        }
        if (result == null || result.getRenderedImage() == null || result.getRootViews() == null || result.getRootViews().isEmpty()) {
            return;
        }
        ImageAccumulator accumulator = new ImageAccumulator(result.getRenderedImage(), ids, configuration);
        accumulator.run(result.getRootViews(), 0, null);
    }

    @Nullable
    private static RenderResult renderImage(@NotNull String xml, @NotNull Configuration configuration) {
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "renderImage"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory", "renderImage"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(configuration.getModule());
        if (facet == null) {
            return null;
        }
        Project project = configuration.getModule().getProject();
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
        RenderService renderService = RenderService.get(facet);
        RenderLogger logger = renderService.createLogger();
        RenderTask task = renderService.createTask(file, configuration, logger, null);
        RenderResult result = null;
        if (task != null) {
            task.setOverrideBgColor(UIUtil.TRANSPARENT_COLOR.getRGB());
            task.setDecorations(false);
            task.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
            task.setFolderType(ResourceFolderType.LAYOUT);
            result = task.render();
            task.dispose();
        }
        return result;
    }

    private static class ImageAccumulator {
        private final BufferedImage myImage;
        private final List<String> myIds;
        private final File myCacheDir;
        private final int myHeight;
        private final int myWidth;

        private ImageAccumulator(@NotNull BufferedImage image, @Nullable List<String> ids, @NotNull Configuration configuration) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory$ImageAccumulator", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory$ImageAccumulator", "<init>"));
            }
            this.myImage = image;
            this.myIds = ids;
            this.myCacheDir = IconPreviewFactory.getPreviewCacheDirForConfiguration(configuration);
            this.myHeight = image.getRaster().getHeight();
            this.myWidth = image.getRaster().getWidth();
        }

        private void run(@NotNull List<ViewInfo> views, int top, @Nullable String parentId) {
            if (views == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "views", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory$ImageAccumulator", "run"));
            }
            for (ViewInfo info : views) {
                String id = null;
                XmlTag tag = RenderService.getXmlTag(info);
                if (tag != null) {
                    id = ImageAccumulator.getId(tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
                    if (IconPreviewFactory.CONTAINER_ID.equals(parentId)) {
                        if (info.getBottom() + top <= this.myHeight && info.getRight() <= this.myWidth && info.getBottom() > info.getTop()) {
                            Rectangle bounds = new Rectangle(info.getLeft(), info.getTop() + top, info.getRight() - info.getLeft(), info.getBottom() - info.getTop());
                            BufferedImage image = this.myImage.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
                            if (id == null) {
                                id = tag.getName();
                            }
                            this.saveImage(id, image);
                            if (this.myIds != null) {
                                this.myIds.add(id);
                            }
                        } else {
                            LOG.warn(String.format("Dimensions of %1$s is out of range", id));
                        }
                    }
                }
                if (info.getChildren().isEmpty() || IconPreviewFactory.CONTAINER_ID.equals(parentId)) continue;
                this.run(info.getChildren(), top + info.getTop(), id);
            }
        }

        @Nullable
        private static String getId(@Nullable String id) {
            if (id != null) {
                if (id.startsWith("@+id/")) {
                    return id.substring("@+id/".length());
                }
                if (id.startsWith("@id/")) {
                    return id.substring("@id/".length());
                }
            }
            return id;
        }

        private void saveImage(@NotNull String id, @NotNull BufferedImage image) {
            block4: {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory$ImageAccumulator", "saveImage"));
                }
                if (image == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/uibuilder/palette/IconPreviewFactory$ImageAccumulator", "saveImage"));
                }
                this.myCacheDir.mkdirs();
                File file = new File(this.myCacheDir, id + ".png");
                try {
                    ImageIO.write((RenderedImage)image, "PNG", file);
                }
                catch (IOException e) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }
    }
}

