/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.base.Strings;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PreferenceHandler
extends ViewHandler {
    PreferenceHandler() {
    }

    @Override
    @Language(value="XML")
    @NotNull
    public abstract String getXml(@NotNull String var1, @NotNull XmlType var2);

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "onCreate"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "onCreate"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "onCreate"));
        }
        if (type.equals((Object)InsertType.CREATE)) {
            newChild.removeAndroidAttribute("layout_width");
            newChild.removeAndroidAttribute("layout_height");
        }
        return true;
    }

    @NotNull
    static String generateKey(@NotNull NlComponent component, @NotNull String tagName, @NotNull String keyPrefix) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "generateKey"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "generateKey"));
        }
        if (keyPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyPrefix", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "generateKey"));
        }
        XmlTag preferenceScreen = component.getModel().getFile().getRootTag();
        if (preferenceScreen == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "generateKey"));
            }
            return "";
        }
        XmlTag[] preferences = preferenceScreen.findSubTags(tagName);
        int i = 1;
        String key = keyPrefix + i++;
        while (PreferenceHandler.anyPreferenceKeyEquals(preferences, key)) {
            key = keyPrefix + i++;
        }
        String string = key;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "generateKey"));
        }
        return string;
    }

    private static boolean anyPreferenceKeyEquals(@NotNull XmlTag[] preferences, @NotNull String key) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "anyPreferenceKeyEquals"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "anyPreferenceKeyEquals"));
        }
        return Arrays.stream(preferences).map(preference -> preference.getAttributeValue("key", "http://schemas.android.com/apk/res/android")).anyMatch(key::equals);
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "getTitle"));
        }
        String string = Strings.nullToEmpty((String)component.getAndroidAttribute("title"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler", "getTitle"));
        }
        return string;
    }
}

