/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.assetstudiolib.AssetStudio;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final ScreenView myScreen;

    public ViewEditorImpl(@NotNull ScreenView screen) {
        if (screen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screen", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "<init>"));
        }
        this.myScreen = screen;
    }

    @Override
    public int getDpi() {
        return this.myScreen.getConfiguration().getDensity().getDpiValue();
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return AndroidModuleInfo.get(this.myScreen.getModel().getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.get(this.myScreen.getModel().getFacet()).getMinSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "getMinSdkVersion"));
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.get(this.myScreen.getModel().getFacet()).getTargetSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "getTargetSdkVersion"));
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myScreen.getConfiguration();
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "getConfiguration"));
        }
        return configuration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myScreen.getModel();
        if (nlModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "getModel"));
        }
        return nlModel;
    }

    @Override
    public boolean moduleContainsResource(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "moduleContainsResource"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "moduleContainsResource"));
        }
        return this.myScreen.getModel().getFacet().getModuleResources(true).hasResourceItem(type, name);
    }

    @Override
    public void copyVectorAssetToMainModuleSourceSet(@NotNull String asset) {
        String message;
        if (asset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asset", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "copyVectorAssetToMainModuleSourceSet"));
        }
        Project project = this.myScreen.getModel().getProject();
        if (Messages.showYesNoDialog((Project)project, (String)(message = "Do you want to copy vector asset " + asset + " to your main module source set?"), (String)"Copy Vector Asset", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        try (InputStream in = GraphicGenerator.class.getClassLoader().getResourceAsStream(AssetStudio.getPathForBasename((String)asset));){
            VirtualFile drawableDirectory = this.getDrawableDirectory();
            if (drawableDirectory == null) {
                return;
            }
            drawableDirectory.createChildData((Object)this, asset + ".xml").setBinaryContent(ByteStreams.toByteArray((InputStream)in));
        }
        catch (IOException exception) {
            Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
        }
    }

    @Nullable
    private VirtualFile getDrawableDirectory() throws IOException {
        VirtualFile resourceDirectory = this.myScreen.getModel().getFacet().getPrimaryResourceDir();
        if (resourceDirectory == null) {
            Logger.getInstance(ViewEditorImpl.class).warn("resourceDirectory is null");
            return null;
        }
        VirtualFile drawableDirectory = resourceDirectory.findChild("drawable");
        if (drawableDirectory == null) {
            return resourceDirectory.createChildDirectory((Object)this, "drawable");
        }
        return drawableDirectory;
    }

    @Override
    @Nullable
    public Map<NlComponent, Dimension> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "measureChildren"));
        }
        HashMap unweightedSizes = Maps.newHashMap();
        XmlTag parentTag = parent.getTag();
        if (parentTag.isValid()) {
            if (parent.getChildCount() == 0) {
                return Collections.emptyMap();
            }
            HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
            for (NlComponent child : parent.getChildren()) {
                tagToComponent.put(child.getTag(), child);
            }
            NlModel model = this.myScreen.getModel();
            XmlFile xmlFile = model.getFile();
            AndroidFacet facet = model.getFacet();
            RenderService renderService = RenderService.get(facet);
            RenderLogger logger = renderService.createLogger();
            RenderTask task = renderService.createTask((PsiFile)xmlFile, this.getConfiguration(), logger, null);
            if (task == null) {
                return null;
            }
            Map<XmlTag, ViewInfo> map = task.measureChildren(parentTag, filter);
            task.dispose();
            if (map != null) {
                for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                    ViewInfo viewInfo = entry.getValue();
                    viewInfo = RenderService.getSafeBounds(viewInfo);
                    Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                    NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                    if (child == null) continue;
                    unweightedSizes.put(child, size);
                }
            }
        }
        return unweightedSizes;
    }

    @Override
    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types) {
        String resource;
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "displayResourceInput"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "displayResourceInput"));
        }
        NlModel model = this.myScreen.getModel();
        ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(model.getModule()).setTypes(types).setConfiguration(model.getConfiguration()).build();
        if (!title.isEmpty()) {
            dialog.setTitle(title);
        }
        dialog.show();
        if (dialog.isOK() && (resource = dialog.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public String displayClassInput(@NotNull Set<String> superTypes, @Nullable Predicate<String> filter, @Nullable String currentValue) {
        if (superTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superTypes", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "displayClassInput"));
        }
        Module module = this.myScreen.getModel().getModule();
        String[] superTypesArray = ArrayUtil.toStringArray(superTypes);
        Condition psiFilter = null;
        if (filter != null) {
            psiFilter = psiClass -> {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    return false;
                }
                return filter.test(qualifiedName);
            };
        }
        return ChooseClassDialog.openDialog(module, "Classes", true, (Condition<PsiClass>)psiFilter, superTypesArray);
    }

    @NotNull
    public ScreenView getScreenView() {
        ScreenView screenView = this.myScreen;
        if (screenView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl", "getScreenView"));
        }
        return screenView;
    }
}

