/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.google.common.collect.ImmutableList;
import icons.AndroidDesignerIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollViewHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"scrollbarStyle", (Object)"style", (Object)"fillViewport", (Object)"clipToPadding");
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "getInspectorProperties"));
        }
        return immutableList;
    }

    @Override
    public void onChildInserted(@NotNull NlComponent parent, @NotNull NlComponent child, @NotNull InsertType insertType) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "onChildInserted"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "onChildInserted"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "onChildInserted"));
        }
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "match_parent");
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "onCreate"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "onCreate"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "onCreate"));
        }
        if (insertType.isCreate()) {
            NlComponent linear = node.createChild(editor, "android.widget.LinearLayout", null, InsertType.VIEW_HANDLER);
            linear.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
        }
        return true;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "createDragHandler"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "createDragHandler"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "createDragHandler"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "createDragHandler"));
        }
        return new OneChildDragHandler(editor, this, layout, components, type);
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor, @NotNull NlComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "createScrollHandler"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "createScrollHandler"));
        }
        int maxScrollableHeight = 0;
        for (NlComponent child : component.getChildren()) {
            maxScrollableHeight += child.h;
        }
        if ((maxScrollableHeight -= component.h) > 0) {
            return new ScrollViewScrollHandler(component, maxScrollableHeight, 10);
        }
        return null;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler", "addToolbarActions"));
        }
        actions.add(new ToggleRenderModeAction());
    }

    static class ToggleRenderModeAction
    extends ToggleViewAction {
        public ToggleRenderModeAction() {
            super(AndroidDesignerIcons.ViewportRender, AndroidDesignerIcons.NormalRender, "Toggle Viewport Render Mode", null);
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "isSelected"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "isSelected"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "isSelected"));
            }
            if (selectedChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedChildren", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "isSelected"));
            }
            return NlModel.isRenderViewPort();
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "setSelected"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "setSelected"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "setSelected"));
            }
            if (selectedChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedChildren", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$ToggleRenderModeAction", "setSelected"));
            }
            NlModel.setRenderViewPort(selected);
            parent.getModel().requestRender();
        }
    }

    static class OneChildDragHandler
    extends DragHandler {
        public OneChildDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$OneChildDragHandler", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$OneChildDragHandler", "<init>"));
            }
            if (layout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$OneChildDragHandler", "<init>"));
            }
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$OneChildDragHandler", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$OneChildDragHandler", "<init>"));
            }
            super(editor, handler, layout, components, type);
        }

        @Override
        @Nullable
        public String update(int x, int y, int modifiers) {
            super.update(x, y, modifiers);
            if (this.layout.getChildCount() > 0 || this.components.size() > 1) {
                return "Layout only allows 1 child";
            }
            return null;
        }

        @Override
        public void commit(int x, int y, int modifiers) {
        }

        @Override
        public void paint(@NotNull NlGraphics graphics) {
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/ScrollViewHandler$OneChildDragHandler", "paint"));
            }
            if (this.layout.getChildCount() == 0) {
                graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
                graphics.drawRect(this.layout.x, this.layout.y, this.layout.w, this.layout.h);
            }
        }
    }
}

