/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.editor.NlPaletteManager;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.editor.NlPropertiesWindowManager;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlAbstractWindowManager
extends LightToolWindowManager {
    public NlAbstractWindowManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "<init>"));
        }
        super(project, fileEditorManager);
    }

    protected void initToolWindow(@NotNull String id, @NotNull Icon icon) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "initToolWindow"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "initToolWindow"));
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(id, false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(icon);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindow.setAutoHide(false);
        this.initGearActions();
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(@Nullable FileEditor editor) {
        NlPreviewManager previewManager;
        if (editor instanceof NlEditor) {
            NlEditor designerEditor = (NlEditor)editor;
            return designerEditor.getComponent();
        }
        if (editor instanceof TextEditor && (previewManager = NlPreviewManager.getInstance(this.myProject)).isApplicableEditor((TextEditor)editor)) {
            return previewManager.getPreviewForm();
        }
        return null;
    }

    @Nullable
    protected static DesignSurface getDesignSurface(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "getDesignSurface"));
        }
        if (designer instanceof NlEditorPanel) {
            NlEditorPanel editor = (NlEditorPanel)designer;
            return editor.getSurface();
        }
        if (designer instanceof NlPreviewForm) {
            NlPreviewForm form = (NlPreviewForm)designer;
            return form.getFile() != null ? form.getSurface() : null;
        }
        throw new RuntimeException(designer.getClass().getName());
    }

    @NotNull
    protected static NlLayoutType getLayoutType(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "getLayoutType"));
        }
        DesignSurface designSurface = NlAbstractWindowManager.getDesignSurface(designer);
        NlLayoutType nlLayoutType = designSurface != null ? designSurface.getLayoutType() : NlLayoutType.UNKNOWN;
        if (nlLayoutType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "getLayoutType"));
        }
        return nlLayoutType;
    }

    protected void createWindowContent(@NotNull JComponent contentPane, @NotNull JComponent focusedComponent, @Nullable AnAction[] actions) {
        if (contentPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentPane", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "createWindowContent"));
        }
        if (focusedComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedComponent", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "createWindowContent"));
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(contentPane, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(focusedComponent);
        if (actions != null) {
            ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
            toolWindow.setTitleActions(actions);
        }
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "createToggleAction"));
        }
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                NlPropertiesWindowManager propertiesManager = NlPropertiesWindowManager.get(this.myProject);
                NlPaletteManager paletteManager = NlPaletteManager.get(this.myProject);
                return this.myManager == propertiesManager ? paletteManager : propertiesManager;
            }
        };
    }
}

