/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class XmlBuilder {
    private final StringBuilder myStringBuilder = new StringBuilder();
    private Construct myLastAppendedConstruct = Construct.NULL;
    private int myIndentationLevel;

    @NotNull
    public XmlBuilder startTag(@NotNull String name) {
        int length;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/api/XmlBuilder", "startTag"));
        }
        if (!this.myLastAppendedConstruct.equals((Object)Construct.END_TAG) && (length = this.myStringBuilder.length()) > 0) {
            this.myStringBuilder.replace(length - 1, length, ">\n");
        }
        if (this.myIndentationLevel != 0) {
            this.myStringBuilder.append('\n');
        }
        this.indent();
        this.myStringBuilder.append('<').append(name).append('\n');
        ++this.myIndentationLevel;
        this.myLastAppendedConstruct = Construct.START_TAG;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "startTag"));
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        XmlBuilder xmlBuilder = this.androidAttribute(name, Boolean.toString(value));
        if (xmlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        XmlBuilder xmlBuilder = this.androidAttribute(name, Integer.toString(value));
        if (xmlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        XmlBuilder xmlBuilder = this.attribute("android", name, value);
        if (xmlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "androidAttribute"));
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder attribute(@NotNull String namespacePrefix, @NotNull String name, @NotNull String value) {
        if (namespacePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacePrefix", "com/android/tools/idea/uibuilder/api/XmlBuilder", "attribute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/api/XmlBuilder", "attribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/api/XmlBuilder", "attribute"));
        }
        this.indent();
        if (!StringUtil.isEmpty((String)namespacePrefix)) {
            this.myStringBuilder.append(namespacePrefix).append(':');
        }
        this.myStringBuilder.append(name).append("=\"").append(value).append("\"\n");
        this.myLastAppendedConstruct = Construct.ATTRIBUTE;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "attribute"));
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder endTag(@NotNull String name) {
        boolean useEmptyElementTag;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/api/XmlBuilder", "endTag"));
        }
        boolean bl = useEmptyElementTag = !name.endsWith("Layout") && !name.equals("PreferenceCategory");
        if (this.myLastAppendedConstruct.equals((Object)Construct.START_TAG) || this.myLastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.myStringBuilder.length();
            if (useEmptyElementTag) {
                this.myStringBuilder.deleteCharAt(length - 1);
            } else {
                this.myStringBuilder.replace(length - 1, length, ">\n\n");
            }
        }
        --this.myIndentationLevel;
        if ((this.myLastAppendedConstruct.equals((Object)Construct.START_TAG) || this.myLastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) && useEmptyElementTag) {
            this.myStringBuilder.append(" />\n");
        } else {
            this.indent();
            this.myStringBuilder.append("</").append(name).append(">\n");
        }
        this.myLastAppendedConstruct = Construct.END_TAG;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "endTag"));
        }
        return xmlBuilder;
    }

    private void indent() {
        for (int i = 0; i < this.myIndentationLevel; ++i) {
            this.myStringBuilder.append("    ");
        }
    }

    @NotNull
    public String toString() {
        String string = this.myStringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/XmlBuilder", "toString"));
        }
        return string;
    }

    private static enum Construct {
        NULL,
        START_TAG,
        ATTRIBUTE,
        END_TAG;

    }
}

