/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNameValidator;
import com.android.tools.idea.ui.SearchField;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.tools.idea.ui.resourcechooser.EditResourcePanel;
import com.android.tools.idea.ui.resourcechooser.FilteringTableModel;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserGroup;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserIcon;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.android.tools.idea.ui.resourcechooser.ResourceDrawablePanel;
import com.android.tools.idea.ui.resourcechooser.ResourceEditorTab;
import com.android.tools.idea.ui.resourcechooser.ResourceTableContentProvider;
import com.android.tools.idea.ui.resourcechooser.ResourceTablePanel;
import com.android.tools.idea.ui.resourcechooser.ResourceTreeContentProvider;
import com.android.tools.idea.ui.resourcechooser.SimpleTabUI;
import com.android.tools.idea.ui.resourcechooser.StateListPicker;
import com.android.tools.idea.ui.resourcechooser.TreeGrid;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.swing.ui.SwatchComponent;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseResourceDialog
extends DialogWrapper {
    private static final String TYPE_KEY = "ResourceType";
    private static final String FOLDER_TYPE_KEY = "ResourceFolderType";
    private static final String GRID_MODE_KEY = "ResourceChooserGridMode";
    public static final String APP_NAMESPACE_LABEL = "Project";
    private static final int GRID_ICON_SIZE = JBUI.scale((int)50);
    private static final int GRID_CHECK_SIZE = JBUI.scale((int)8);
    private static final int GRID_CELL_SIZE = JBUI.scale((int)120);
    private static final int LIST_ICON_SIZE = JBUI.scale((int)28);
    private static final int LIST_CHECK_SIZE = JBUI.scale((int)5);
    private static final int LIST_CELL_HEIGHT = JBUI.scale((int)40);
    static final int TABLE_CELL_HEIGHT = JBUI.scale((int)30);
    private static final JBColor LIST_DIVIDER_COLOR = new JBColor((Color)Gray._245, (Color)Gray._80);
    private static final JBInsets LIST_PADDING = JBUI.insets((int)7, (int)6);
    public static final JBDimension PANEL_PREFERRED_SIZE = JBUI.size((int)850, (int)620);
    static final SimpleTextAttributes SEARCH_MATCH_ATTRIBUTES = new SimpleTextAttributes(null, null, null, 64);
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final Configuration myConfiguration;
    @Nullable
    private final XmlTag myTag;
    private final JComponent myContentPanel;
    private final JTabbedPane myTabbedPane;
    private final JPanel myAltPane;
    private final JComponent myViewOption;
    private final String myResourceNameSuggestion;
    private final EnumSet<ResourceType> myTypes;
    private final String myInitialValue;
    private final boolean myInitialValueIsFramework;
    private final ResourceNameVisibility myResourceNameVisibility;
    private boolean myGridMode;
    @Nullable
    private ResourceEditorTab myColorPickerPanel;
    @Nullable
    private ColorPicker myColorPicker;
    @Nullable
    private ResourceEditorTab myStateListPickerPanel;
    @Nullable
    private StateListPicker myStateListPicker;
    @Nullable
    private ResourcePickerListener myResourcePickerListener;
    @NotNull
    private ImmutableMap<String, Color> myContrastColorsWithDescription;
    private boolean myIsBackgroundColor;
    private final SearchField mySearchField;
    private final boolean myHideLeftSideActions;
    private boolean myAllowCreateResource;
    private String myResultResourceName;
    private boolean myUseGlobalUndo;
    private RenderTask myRenderTask;
    private final MultiMap<ResourceType, String> myThemAttributes;
    private Map<ResourceType, ResourcePanel> myTypeToPanels;

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "builder"));
        }
        return builder;
    }

    private ChooseResourceDialog(@NotNull AndroidFacet facet, @NotNull Configuration configuration, @Nullable XmlTag tag, @NotNull EnumSet<ResourceType> types, @Nullable String value, boolean isFrameworkValue, @NotNull ResourceNameVisibility resourceNameVisibility, @Nullable String resourceNameSuggestion, boolean hideLeftSideActions) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "<init>"));
        }
        if (resourceNameVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNameVisibility", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "<init>"));
        }
        super(facet.getModule().getProject());
        this.myGridMode = PropertiesComponent.getInstance().getBoolean(GRID_MODE_KEY, false);
        this.myContrastColorsWithDescription = ImmutableMap.of();
        this.myAllowCreateResource = true;
        this.myTypeToPanels = Maps.newEnumMap(ResourceType.class);
        this.myModule = facet.getModule();
        this.myFacet = facet;
        this.myConfiguration = configuration;
        this.myTag = tag;
        this.myInitialValue = value;
        this.myInitialValueIsFramework = isFrameworkValue;
        this.myResourceNameVisibility = resourceNameVisibility;
        types = ((EnumSet)types).clone();
        if (((AbstractCollection)types).contains(ResourceType.MIPMAP)) {
            ((AbstractCollection)types).add(ResourceType.DRAWABLE);
            ((AbstractCollection)types).remove(ResourceType.MIPMAP);
        }
        if (((AbstractCollection)types).contains(ResourceType.DRAWABLE) || ((AbstractCollection)types).contains(ResourceType.MIPMAP) && !((AbstractCollection)types).contains(ResourceType.COLOR)) {
            ((AbstractCollection)types).add(ResourceType.COLOR);
        }
        this.myTypes = types;
        this.myHideLeftSideActions = hideLeftSideActions;
        this.myResourceNameSuggestion = resourceNameSuggestion;
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        this.myThemAttributes = ChooseResourceDialog.initializeThemeAttributes(configuration, resolver);
        ResourceValue resValue = null;
        if (value != null) {
            resValue = resolver.findResValue(value, isFrameworkValue);
        }
        this.myViewOption = this.createViewOptions();
        this.myTabbedPane = this.initializeTabbedPane();
        if (this.myTabbedPane == null) {
            this.myAltPane = new JPanel(new BorderLayout());
            this.myAltPane.setPreferredSize((Dimension)PANEL_PREFERRED_SIZE);
            this.myAltPane.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)JBUI.scale((int)12), (int)0, (int)0));
        } else {
            this.myAltPane = null;
        }
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add(this.myTabbedPane != null ? this.myTabbedPane : this.myAltPane);
        this.mySearchField = this.createSearchField();
        this.myContentPanel.add((Component)this.createToolbar(), "North");
        this.setTitle("Resources");
        this.setupViewOptions();
        this.init();
        this.selectResourceValue(resValue);
        this.doValidate();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getModule"));
        }
        return module;
    }

    @NotNull
    public AndroidFacet geFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "geFacet"));
        }
        return androidFacet;
    }

    private void selectResourceValue(@Nullable ResourceValue resValue) {
        if (resValue != null) {
            ResourcePanel panel = this.getSelectedPanel();
            if (panel.select(resValue)) {
                return;
            }
            ResourceType type = resValue instanceof ItemResourceValue ? ResolutionUtils.getAttrType((ItemResourceValue)resValue, this.myConfiguration) : resValue.getResourceType();
            if (type != null && (panel = this.getPanel(this.myTabbedPane, type)) != null) {
                if (this.myTabbedPane != null) {
                    this.myTabbedPane.setSelectedComponent(panel.myComponent.getParent());
                }
                if (!panel.select(resValue) && type == ResourceType.COLOR) {
                    panel.showPreview(null, true);
                }
            }
        }
    }

    private static MultiMap<ResourceType, String> initializeThemeAttributes(@NotNull Configuration configuration, @NotNull ResourceResolver resolver) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "initializeThemeAttributes"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "initializeThemeAttributes"));
        }
        MultiMap attrs = new MultiMap();
        String themeName = configuration.getTheme();
        assert (themeName != null);
        for (ItemResourceValue item : ResolutionUtils.getThemeAttributes(resolver, themeName)) {
            ResourceType type = ResolutionUtils.getAttrType(item, configuration);
            if (type == null) continue;
            attrs.putValue((Object)type, (Object)ResolutionUtils.getQualifiedItemName(item));
        }
        return attrs;
    }

    private boolean allowColors() {
        return this.myTypes.contains(ResourceType.COLOR);
    }

    private boolean allowDrawables() {
        return this.myTypes.contains(ResourceType.DRAWABLE) || this.myTypes.contains(ResourceType.MIPMAP);
    }

    @NotNull
    private JComponent createToolbar() {
        Box toolbar = Box.createHorizontalBox();
        toolbar.add((Component)((Object)this.mySearchField));
        toolbar.add(Box.createHorizontalStrut(JBUI.scale((int)20)));
        toolbar.add(this.myViewOption);
        toolbar.add(Box.createHorizontalGlue());
        JBLabel addNew = new JBLabel("Add new resource");
        addNew.setIcon(PlatformIcons.COMBOBOX_ARROW_ICON);
        addNew.setHorizontalTextPosition(2);
        addNew.setIconTextGap(0);
        if (ScreenReader.isActive()) {
            addNew.setFocusable(true);
        }
        toolbar.add((Component)addNew);
        MyAddNewResourceLabelListener listener = new MyAddNewResourceLabelListener();
        addNew.addMouseListener((MouseListener)listener);
        addNew.addKeyListener((KeyListener)listener);
        toolbar.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0), JBUI.Borders.empty((int)8)));
        Box box = toolbar;
        if (box == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createToolbar"));
        }
        return box;
    }

    private JComponent createViewOptions() {
        ToggleAction listView = this.createListViewAction();
        ToggleAction gridView = this.createGridViewAction();
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{listView, gridView});
        JComponent component = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        component.setBorder(null);
        component.setMaximumSize(new Dimension(JBUI.scale((int)100), component.getMaximumSize().height));
        return component;
    }

    @Nullable
    private JTabbedPane initializeTabbedPane() {
        if (this.myTypes.size() <= 1) {
            return null;
        }
        JTabbedPane pane = new JTabbedPane(2);
        pane.setName("ResourceTypeTabs");
        pane.setUI(new SimpleTabUI());
        ArrayList sorted = Lists.newArrayList(this.myTypes);
        Collections.sort(sorted, (t1, t2) -> ChooseResourceDialog.typeRank(t1) - ChooseResourceDialog.typeRank(t2));
        for (ResourceType type : sorted) {
            JPanel container = new JPanel(new BorderLayout());
            container.setPreferredSize((Dimension)PANEL_PREFERRED_SIZE);
            container.putClientProperty(ResourceType.class, type);
            pane.addTab(type.getDisplayName(), container);
        }
        pane.addChangeListener(e -> this.handleTabChange());
        return pane;
    }

    private static int typeRank(ResourceType type) {
        switch (type) {
            case DRAWABLE: {
                return 0;
            }
            case COLOR: {
                return 1;
            }
        }
        return type.ordinal() + 2;
    }

    private void handleTabChange() {
        ResourcePanel panel = this.getSelectedPanel();
        panel.configureList(this.myGridMode);
        this.updateFilter();
        this.setupViewOptions();
    }

    @NotNull
    private ResourcePanel getSelectedPanel() {
        if (this.myTabbedPane != null) {
            JPanel selectedComponent = (JPanel)this.myTabbedPane.getSelectedComponent();
            ResourceType type = (ResourceType)selectedComponent.getClientProperty(ResourceType.class);
            ResourcePanel resourcePanel = this.getPanel(this.myTabbedPane, type);
            if (resourcePanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getSelectedPanel"));
            }
            return resourcePanel;
        }
        ResourcePanel resourcePanel = this.getPanel(null, (ResourceType)this.myTypes.iterator().next());
        if (resourcePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getSelectedPanel"));
        }
        return resourcePanel;
    }

    private ResourcePanel getPanel(@Nullable JTabbedPane tabbedPane, @NotNull ResourceType type) {
        ResourcePanel panel;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getPanel"));
        }
        if (type == ResourceType.MIPMAP) {
            type = ResourceType.DRAWABLE;
        }
        if ((panel = this.myTypeToPanels.get(type)) == null) {
            panel = new ResourcePanel(type, type != ResourceType.COLOR || !this.allowDrawables(), this.myThemAttributes.get((Object)type));
            panel.expandAll();
            JPanel container = this.myAltPane;
            if (container == null && tabbedPane != null) {
                int n = tabbedPane.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    JPanel tab = (JPanel)tabbedPane.getComponentAt(i);
                    if (tab.getClientProperty(ResourceType.class) != type) continue;
                    container = tab;
                    break;
                }
            }
            if (container != null) {
                container.add((Component)panel.myComponent, "Center");
                this.myTypeToPanels.put(type, panel);
            }
        }
        return panel;
    }

    @NotNull
    private ToggleAction createGridViewAction() {
        ToggleAction toggleAction = new ToggleAction(null, "grid", AndroidIcons.Views.GridView){

            public boolean isSelected(AnActionEvent e) {
                return ChooseResourceDialog.this.myGridMode;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ChooseResourceDialog.this.setGridMode(state);
            }
        };
        if (toggleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createGridViewAction"));
        }
        return toggleAction;
    }

    @NotNull
    private ToggleAction createListViewAction() {
        ToggleAction toggleAction = new ToggleAction(null, "list", AndroidIcons.Views.ListView){

            public boolean isSelected(AnActionEvent e) {
                return !ChooseResourceDialog.this.myGridMode;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ChooseResourceDialog.this.setGridMode(!state);
            }
        };
        if (toggleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createListViewAction"));
        }
        return toggleAction;
    }

    @NotNull
    private AnAction createNewResourceValueAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceType type = (ResourceType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceValue(type);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createNewResourceValueAction"));
        }
        return anAction;
    }

    @NotNull
    private AnAction createNewResourceFileAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceFolderType type = (ResourceFolderType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.FOLDER_TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceFile(type);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createNewResourceFileAction"));
        }
        return anAction;
    }

    @NotNull
    private AbstractAction createNewResourceAction() {
        AbstractAction abstractAction = new AbstractAction("New Resource", AllIcons.General.ComboArrowDown){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent component = (JComponent)e.getSource();
                ActionPopupMenu popupMenu = ChooseResourceDialog.this.createNewResourcePopupMenu();
                popupMenu.getComponent().show(component, 0, component.getHeight());
            }
        };
        if (abstractAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createNewResourceAction"));
        }
        return abstractAction;
    }

    @NotNull
    private AnAction createExtractStyleAction() {
        AnAction anAction = new AnAction("Extract Style..."){

            public void actionPerformed(AnActionEvent e) {
                ChooseResourceDialog.this.extractStyle();
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createExtractStyleAction"));
        }
        return anAction;
    }

    @NotNull
    private AnAction createNewResourceReferenceAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourcePanel panel = ChooseResourceDialog.this.getSelectedPanel();
                panel.showNewResource(panel.myReferencePanel);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createNewResourceReferenceAction"));
        }
        return anAction;
    }

    @NotNull
    private SearchField createSearchField() {
        SearchField searchField = new SearchField(false){

            protected void showPopup() {
            }
        };
        searchField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    e.consume();
                    ChooseResourceDialog.this.getSelectedPanel().selectFirst();
                }
            }
        });
        searchField.setMaximumSize(new Dimension(JBUI.scale((int)300), searchField.getMaximumSize().height));
        searchField.addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ChooseResourceDialog.this.updateFilter();
            }
        });
        SearchField searchField2 = searchField;
        if (searchField2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createSearchField"));
        }
        return searchField2;
    }

    private void updateFilter() {
        ResourcePanel panel = this.getSelectedPanel();
        String text = this.mySearchField.getText();
        if (text.isEmpty()) {
            if (!panel.isFiltered()) {
                return;
            }
            panel.setFilter(null);
            return;
        }
        if (panel.getType() == ResourceType.COLOR) {
            Color color;
            Condition colorCondition = null;
            if (text.startsWith("#") && (color = ResourceHelper.parseColor(text)) != null) {
                colorCondition = item -> {
                    assert (item.getType() == ResourceType.COLOR);
                    return ResourceHelper.resolveMultipleColors((RenderResources)this.getResourceResolver(), item.getResourceValue(), this.myModule.getProject()).contains(color);
                };
            }
            if (colorCondition != null) {
                panel.setFilter(colorCondition);
                return;
            }
        }
        Condition condition = item -> {
            String string;
            if (item.getType() == ResourceType.STRING && StringUtil.containsIgnoreCase((String)(string = ResourceHelper.resolveStringValue((RenderResources)this.getResourceResolver(), item.getResourceUrl())), (String)text)) {
                return true;
            }
            return StringUtil.containsIgnoreCase((String)item.getName(), (String)text);
        };
        panel.setFilter((Condition<ResourceChooserItem>)condition);
    }

    private void initializeColorPicker(@Nullable String value, @NotNull ResourceNameVisibility resourceNameVisibility, ResourceResolver resolver, ResourceValue resValue) {
        if (resourceNameVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNameVisibility", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "initializeColorPicker"));
        }
        Color color = null;
        if (resValue != null) {
            color = ResourceHelper.resolveColor((RenderResources)resolver, resValue, this.myModule.getProject());
        }
        if (color == null) {
            color = ResourceHelper.parseColor(value);
        }
        this.myColorPicker = new ColorPicker(this.myDisposable, color, true, new ColorPickerListener(){

            public void colorChanged(Color color) {
                ChooseResourceDialog.this.notifyResourcePickerListeners(ResourceHelper.colorToString(color));
            }

            public void closed(@Nullable Color color) {
            }
        });
        this.myColorPicker.pickARGB();
        this.myColorPickerPanel = new ResourceEditorTab(this.myModule, "Color", this.myColorPicker, resourceNameVisibility, false, ResourceFolderType.VALUES, true, ResourceType.COLOR){

            @Override
            @NotNull
            public String doSave() {
                String value = ResourceHelper.colorToString(ChooseResourceDialog.this.myColorPicker.getColor());
                if (this.getResourceNameVisibility() == ResourceNameVisibility.FORCE || this.getResourceNameVisibility() == ResourceNameVisibility.SHOW && !ChooseResourceDialog.this.getSelectedPanel().myEditorPanel.getResourceName().isEmpty()) {
                    value = ChooseResourceDialog.this.saveValuesResource(ChooseResourceDialog.this.getSelectedPanel().myEditorPanel.getResourceName(), value, this.getLocationSettings());
                }
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$12", "doSave"));
                }
                return string;
            }
        };
    }

    private void ensurePickersInitialized() {
        boolean allowDrawables = this.allowDrawables();
        boolean allowColors = this.allowColors();
        if (allowColors || allowDrawables) {
            ResourceFolderType stateListFolderType;
            ResourceType stateListType;
            if (this.myStateListPicker != null || this.myColorPicker != null) {
                return;
            }
            Configuration configuration = this.getConfiguration();
            ResourceResolver resolver = configuration.getResourceResolver();
            assert (resolver != null);
            ResourceValue resValue = null;
            if (this.myInitialValue != null) {
                resValue = resolver.findResValue(this.myInitialValue, this.myInitialValueIsFramework);
            }
            if (allowDrawables) {
                stateListType = ResourceType.DRAWABLE;
                stateListFolderType = ResourceFolderType.DRAWABLE;
            } else {
                stateListType = ResourceType.COLOR;
                stateListFolderType = ResourceFolderType.COLOR;
            }
            this.initializeStateListPicker(configuration, resolver, resValue, stateListType, stateListFolderType);
            this.initializeColorPicker(this.myInitialValue, this.myResourceNameVisibility, resolver, resValue);
        }
    }

    private void initializeStateListPicker(@NotNull Configuration configuration, ResourceResolver resolver, ResourceValue resValue, ResourceType stateListType, ResourceFolderType stateListFolderType) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "initializeStateListPicker"));
        }
        ResourceHelper.StateList stateList = null;
        if (resValue != null && (stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resValue, this.myModule.getProject())) != null && stateList.getType() != stateListType) {
            Logger.getInstance(ChooseResourceDialog.class).warn("StateList type mismatch " + stateList.getType() + " " + stateListType);
            stateList = null;
        }
        this.myStateListPicker = new StateListPicker(stateList, this.myModule, configuration);
        this.myStateListPickerPanel = new ResourceEditorTab(this.myModule, "Statelist", this.myStateListPicker, ResourceNameVisibility.FORCE, true, stateListFolderType, false, stateListType){

            @Override
            @Nullable
            public ValidationInfo doValidate() {
                ValidationInfo error = super.doValidate();
                if (error == null) {
                    int minDirectoriesApi = ThemeEditorUtils.getMinFolderApi(this.getLocationSettings().getDirNames(), ChooseResourceDialog.this.myModule);
                    error = ChooseResourceDialog.this.myStateListPicker.doValidate(minDirectoriesApi);
                }
                return error;
            }

            @Override
            @NotNull
            public String doSave() {
                String stateListName = ChooseResourceDialog.this.getSelectedPanel().myEditorPanel.getResourceName();
                Module module = this.getSelectedModule();
                VirtualFile resDir = this.getResourceDirectory();
                List<String> dirNames = this.getLocationSettings().getDirNames();
                ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)dirNames.get(0));
                ResourceType resourceType = ResourceType.getEnum((String)resourceFolderType.getName());
                Project project = module.getProject();
                List<VirtualFile> files = null;
                if (resDir == null) {
                    AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
                } else if (resourceType != null) {
                    files = AndroidResourceUtil.findOrCreateStateListFiles(project, resDir, resourceFolderType, resourceType, stateListName, dirNames);
                }
                if (files != null) {
                    assert (ChooseResourceDialog.this.myStateListPicker != null);
                    ResourceHelper.StateList stateList1 = ChooseResourceDialog.this.myStateListPicker.getStateList();
                    assert (stateList1 != null);
                    AndroidResourceUtil.updateStateList(project, stateList1, files);
                }
                if (resourceFolderType == ResourceFolderType.COLOR) {
                    String string = "@color/" + stateListName;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$13", "doSave"));
                    }
                    return string;
                }
                assert (resourceFolderType == ResourceFolderType.DRAWABLE);
                String string = "@drawable/" + stateListName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$13", "doSave"));
                }
                return string;
            }
        };
    }

    @NotNull
    Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getConfiguration"));
        }
        return configuration;
    }

    private void setupViewOptions() {
        this.myViewOption.setVisible(this.getSelectedPanel().supportsGridMode());
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getStyle"));
        }
        return dialogStyle;
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackground, boolean displayWarning) {
        if (contrastColorsWithDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contrastColorsWithDescription", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "setContrastParameters"));
        }
        this.ensurePickersInitialized();
        if (this.myColorPicker != null) {
            this.myColorPicker.setContrastParameters(contrastColorsWithDescription, isBackground, displayWarning);
        }
        if (this.myStateListPicker != null) {
            this.myStateListPicker.setContrastParameters(contrastColorsWithDescription, isBackground);
        }
        this.myContrastColorsWithDescription = contrastColorsWithDescription;
        this.myIsBackgroundColor = isBackground;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getSelectedPanel().doValidate();
    }

    public void setResourcePickerListener(@Nullable ResourcePickerListener resourcePickerListener) {
        this.myResourcePickerListener = resourcePickerListener;
    }

    private void notifyResourcePickerListeners(@Nullable String resource) {
        if (this.myResourcePickerListener != null) {
            this.myResourcePickerListener.resourceChanged(resource);
        }
    }

    public void generateColorSuggestions(@NotNull Color primaryColor, @NotNull String attributeName) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "generateColorSuggestions"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "generateColorSuggestions"));
        }
        List<Color> suggestedColors = null;
        switch (attributeName) {
            case "colorPrimary": {
                suggestedColors = MaterialColorUtils.suggestPrimaryColors();
                break;
            }
            case "colorPrimaryDark": {
                suggestedColors = MaterialColorUtils.suggestPrimaryDarkColors(primaryColor);
                break;
            }
            case "colorAccent": {
                suggestedColors = MaterialColorUtils.suggestAccentColors(primaryColor);
            }
        }
        if (suggestedColors != null) {
            this.ensurePickersInitialized();
            assert (this.myColorPicker != null);
            this.myColorPicker.setRecommendedColors(suggestedColors);
        }
    }

    private ActionPopupMenu createNewResourcePopupMenu() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ResourcePanel panel = this.getSelectedPanel();
        ResourceType resourceType = panel.getType();
        ResourceFolderType folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(resourceType);
        if (folderType != null) {
            AnAction newFileAction = this.createNewResourceFileAction();
            newFileAction.getTemplatePresentation().setText("New " + folderType.getName() + " File...");
            newFileAction.getTemplatePresentation().putClientProperty(FOLDER_TYPE_KEY, (Object)folderType);
            actionGroup.add(newFileAction);
        }
        if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceType)) {
            String title = "New " + resourceType + " Value...";
            if (resourceType == ResourceType.LAYOUT) {
                title = "New Layout Alias";
            }
            AnAction newValueAction = this.createNewResourceValueAction();
            newValueAction.getTemplatePresentation().setText(title);
            newValueAction.getTemplatePresentation().putClientProperty(TYPE_KEY, (Object)resourceType);
            actionGroup.add(newValueAction);
        }
        if (this.myTag != null && ResourceType.STYLE.equals((Object)resourceType)) {
            boolean enabled = AndroidBaseLayoutRefactoringAction.getLayoutViewElement(this.myTag) != null && AndroidExtractStyleAction.doIsEnabled(this.myTag);
            AnAction extractStyleAction = this.createExtractStyleAction();
            extractStyleAction.getTemplatePresentation().setEnabled(enabled);
            actionGroup.add(extractStyleAction);
        }
        if (GraphicalResourceRendererEditor.COLORS_AND_DRAWABLES.contains(resourceType)) {
            AnAction newReferenceAction = this.createNewResourceReferenceAction();
            newReferenceAction.getTemplatePresentation().setText("New " + resourceType + " Reference...");
            actionGroup.add(newReferenceAction);
        }
        return actionManager.createActionPopupMenu("unknown", (ActionGroup)actionGroup);
    }

    private void createNewResourceValue(ResourceType resourceType) {
        this.ensurePickersInitialized();
        if (resourceType == ResourceType.COLOR && this.myColorPickerPanel != null) {
            this.getSelectedPanel().showNewResource(this.myColorPickerPanel);
            return;
        }
        CreateXmlResourceDialog dialog = new CreateXmlResourceDialog(this.myModule, resourceType, null, null, true, null, null);
        dialog.setTitle("New " + StringUtil.capitalize((String)resourceType.getDisplayName()) + " Value Resource");
        if (!dialog.showAndGet()) {
            return;
        }
        Project project = this.myModule.getProject();
        VirtualFile resDir = dialog.getResourceDirectory();
        if (resDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", this.myModule));
            return;
        }
        String fileName = dialog.getFileName();
        List<String> dirNames = dialog.getDirNames();
        String resValue = dialog.getValue();
        String resName = dialog.getResourceName();
        if (!AndroidResourceUtil.createValueResource(project, resDir, resName, resourceType, fileName, dirNames, resValue)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myModule.getProject()).commitAllDocuments();
        this.myResultResourceName = "@" + resourceType.getName() + "/" + resName;
        this.close(0);
    }

    private void createNewResourceFile(ResourceFolderType folderType) {
        this.ensurePickersInitialized();
        if (this.myStateListPicker != null && this.myStateListPicker.getStateList() != null && folderType == this.myStateListPicker.getStateList().getFolderType()) {
            assert (this.myStateListPickerPanel != null);
            this.getSelectedPanel().showNewResource(this.myStateListPickerPanel);
            return;
        }
        XmlFile newFile = CreateResourceFileAction.createFileResource(this.myFacet, folderType, null, null, null, true, null, null, null);
        if (newFile != null) {
            String name = newFile.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            this.myResultResourceName = "@" + folderType.getName() + "/" + name;
            this.close(0);
        }
    }

    private void extractStyle() {
        assert (this.myTag != null);
        String resName = AndroidExtractStyleAction.doExtractStyle(this.myModule, this.myTag, false, null);
        if (resName == null) {
            return;
        }
        this.myResultResourceName = "@style/" + resName;
        this.close(0);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchField;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @NotNull
    protected Action[] getCreateActions() {
        Action[] actionArray;
        if (this.myAllowCreateResource && !this.myHideLeftSideActions) {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = this.createNewResourceAction();
        } else {
            actionArray = new Action[]{};
        }
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getCreateActions"));
        }
        return actionArray;
    }

    public ChooseResourceDialog setAllowCreateResource(boolean allowCreateResource) {
        this.myAllowCreateResource = allowCreateResource;
        return this;
    }

    public boolean getAllowCreateResource() {
        return this.myAllowCreateResource;
    }

    public void openLocationSettings() {
        this.ensurePickersInitialized();
        if (this.myColorPickerPanel != null) {
            this.myColorPickerPanel.setLocationSettingsOpen(true);
        }
        if (this.myStateListPickerPanel != null) {
            this.myStateListPickerPanel.setLocationSettingsOpen(true);
        }
        this.getSelectedPanel().myReferencePanel.setLocationSettingsOpen(true);
    }

    public String getResourceName() {
        return this.myResultResourceName;
    }

    protected void doOKAction() {
        ResourceChooserItem item;
        ResourcePanel resourcePanel = this.getSelectedPanel();
        ResourceEditorTab editor = resourcePanel.getCurrentResourceEditor();
        this.notifyResourcePickerListeners(null);
        this.myResultResourceName = editor != null ? editor.doSave() : ((item = resourcePanel.getSelectedItem()) != null ? item.getResourceUrl() : null);
        super.doOKAction();
    }

    private void setGridMode(boolean gridMode) {
        if (gridMode != this.myGridMode) {
            this.myGridMode = gridMode;
            this.getSelectedPanel().configureList(this.myGridMode);
            PropertiesComponent.getInstance().setValue(GRID_MODE_KEY, gridMode, false);
        }
    }

    public void setUseGlobalUndo(boolean useGlobalUndo) {
        this.myUseGlobalUndo = useGlobalUndo;
    }

    @Nullable
    Icon getIcon(@NotNull ResourceChooserItem item, int size, int checkerboardSize) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getIcon"));
        }
        Icon icon = item.getIcon();
        if (icon != null && size == icon.getIconWidth()) {
            return icon;
        }
        switch (item.getType()) {
            case DRAWABLE: 
            case COLOR: 
            case MIPMAP: {
                icon = this.createIcon(size, checkerboardSize, true, item.getPath(), item.getResourceValue(), item.getType());
                if (icon != null) break;
                icon = new ImageIcon(new BufferedImage(size, size, 2));
                break;
            }
            default: {
                icon = null;
            }
        }
        item.setIcon(icon);
        return icon;
    }

    @Nullable
    Icon createIcon(int size, int checkerboardSize, boolean interpolate, @Nullable String path, @NotNull ResourceValue resourceValue, @NotNull ResourceType type) {
        Color color;
        if (resourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceValue", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createIcon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "createIcon"));
        }
        if (path != null && IconDetector.isDrawableFile((String)path) && !path.endsWith(".xml") && !path.endsWith(".webp")) {
            return new ResourceChooserIcon(size, new ImageIcon(path).getImage(), checkerboardSize, interpolate);
        }
        if (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP) {
            Dimension dimension;
            int width = size;
            int height = size;
            if (path != null && path.endsWith(".webp") && (dimension = IconDetector.getSize((File)new File(path))) != null) {
                if (dimension.width < width && dimension.height < height) {
                    width = dimension.width;
                    height = dimension.height;
                } else {
                    double aspect = (double)width / (double)height;
                    if (aspect >= 1.0) {
                        height = (int)((double)height / aspect);
                    } else {
                        width = (int)((double)width * aspect);
                    }
                }
            }
            RenderTask renderTask = this.getRenderTask();
            renderTask.setOverrideRenderSize(width, height);
            renderTask.setMaxRenderSize(width, height);
            BufferedImage image = renderTask.renderDrawable(resourceValue);
            if (image != null) {
                return new ResourceChooserIcon(size, image, checkerboardSize, interpolate);
            }
        } else if (type == ResourceType.COLOR && (color = ResourceHelper.resolveColor((RenderResources)this.getResourceResolver(), resourceValue, this.myModule.getProject())) != null) {
            return new ColorIcon(size, color);
        }
        return null;
    }

    @NotNull
    private SwatchComponent.SwatchIcon getSwatchIcon(@Nullable String name) {
        SwatchComponent.SwatchIcon swatchIcon = StateListPicker.getSwatchIcon(name, this.getResourceResolver(), this.getRenderTask());
        if (swatchIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getSwatchIcon"));
        }
        return swatchIcon;
    }

    @NotNull
    private ResourceResolver getResourceResolver() {
        Configuration config = this.getConfiguration();
        ResourceResolver resolver = config.getResourceResolver();
        assert (resolver != null);
        ResourceResolver resourceResolver = resolver;
        if (resourceResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getResourceResolver"));
        }
        return resourceResolver;
    }

    @NotNull
    private RenderTask getRenderTask() {
        if (this.myRenderTask == null) {
            this.myRenderTask = DrawableRendererEditor.configureRenderTask(this.myModule, this.getConfiguration());
            this.myRenderTask.setMaxRenderSize(150, 150);
        }
        RenderTask renderTask = this.myRenderTask;
        if (renderTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getRenderTask"));
        }
        return renderTask;
    }

    @NotNull
    private String saveValuesResource(@NotNull String name, @NotNull String value, @NotNull CreateXmlResourcePanel locationSettings) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "saveValuesResource"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "saveValuesResource"));
        }
        if (locationSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationSettings", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "saveValuesResource"));
        }
        ResourceType type = locationSettings.getType();
        String fileName = locationSettings.getFileName();
        List<String> dirNames = locationSettings.getDirNames();
        Project project = this.myModule.getProject();
        VirtualFile resDir = locationSettings.getResourceDirectory();
        if (resDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", this.myModule.getName()));
        } else if (!AndroidResourceUtil.changeValueResource(project, resDir, name, type, value, fileName, dirNames, this.myUseGlobalUndo)) {
            AndroidResourceUtil.createValueResource(project, resDir, name, type, fileName, dirNames, value);
        }
        String string = "@" + type + "/" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "saveValuesResource"));
        }
        return string;
    }

    @NotNull
    private static EnumSet<ResourceType> getAllowedTypes(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getAllowedTypes"));
        }
        switch (type) {
            case COLOR: {
                EnumSet<ResourceType> enumSet = GraphicalResourceRendererEditor.COLORS_ONLY;
                if (enumSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getAllowedTypes"));
                }
                return enumSet;
            }
            case DRAWABLE: {
                EnumSet<ResourceType> enumSet = GraphicalResourceRendererEditor.DRAWABLES_ONLY;
                if (enumSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getAllowedTypes"));
                }
                return enumSet;
            }
        }
        EnumSet<ResourceType> enumSet = EnumSet.of(type);
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog", "getAllowedTypes"));
        }
        return enumSet;
    }

    private class MyAddNewResourceLabelListener
    extends MouseAdapter
    implements KeyListener {
        private MyAddNewResourceLabelListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handle(e);
        }

        public void handle(InputEvent e) {
            Action[] actions;
            DefaultActionGroup group = new DefaultActionGroup();
            final Component source = (Component)e.getSource();
            DataContext context = SimpleDataContext.getSimpleContext((String)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)source, null);
            for (final Action action : actions = ChooseResourceDialog.this.getCreateActions()) {
                AnAction anAction = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        action.actionPerformed(new ActionEvent(source, 0, ""));
                    }

                    public void update(AnActionEvent e) {
                        Presentation presentation = e.getPresentation();
                        String name = (String)action.getValue("Name");
                        if (name != null) {
                            presentation.setText(name);
                        }
                        super.update(e);
                    }
                };
                if (actions.length == 1) {
                    AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((InputEvent)e, (String)ChooseResourceDialog.class.getSimpleName(), (Presentation)new Presentation(), (DataContext)context);
                    anAction.actionPerformed(actionEvent);
                    return;
                }
                group.add(anAction);
            }
            JBPopupFactory factory = JBPopupFactory.getInstance();
            ListPopup popup = factory.createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, null, 10);
            popup.showUnderneathOf(source);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                this.handle(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class ResourcePanel {
        private static final String NONE = "None";
        private static final String TEXT = "Text";
        private static final String EDITOR = "Editor";
        private static final String DRAWABLE = "Bitmap";
        private static final String TABLE = "Table";
        @NotNull
        public final JBSplitter myComponent;
        @Nullable
        private TreeGrid<ResourceChooserItem> myList;
        @Nullable
        private JBTable myTable;
        @NotNull
        private final JPanel myPreviewPanel;
        private JLabel myNoPreviewComponent;
        private JTextPane myHtmlTextArea;
        private EditResourcePanel myEditorPanel;
        @Nullable
        private ResourceDrawablePanel myDrawablePanel;
        @Nullable
        private ResourceTablePanel myTablePanel;
        private ResourceComponent myReferenceComponent;
        private ResourceEditorTab myReferencePanel;
        @NotNull
        private final ResourceChooserGroup[] myGroups;
        @NotNull
        private final ResourceType myType;

        public ResourcePanel(ResourceType type, @NotNull boolean includeFileResources, Collection<String> attrs) {
            ResourceChooserGroup themeItems;
            ResourceChooserGroup frameworkItems;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "<init>"));
            }
            if (attrs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "<init>"));
            }
            this.myType = type;
            ArrayList groups = Lists.newArrayListWithCapacity((int)3);
            ResourceChooserGroup projectItems = new ResourceChooserGroup(ChooseResourceDialog.APP_NAMESPACE_LABEL, type, ChooseResourceDialog.this.myFacet, false, includeFileResources);
            if (!projectItems.isEmpty()) {
                groups.add(projectItems);
            }
            if (!(frameworkItems = new ResourceChooserGroup("android", type, ChooseResourceDialog.this.myFacet, true, includeFileResources)).isEmpty()) {
                groups.add(frameworkItems);
            }
            if (!(themeItems = new ResourceChooserGroup("Theme attributes", this.myType, ChooseResourceDialog.this.myFacet, attrs)).isEmpty()) {
                groups.add(themeItems);
            }
            this.myGroups = groups.toArray(new ResourceChooserGroup[0]);
            this.myComponent = new JBSplitter(false, 0.5f);
            this.myComponent.setSplitterProportionKey("android.resource_dialog_splitter");
            JComponent firstComponent = this.createListPanel();
            firstComponent.setPreferredSize((Dimension)JBUI.size((int)200, (int)600));
            this.myComponent.setFirstComponent(firstComponent);
            this.myPreviewPanel = new JPanel(new CardLayout());
            this.myPreviewPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)600));
            this.myComponent.setSecondComponent((JComponent)this.myPreviewPanel);
            this.showPreview(null);
        }

        @NotNull
        private JComponent createListPanel() {
            JBTable component;
            if (this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.COLOR || this.myType == ResourceType.MIPMAP || this.myType == ResourceType.STYLE || this.myType == ResourceType.ID) {
                ResourceTreeContentProvider treeContentProvider = new ResourceTreeContentProvider(this.myGroups);
                JBTable list = new TreeGrid(treeContentProvider);
                list.addListSelectionListener(e -> {
                    this.showPreview(this.getSelectedItem());
                    ChooseResourceDialog.this.notifyResourcePickerListeners(this.getValueForLivePreview());
                });
                this.myList = list;
                component = this.myList;
                this.configureList(ChooseResourceDialog.this.myGridMode);
            } else {
                final ResourceTableContentProvider model = new ResourceTableContentProvider(this.myGroups);
                FilteringTableModel<ResourceChooserItem> tableModel = new FilteringTableModel<ResourceChooserItem>(new AbstractTableModel(){

                    @Override
                    public int getRowCount() {
                        return model.getRowCount();
                    }

                    @Override
                    public int getColumnCount() {
                        return model.getColumnCount();
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex) {
                        return model.getValueAt(rowIndex, columnIndex);
                    }
                }, ResourceChooserItem.class);
                tableModel.refilter();
                component = this.myTable = new JBTable(tableModel);
                component.setName("nameTable");
                this.myTable.setFillsViewportHeight(true);
                this.myTable.setTableHeader(null);
                this.myTable.setBorder(null);
                TableColumnModel columnModel = this.myTable.getColumnModel();
                columnModel.getColumn(0).setHeaderValue("Key");
                columnModel.getColumn(1).setHeaderValue("Default Value");
                columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        boolean isHeader = false;
                        if (value instanceof ResourceChooserItem) {
                            ResourceChooserItem item = (ResourceChooserItem)value;
                            String string = item.getName();
                            String filter = ChooseResourceDialog.this.mySearchField.getText();
                            if (!filter.isEmpty()) {
                                int match = StringUtil.indexOfIgnoreCase((String)string, (String)filter, (int)0);
                                if (match != -1) {
                                    this.append(string.substring(0, match));
                                    this.append(string.substring(match, match + filter.length()), SEARCH_MATCH_ATTRIBUTES);
                                    this.append(string.substring(match + filter.length()));
                                } else {
                                    this.append(string);
                                }
                            } else {
                                this.append(string);
                            }
                        } else {
                            isHeader = true;
                            this.append(value.toString());
                        }
                        if (isHeader) {
                            this.setFont(UIUtil.getLabelFont().deriveFont(1));
                            if (!isSelected) {
                                this.setBackground(UIUtil.getLabelBackground());
                            }
                        } else {
                            this.setFont(UIUtil.getLabelFont());
                            if (!isSelected) {
                                this.setBackground(table.getBackground());
                            }
                        }
                    }
                });
                columnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        if (value instanceof ResourceChooserItem) {
                            value = ((ResourceChooserItem)value).getDefaultValue();
                            this.setBackground(table.getBackground());
                        } else {
                            this.setBackground(UIUtil.getLabelBackground());
                            value = "";
                        }
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
                this.myTable.setRowHeight(TABLE_CELL_HEIGHT);
                this.myTable.setStriped(false);
                this.myTable.setSelectionMode(0);
                this.myTable.getSelectionModel().addListSelectionListener(e -> {
                    this.showPreview(this.getSelectedItem());
                    ChooseResourceDialog.this.notifyResourcePickerListeners(this.getValueForLivePreview());
                });
                this.myTable.setBorder(BorderFactory.createEmptyBorder());
                TableSpeedSearch speedSearch = new TableSpeedSearch((JTable)this.myTable);
                speedSearch.setClearSearchOnNavigateNoMatch(true);
            }
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    ResourceChooserItem selected = ResourcePanel.this.getSelectedItem();
                    if (selected != null) {
                        ChooseResourceDialog.this.myResultResourceName = selected.getResourceUrl();
                        ChooseResourceDialog.this.close(0);
                        return true;
                    }
                    return false;
                }
            }.installOn(component);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(component, (int)22, (int)31);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            scrollPane.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)16));
            JScrollPane jScrollPane = scrollPane;
            if (jScrollPane == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "createListPanel"));
            }
            return jScrollPane;
        }

        boolean isFiltered() {
            if (this.myList != null) {
                return this.myList.isFiltered();
            }
            return this.myTable != null;
        }

        void setFilter(@Nullable Condition<ResourceChooserItem> condition) {
            if (this.myList != null) {
                this.myList.setFilter(condition);
                if (condition != null) {
                    this.myList.selectIfUnique();
                }
            } else if (this.myTable != null) {
                ((FilteringTableModel)this.myTable.getModel()).setFilter(condition);
                if (condition != null) {
                    TableModel model = this.myTable.getModel();
                    ResourceChooserItem single = null;
                    int rowCount = model.getRowCount();
                    for (int row = 0; row < rowCount; ++row) {
                        Object value = model.getValueAt(row, 0);
                        if (!(value instanceof ResourceChooserItem)) continue;
                        if (single == null) {
                            single = (ResourceChooserItem)value;
                            continue;
                        }
                        single = null;
                        break;
                    }
                    if (single != null) {
                        this.setSelectedItem(single);
                    }
                }
            }
        }

        void selectFirst() {
            List<ResourceChooserItem> first;
            if (this.myList != null) {
                this.myList.selectFirst();
            } else if (this.myTable != null && (first = this.myGroups[0].getItems()).size() > 0) {
                this.setSelectedItem(first.get(0));
                this.myTable.requestFocus();
            }
        }

        private void showDrawableItem(ResourceChooserItem item) {
            if (this.myDrawablePanel == null) {
                this.myDrawablePanel = new ResourceDrawablePanel(ChooseResourceDialog.this);
                this.myPreviewPanel.add((Component)((Object)this.myDrawablePanel), DRAWABLE);
            }
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            this.myDrawablePanel.select(item);
            layout.show(this.myPreviewPanel, DRAWABLE);
        }

        private void showTableItem(ResourceChooserItem item) {
            if (this.myTablePanel == null) {
                this.myTablePanel = new ResourceTablePanel(ChooseResourceDialog.this);
                this.myPreviewPanel.add((Component)this.myTablePanel.getPanel(), TABLE);
            } else {
                this.myComponent.skipNextLayouting();
            }
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            this.myTablePanel.select(item);
            layout.show(this.myPreviewPanel, TABLE);
        }

        private void showEditorPanel() {
            if (this.myEditorPanel == null) {
                this.myReferenceComponent = new ResourceComponent(ChooseResourceDialog.this.myModule.getProject(), true);
                this.myReferenceComponent.addSwatchListener(e -> {
                    String attributeValue = this.myReferenceComponent.getValueText();
                    ResourceUrl attributeValueUrl = ResourceUrl.parse((String)attributeValue);
                    boolean isFrameworkValue = attributeValueUrl != null && attributeValueUrl.framework;
                    String nameSuggestion = attributeValueUrl != null ? attributeValueUrl.name : null;
                    ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(this.myReferencePanel.getSelectedModule()).setTypes(ChooseResourceDialog.getAllowedTypes(this.myType)).setCurrentValue(attributeValue).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(ResourceNameVisibility.FORCE).setResourceNameSuggestion(nameSuggestion).setConfiguration(ChooseResourceDialog.this.getConfiguration()).build();
                    if (ChooseResourceDialog.this.myResourcePickerListener != null) {
                        dialog.setResourcePickerListener(ChooseResourceDialog.this.myResourcePickerListener);
                    }
                    if (!ChooseResourceDialog.this.myContrastColorsWithDescription.isEmpty()) {
                        dialog.setContrastParameters((ImmutableMap<String, Color>)ChooseResourceDialog.this.myContrastColorsWithDescription, ChooseResourceDialog.this.myIsBackgroundColor, true);
                    }
                    dialog.show();
                    if (dialog.isOK()) {
                        String resourceName = dialog.getResourceName();
                        this.myReferenceComponent.setValueText(resourceName);
                        this.myReferenceComponent.repaint();
                    } else {
                        ChooseResourceDialog.this.notifyResourcePickerListeners(this.myReferenceComponent.getValueText());
                    }
                });
                this.myReferenceComponent.addTextDocumentListener((DocumentListener)new DocumentAdapter(){

                    public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            ResourcePanel.this.updateReferenceSwatchIcon();
                            ChooseResourceDialog.this.notifyResourcePickerListeners(ResourcePanel.this.myReferenceComponent.getValueText());
                        }, ModalityState.any());
                    }
                });
                this.myReferenceComponent.setCompletionStrings(ResourceHelper.getCompletionFromTypes(ChooseResourceDialog.this.myFacet, ChooseResourceDialog.getAllowedTypes(this.myType)));
                Box referenceComponentPanel = new Box(1);
                referenceComponentPanel.setName("ReferenceEditor");
                referenceComponentPanel.add(this.myReferenceComponent);
                referenceComponentPanel.add(Box.createVerticalGlue());
                this.myReferencePanel = new ResourceEditorTab(ChooseResourceDialog.this.myModule, "Reference", referenceComponentPanel, ResourceNameVisibility.FORCE, false, ResourceFolderType.VALUES, true, this.myType){

                    @Override
                    @Nullable
                    public ValidationInfo doValidate() {
                        ValidationInfo error = super.doValidate();
                        if (error == null) {
                            int minDirectoriesApi = ThemeEditorUtils.getMinFolderApi(this.getLocationSettings().getDirNames(), ChooseResourceDialog.this.myModule);
                            IAndroidTarget target = ChooseResourceDialog.this.getConfiguration().getRealTarget();
                            assert (target != null);
                            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, ChooseResourceDialog.this.myModule);
                            assert (androidTargetData != null);
                            error = ResourcePanel.this.myReferenceComponent.doValidate(minDirectoriesApi, androidTargetData);
                        }
                        return error;
                    }

                    @Override
                    @NotNull
                    public String doSave() {
                        String string = ChooseResourceDialog.this.saveValuesResource(ResourcePanel.this.myEditorPanel.getResourceName(), ResourcePanel.this.myReferenceComponent.getValueText(), this.getLocationSettings());
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel$6", "doSave"));
                        }
                        return string;
                    }
                };
                this.myEditorPanel = new EditResourcePanel(ChooseResourceDialog.this.myResourceNameSuggestion);
                this.myEditorPanel.addVariantActionListener(e -> ChooseResourceDialog.this.getSelectedPanel().editResourceItem(this.myEditorPanel.getSelectedVariant()));
                this.myEditorPanel.addTab(this.myReferencePanel);
                ChooseResourceDialog.this.ensurePickersInitialized();
                if (this.myType == ResourceType.COLOR) {
                    assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                    this.myEditorPanel.addTab(ChooseResourceDialog.this.myColorPickerPanel);
                }
                if (ChooseResourceDialog.this.myStateListPicker != null && ChooseResourceDialog.this.myStateListPicker.getStateList() != null && this.myType == ChooseResourceDialog.this.myStateListPicker.getStateList().getType()) {
                    assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                    this.myEditorPanel.addTab(ChooseResourceDialog.this.myStateListPickerPanel);
                }
                this.myPreviewPanel.add((Component)((Object)this.myEditorPanel), EDITOR);
            }
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, EDITOR);
        }

        private void updateReferenceSwatchIcon() {
            SwatchComponent.SwatchIcon icon = ChooseResourceDialog.this.getSwatchIcon(this.myReferenceComponent.getValueText());
            if (icon instanceof SwatchComponent.ColorIcon) {
                SwatchComponent.ColorIcon colorIcon = (SwatchComponent.ColorIcon)icon;
                this.myReferenceComponent.setWarning(ColorUtils.getContrastWarningMessage((Map<String, Color>)ChooseResourceDialog.this.myContrastColorsWithDescription, colorIcon.getColor(), ChooseResourceDialog.this.myIsBackgroundColor));
            } else {
                this.myReferenceComponent.setWarning(null);
            }
            this.myReferenceComponent.setSwatchIcon(icon);
            this.myReferenceComponent.repaint();
        }

        private void showNoPreview() {
            if (this.myNoPreviewComponent == null) {
                this.myNoPreviewComponent = new JLabel("No Preview");
                this.myNoPreviewComponent.setHorizontalAlignment(0);
                this.myNoPreviewComponent.setVerticalAlignment(0);
                this.myPreviewPanel.add((Component)this.myNoPreviewComponent, NONE);
            }
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, NONE);
        }

        private void showHtml(String doc) {
            if (this.myHtmlTextArea == null) {
                this.myHtmlTextArea = new JTextPane();
                this.myHtmlTextArea.setEditable(false);
                this.myHtmlTextArea.setContentType("text/html");
                this.myHtmlTextArea.setMargin((Insets)JBUI.insets((int)8, (int)8, (int)8, (int)8));
                JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myHtmlTextArea, (boolean)true);
                this.myPreviewPanel.add((Component)scrollPane, TEXT);
            }
            this.myHtmlTextArea.setText(doc);
            HtmlBuilderHelper.fixFontStyles(this.myHtmlTextArea);
            this.myHtmlTextArea.getCaret().setDot(0);
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, TEXT);
        }

        @NotNull
        public ResourceType getType() {
            ResourceType resourceType = this.myType;
            if (resourceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "getType"));
            }
            return resourceType;
        }

        private boolean allowEditing(@Nullable ResourceChooserItem item) {
            if (item == null) {
                return false;
            }
            if (item.isFramework() || item.isAttr()) {
                return false;
            }
            ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(ChooseResourceDialog.this.myModule, true);
            assert (repository != null);
            if (!repository.hasResourceItem(item.getType(), item.getName())) {
                return false;
            }
            ResourceType type = item.getType();
            if (type == ResourceType.COLOR) {
                return true;
            }
            if (type == ResourceType.DRAWABLE) {
                if (item.isReference()) {
                    return true;
                }
                Project project = ChooseResourceDialog.this.myModule.getProject();
                ResourceHelper.StateList stateList = ResourceHelper.resolveStateList((RenderResources)ChooseResourceDialog.this.getResourceResolver(), item.getResourceValue(), project);
                return stateList != null;
            }
            return false;
        }

        public void showPreview(@Nullable ResourceChooserItem item) {
            this.showPreview(item, this.allowEditing(item));
        }

        public void showPreview(@Nullable ResourceChooserItem element, boolean allowEditor) {
            if (element != null && element.isAttr()) {
                ResourceUrl url = ResourceUrl.parse((String)element.getResourceUrl());
                assert (url != null);
                String doc = AndroidJavaDocRenderer.render(ChooseResourceDialog.this.myModule, ChooseResourceDialog.this.getConfiguration(), url);
                this.showHtml(doc);
                return;
            }
            if (allowEditor) {
                if ((this.myType == ResourceType.COLOR || this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.MIPMAP) && element != null) {
                    ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(ChooseResourceDialog.this.myModule, true);
                    assert (repository != null);
                    boolean inProject = repository.hasResourceItem(element.getType(), element.getName());
                    if (inProject) {
                        this.showEditorPanel();
                        this.myEditorPanel.setResourceName(element.getName());
                        ResourceItem defaultValue = this.setupVariants();
                        if (defaultValue != null) {
                            this.editResourceItem(defaultValue);
                            return;
                        }
                    }
                }
                ChooseResourceDialog.this.ensurePickersInitialized();
                if (element == null && ChooseResourceDialog.this.myStateListPicker != null && ChooseResourceDialog.this.myStateListPicker.getStateList() != null && ChooseResourceDialog.this.myStateListPicker.getStateList().getType() == this.myType) {
                    assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                    this.showEditorPanel();
                    this.myEditorPanel.setSelectedTab(ChooseResourceDialog.this.myStateListPickerPanel);
                    return;
                }
                if (element == null && this.myType == ResourceType.COLOR) {
                    assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                    this.showEditorPanel();
                    this.myEditorPanel.setSelectedTab(ChooseResourceDialog.this.myColorPickerPanel);
                    return;
                }
            }
            if (element == null || element.getType() == ResourceType.ID) {
                this.showNoPreview();
                return;
            }
            switch (this.myType) {
                case DRAWABLE: 
                case COLOR: 
                case MIPMAP: {
                    this.showDrawableItem(element);
                    return;
                }
                case STRING: 
                case DIMEN: 
                case BOOL: {
                    this.showTableItem(element);
                    return;
                }
            }
            String doc = AndroidJavaDocRenderer.render(ChooseResourceDialog.this.myModule, ChooseResourceDialog.this.getConfiguration(), element.getType(), element.getName(), element.isFramework());
            if (doc != null) {
                this.showHtml(doc);
            } else {
                this.showNoPreview();
            }
        }

        public void editResourceItem(@NotNull ResourceItem selected) {
            ResourceEditorTab resourceEditorTab;
            if (selected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "editResourceItem"));
            }
            ResourceValue resourceValue = selected.getResourceValue(false);
            assert (resourceValue != null);
            String value = resourceValue.getValue();
            if (value != null && (value.startsWith("@") || value.startsWith("?"))) {
                this.myReferenceComponent.setValueText(value);
                this.updateReferenceSwatchIcon();
                resourceEditorTab = this.myReferencePanel;
            } else {
                ResourceHelper.StateList stateList = ResourceHelper.resolveStateList((RenderResources)ChooseResourceDialog.this.getResourceResolver(), resourceValue, ChooseResourceDialog.this.myModule.getProject());
                if (stateList != null) {
                    ChooseResourceDialog.this.ensurePickersInitialized();
                    assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                    assert (ChooseResourceDialog.this.myStateListPicker != null);
                    if (stateList.getType() != ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType()) {
                        Logger.getInstance(ChooseResourceDialog.class).warn("StateList type mismatch " + stateList.getType() + " " + ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType());
                        this.showPreview(this.getSelectedItem(), false);
                        return;
                    }
                    ChooseResourceDialog.this.myStateListPicker.setStateList(stateList);
                    if (ChooseResourceDialog.this.myStateListPickerPanel.getFullPanel().getParent() == null) {
                        this.myEditorPanel.addTab(ChooseResourceDialog.this.myStateListPickerPanel);
                    }
                    resourceEditorTab = ChooseResourceDialog.this.myStateListPickerPanel;
                } else {
                    Color color = ResourceHelper.parseColor(resourceValue.getValue());
                    if (color != null) {
                        ChooseResourceDialog.this.ensurePickersInitialized();
                        assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                        assert (ChooseResourceDialog.this.myColorPicker != null);
                        ChooseResourceDialog.this.myColorPicker.setColor(color);
                        resourceEditorTab = ChooseResourceDialog.this.myColorPickerPanel;
                    } else {
                        this.showPreview(this.getSelectedItem(), false);
                        return;
                    }
                }
            }
            this.myEditorPanel.setSelectedTab(resourceEditorTab);
            this.setLocationFromResourceItem(selected);
        }

        @Nullable
        public ValidationInfo doValidate() {
            boolean okActionEnabled;
            ValidationInfo error = null;
            ResourceEditorTab editor = this.getCurrentResourceEditor();
            if (editor != null) {
                String overwriteResource = "";
                if (editor.getResourceNameVisibility() == ResourceNameVisibility.FORCE || editor.getResourceNameVisibility() == ResourceNameVisibility.SHOW && !this.myEditorPanel.getResourceName().isEmpty()) {
                    ResourceItem defaultResourceItem;
                    String enteredName;
                    ResourceNameValidator validator = editor.getValidator();
                    if (validator.doesResourceExist(enteredName = this.myEditorPanel.getResourceName())) {
                        ResourceType type = ChooseResourceDialog.this.getSelectedPanel().getType();
                        overwriteResource = String.format("Saving this %1$s will override existing resource %2$s.", type.getDisplayName().toLowerCase(Locale.US), enteredName);
                    } else {
                        String errorText = validator.getErrorText(enteredName);
                        if (errorText != null) {
                            error = new ValidationInfo(errorText, (JComponent)this.myEditorPanel.getResourceNameField());
                        }
                    }
                    if (!overwriteResource.equals(this.myEditorPanel.getResourceNameMessage()) && (defaultResourceItem = this.setupVariants()) != null) {
                        this.setLocationFromResourceItem(defaultResourceItem);
                    }
                }
                if (!overwriteResource.equals(this.myEditorPanel.getResourceNameMessage())) {
                    this.myEditorPanel.setResourceNameMessage(overwriteResource);
                }
                if (error == null) {
                    error = editor.doValidate();
                }
                okActionEnabled = error == null;
            } else {
                okActionEnabled = this.getSelectedItem() != null;
            }
            ChooseResourceDialog.this.setOKActionEnabled(okActionEnabled);
            return error;
        }

        private void setLocationFromResourceItem(@NotNull ResourceItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "setLocationFromResourceItem"));
            }
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(item.getFile());
            assert (file != null);
            for (ResourceEditorTab editor : this.myEditorPanel.getAllTabs()) {
                editor.getLocationSettings().resetFromFile(file, ChooseResourceDialog.this.myModule.getProject());
            }
        }

        @Nullable
        private ResourceItem setupVariants() {
            List resources = AppResourceRepository.getAppResources(ChooseResourceDialog.this.myFacet, true).getResourceItem(this.myType, this.myEditorPanel.getResourceName());
            assert (resources != null);
            ResourceItem defaultValue = (ResourceItem)ChooseResourceDialog.this.getConfiguration().getFullConfig().findMatchingConfigurable(resources);
            if (defaultValue == null && !resources.isEmpty()) {
                defaultValue = (ResourceItem)resources.get(0);
            }
            this.myEditorPanel.setVariant(resources, defaultValue);
            return defaultValue;
        }

        @Nullable
        public ResourceEditorTab getCurrentResourceEditor() {
            return this.myEditorPanel != null && this.myEditorPanel.isVisible() ? this.myEditorPanel.getSelectedTab() : null;
        }

        private boolean supportsGridMode() {
            return this.myType == ResourceType.COLOR || this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.MIPMAP;
        }

        private void configureList(boolean gridView) {
            if (this.myList == null) {
                return;
            }
            if (gridView && this.supportsGridMode()) {
                DefaultListCellRenderer gridRenderer = new DefaultListCellRenderer(){
                    private final int CHAR_WIDTH;
                    private final int CHARS_PER_CELL;
                    {
                        this.setHorizontalTextPosition(0);
                        this.setVerticalTextPosition(3);
                        this.setHorizontalAlignment(0);
                        this.CHAR_WIDTH = this.getFontMetrics(this.getFont()).charWidth('x');
                        this.CHARS_PER_CELL = GRID_CELL_SIZE / this.CHAR_WIDTH;
                    }

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        DefaultListCellRenderer component = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, false);
                        final Border border = component.getBorder();
                        component.setBorder(new AbstractBorder(){

                            @Override
                            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                                border.paintBorder(c, g, x, y, width, height);
                            }
                        });
                        ResourceChooserItem rItem = (ResourceChooserItem)value;
                        this.setIcon(ChooseResourceDialog.this.getIcon(rItem, GRID_ICON_SIZE, GRID_CHECK_SIZE));
                        String name = rItem.getName();
                        String filter = ChooseResourceDialog.this.mySearchField.getText();
                        int match = -1;
                        if (!filter.isEmpty()) {
                            match = StringUtil.indexOfIgnoreCase((String)name, (String)filter, (int)0);
                        }
                        int breakPoint = -1;
                        if (name.length() > this.CHARS_PER_CELL) {
                            breakPoint = name.indexOf(95, this.CHARS_PER_CELL / 2);
                            breakPoint = breakPoint == -1 || breakPoint >= this.CHARS_PER_CELL || name.length() - breakPoint >= this.CHARS_PER_CELL ? this.CHARS_PER_CELL : ++breakPoint;
                        }
                        if (match != -1 || breakPoint != -1) {
                            HtmlBuilder builder = new HtmlBuilder();
                            builder.openHtmlBody();
                            builder.beginNoBr();
                            if (match == -1) {
                                builder.add(name, 0, breakPoint);
                                builder.newline();
                                builder.add(name, breakPoint, name.length());
                            } else if (breakPoint == -1) {
                                builder.add(name, 0, match);
                                builder.beginColor((Color)JBColor.BLUE);
                                builder.beginBold();
                                builder.add(name, match, match + filter.length());
                                builder.endBold();
                                builder.endColor();
                                builder.add(name, match + filter.length(), name.length());
                            } else {
                                if (breakPoint < match) {
                                    builder.add(name, 0, breakPoint);
                                    builder.newline();
                                    builder.add(name, breakPoint, match);
                                } else {
                                    builder.add(name, 0, match);
                                }
                                builder.beginColor((Color)JBColor.BLUE);
                                builder.beginBold();
                                builder.add(name, match, match + filter.length());
                                builder.endBold();
                                builder.endColor();
                                if (breakPoint >= match && breakPoint < match + filter.length()) {
                                    builder.newline();
                                    builder.add(name, match + filter.length(), name.length());
                                } else if (match < breakPoint) {
                                    builder.add(name, match + filter.length(), breakPoint);
                                    builder.newline();
                                    builder.add(name, breakPoint, name.length());
                                }
                            }
                            builder.endNoBr();
                            builder.closeHtmlBody();
                            component.setText(builder.getHtml());
                        }
                        return component;
                    }
                };
                this.myList.setFixedCellWidth(GRID_CELL_SIZE);
                this.myList.setFixedCellHeight(GRID_CELL_SIZE);
                this.myList.setCellRenderer(gridRenderer);
                this.myList.setLayoutOrientation(2);
            } else {
                ColoredListCellRenderer<ResourceChooserItem> listRenderer = new ColoredListCellRenderer<ResourceChooserItem>(){

                    protected void customizeCellRenderer(JList list, ResourceChooserItem value, int index, boolean selected, boolean hasFocus) {
                        if (!hasFocus) {
                            this.setBorder(new AbstractBorder(){

                                @Override
                                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                                    Color oldColor = g.getColor();
                                    g.setColor((Color)LIST_DIVIDER_COLOR);
                                    int thickness = 1;
                                    g.fillRect(x, y + height - thickness, width, thickness);
                                    g.setColor(oldColor);
                                }
                            });
                        } else {
                            final Border border = this.getBorder();
                            this.setBorder(new AbstractBorder(){

                                @Override
                                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                                    border.paintBorder(c, g, x, y, width, height);
                                }
                            });
                        }
                        this.setIpad((Insets)LIST_PADDING);
                        this.setIcon(ChooseResourceDialog.this.getIcon(value, LIST_ICON_SIZE, LIST_CHECK_SIZE));
                        String string = value.toString();
                        String filter = ChooseResourceDialog.this.mySearchField.getText();
                        if (!filter.isEmpty()) {
                            int match = StringUtil.indexOfIgnoreCase((String)string, (String)filter, (int)0);
                            if (match != -1) {
                                this.append(string.substring(0, match));
                                this.append(string.substring(match, match + filter.length()), SEARCH_MATCH_ATTRIBUTES);
                                this.append(string.substring(match + filter.length()));
                            } else {
                                this.append(string);
                            }
                        } else {
                            this.append(string);
                        }
                    }
                };
                this.myList.setFixedCellWidth(10);
                this.myList.setFixedCellHeight(LIST_CELL_HEIGHT);
                this.myList.setCellRenderer((ListCellRenderer<ResourceChooserItem>)listRenderer);
                this.myList.setLayoutOrientation(0);
            }
        }

        private void showNewResource(@NotNull ResourceEditorTab tab) {
            if (tab == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tab", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "showNewResource"));
            }
            this.setSelectedItem(null);
            this.showEditorPanel();
            this.myEditorPanel.setSelectedTab(tab);
            this.myEditorPanel.setResourceName("");
            for (ResourceEditorTab editor : this.myEditorPanel.getAllTabs()) {
                editor.getLocationSettings().resetToDefault();
            }
        }

        private boolean select(@NotNull ResourceValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel", "select"));
            }
            boolean isAttr = value instanceof ItemResourceValue;
            for (ResourceChooserGroup group : this.myGroups) {
                for (ResourceChooserItem item : group.getItems()) {
                    if (isAttr) {
                        if (!item.isAttr() || ((ItemResourceValue)value).isFrameworkAttr() != item.isFramework() || !value.getName().equals(item.getName())) continue;
                        this.setSelectedItem(item);
                        return true;
                    }
                    if (item.isAttr() || value.isFramework() != item.isFramework() || !value.getName().equals(item.getName())) continue;
                    this.setSelectedItem(item);
                    return true;
                }
            }
            return false;
        }

        public void expandAll() {
            if (this.myList != null) {
                this.myList.expandAll();
            }
        }

        public ResourceChooserItem getSelectedItem() {
            Object selected;
            int index;
            if (this.myList != null) {
                return this.myList.getSelectedElement();
            }
            if (this.myTable != null && (index = this.myTable.getSelectionModel().getLeadSelectionIndex()) != -1 && (selected = this.myTable.getValueAt(index, 0)) instanceof ResourceChooserItem) {
                return (ResourceChooserItem)selected;
            }
            return null;
        }

        public void setSelectedItem(@Nullable ResourceChooserItem item) {
            if (this.myList != null) {
                this.myList.setSelectedElement(item);
            } else if (this.myTable != null) {
                TableModel model = this.myTable.getModel();
                int rowCount = model.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    Object object = model.getValueAt(row, 0);
                    if (object != item) continue;
                    this.myTable.getSelectionModel().setSelectionInterval(row, row);
                    Rectangle cellRect = this.myTable.getCellRect(row, 0, true);
                    this.myTable.scrollRectToVisible(cellRect);
                    break;
                }
            }
        }

        @Nullable
        public String getValueForLivePreview() {
            if (this.myType == ResourceType.COLOR && ChooseResourceDialog.this.myColorPicker != null && ChooseResourceDialog.this.myColorPicker.isShowing()) {
                return ResourceHelper.colorToString(ChooseResourceDialog.this.myColorPicker.getColor());
            }
            ResourceChooserItem item = this.getSelectedItem();
            return item != null ? item.getResourceUrl() : null;
        }
    }

    public static enum ResourceNameVisibility {
        SHOW,
        FORCE;

    }

    public static interface ResourcePickerListener {
        public void resourceChanged(@Nullable String var1);
    }

    public static class Builder {
        private Module myModule;
        private Configuration myConfiguration;
        private XmlTag myTag;
        private XmlFile myFile;
        private boolean myIsFrameworkValue;
        private String myCurrentValue;
        private EnumSet<ResourceType> myTypes;
        private ResourceNameVisibility myResourceNameVisibility = ResourceNameVisibility.SHOW;
        private String myResourceNameSuggestion;
        private boolean myHideLeftSideActions;

        public Builder setModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$Builder", "setModule"));
            }
            this.myModule = module;
            return this;
        }

        public Builder setTag(@Nullable XmlTag tag) {
            this.myTag = tag;
            if (this.myTag != null && this.myFile == null) {
                this.myFile = (XmlFile)this.myTag.getContainingFile();
            }
            return this;
        }

        public Builder setFile(@Nullable XmlFile file) {
            this.myFile = file;
            return this;
        }

        public Builder setIsFrameworkValue(boolean frameworkValue) {
            this.myIsFrameworkValue = frameworkValue;
            return this;
        }

        public Builder setCurrentValue(@Nullable String currentValue) {
            this.myCurrentValue = currentValue;
            return this;
        }

        public Builder setTypes(@NotNull EnumSet<ResourceType> types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$Builder", "setTypes"));
            }
            this.myTypes = types;
            return this;
        }

        public Builder setResourceNameVisibility(@NotNull ResourceNameVisibility resourceNameVisibility) {
            if (resourceNameVisibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNameVisibility", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$Builder", "setResourceNameVisibility"));
            }
            this.myResourceNameVisibility = resourceNameVisibility;
            return this;
        }

        public Builder setResourceNameSuggestion(@Nullable String resourceNameSuggestion) {
            if (resourceNameSuggestion != null && (resourceNameSuggestion.startsWith("@") || resourceNameSuggestion.startsWith("?") || resourceNameSuggestion.startsWith("#"))) {
                throw new IllegalArgumentException("invalid name suggestion " + resourceNameSuggestion);
            }
            this.myResourceNameSuggestion = resourceNameSuggestion;
            return this;
        }

        public Builder setHideLeftSideActions(boolean hideLeftSideActions) {
            this.myHideLeftSideActions = hideLeftSideActions;
            return this;
        }

        public Builder setConfiguration(@Nullable Configuration configuration) {
            this.myConfiguration = configuration;
            return this;
        }

        public ChooseResourceDialog build() {
            Configuration configuration = this.myConfiguration;
            AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
            assert (facet != null);
            if (configuration == null) {
                if (this.myFile != null && this.myFile.getVirtualFile() != null) {
                    ConfigurationManager configurationManager = facet.getConfigurationManager();
                    configuration = configurationManager.getConfiguration(this.myFile.getVirtualFile());
                }
                if (configuration == null) {
                    configuration = ThemeEditorUtils.getConfigurationForModule(this.myModule);
                }
            }
            return new ChooseResourceDialog(facet, configuration, this.myTag, this.myTypes, this.myCurrentValue, this.myIsFrameworkValue, this.myResourceNameVisibility, this.myResourceNameSuggestion, this.myHideLeftSideActions);
        }
    }
}

