/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.expressions.bool.IsEqualToExpression;
import com.google.common.collect.Lists;
import com.intellij.util.containers.UnsafeWeakList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObservableValue<T>
implements ObservableValue<T> {
    private final List<InvalidationListener> myListeners = Lists.newArrayListWithCapacity((int)0);
    private final UnsafeWeakList<InvalidationListener> myWeakListeners = new UnsafeWeakList(0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/AbstractObservableValue", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public final void removeListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/AbstractObservableValue", "removeListener"));
        }
        this.myListeners.remove(listener);
        this.myWeakListeners.remove((Object)listener);
    }

    @Override
    public final void addWeakListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/AbstractObservableValue", "addWeakListener"));
        }
        this.myWeakListeners.add((Object)listener);
    }

    @Override
    @NotNull
    public final <S> Expression<S> transform(final @NotNull Function<T, S> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/android/tools/idea/ui/properties/AbstractObservableValue", "transform"));
        }
        Expression expression = new Expression<S>(new ObservableValue[]{this}){

            @Override
            @NotNull
            public S get() {
                Object r = function.apply(AbstractObservableValue.this.get());
                if (r == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/AbstractObservableValue$1", "get"));
                }
                return r;
            }
        };
        if (expression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/AbstractObservableValue", "transform"));
        }
        return expression;
    }

    @Override
    @NotNull
    public final ObservableBool isEqualTo(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/AbstractObservableValue", "isEqualTo"));
        }
        IsEqualToExpression<T> isEqualToExpression = new IsEqualToExpression<T>(this, value);
        if (isEqualToExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/AbstractObservableValue", "isEqualTo"));
        }
        return isEqualToExpression;
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        for (InvalidationListener listener : this.myListeners) {
            listener.onInvalidated(this);
        }
        for (InvalidationListener listener : this.myWeakListeners) {
            listener.onInvalidated(this);
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }
}

