/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.tools.idea.actions.NewAndroidComponentAction;
import com.android.tools.idea.npw.NewAndroidActivityWizard;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.io.Files;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.ZipUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class TemplateManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + TemplateManager.class.getName()));
    private static final String BUNDLED_TEMPLATE_PATH = "/plugins/android/lib/templates";
    private static final String[] DEVELOPMENT_TEMPLATE_PATHS = new String[]{"/../../tools/base/templates", "/android/tools-base/templates", "/community/android/tools-base/templates"};
    private static final String EXPLODED_AAR_PATH = "build/intermediates/exploded-aar";
    public static final String CATEGORY_OTHER = "Other";
    private static final String CATEGORY_ACTIVITY = "Activity";
    private static final String ACTION_ID_PREFIX = "template.create.";
    private static final boolean USE_SDK_TEMPLATES = false;
    private static final Set<String> EXCLUDED_CATEGORIES = ImmutableSet.of((Object)"Application", (Object)"Applications");
    public static final Set<String> EXCLUDED_TEMPLATES = ImmutableSet.of();
    private static final String TEMPLATE_ZIP_NAME = "templates.zip";
    private Map<File, TemplateMetadata> myTemplateMap;
    private Table<String, String, File> myCategoryTable;
    private File myAarCache;
    private static TemplateManager ourInstance = new TemplateManager();
    private DefaultActionGroup myTopGroup;

    private TemplateManager() {
    }

    public static TemplateManager getInstance() {
        return ourInstance;
    }

    @Nullable
    public static File getTemplateRootFolder() {
        File location;
        File folder;
        File rootFile;
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + BUNDLED_TEMPLATE_PATH)));
        if (root == null) {
            for (String path : DEVELOPMENT_TEMPLATE_PATHS) {
                root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + path)));
                if (root != null) break;
            }
        }
        if (root != null && TemplateManager.templateRootIsValid(rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root))) {
            return rootFile;
        }
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData != null && (folder = new File(location = sdkData.getLocation(), "tools" + File.separator + "templates")).isDirectory()) {
            return folder;
        }
        return null;
    }

    @NotNull
    public static List<File> getExtraTemplateRootFolders() {
        ArrayList<File> folders = new ArrayList<File>();
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData != null) {
            String[] addOns;
            File location = sdkData.getLocation();
            File extras = new File(location, "extras");
            if (extras.isDirectory()) {
                for (File vendor : TemplateUtils.listFiles(extras)) {
                    if (!vendor.isDirectory()) continue;
                    for (File pkg : TemplateUtils.listFiles(vendor)) {
                        File folder;
                        if (!pkg.isDirectory() || !(folder = new File(pkg, "templates")).isDirectory()) continue;
                        folders.add(folder);
                    }
                }
                File folder = new File(extras, "templates");
                if (folder.isDirectory()) {
                    folders.add(folder);
                }
            }
            if ((addOns = new File(location, "add-ons")).isDirectory()) {
                File[] fileArray = TemplateUtils.listFiles((File)addOns);
                int n = fileArray.length;
                for (int vendor = 0; vendor < n; ++vendor) {
                    File folder;
                    File addOn = fileArray[vendor];
                    if (!addOn.isDirectory() || !(folder = new File(addOn, "templates")).isDirectory()) continue;
                    folders.add(folder);
                }
            }
        }
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + BUNDLED_TEMPLATE_PATH)));
        if (root == null) {
            for (String path : DEVELOPMENT_TEMPLATE_PATHS) {
                root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + path)));
                if (root != null) break;
            }
        }
        if (root == null) {
            LOG.error("Templates not found in: " + homePath + BUNDLED_TEMPLATE_PATH + " or " + homePath + Arrays.toString(DEVELOPMENT_TEMPLATE_PATHS));
        } else {
            File templateDir = new File(root.getCanonicalPath()).getAbsoluteFile();
            if (templateDir.isDirectory()) {
                folders.add(templateDir);
            }
        }
        ArrayList<File> arrayList = folders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getExtraTemplateRootFolders"));
        }
        return arrayList;
    }

    @NotNull
    public List<File> getTemplates(@NotNull String folder) {
        File[] files;
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/TemplateManager", "getTemplates"));
        }
        ArrayList<File> templates = new ArrayList<File>();
        HashMap templateNames = Maps.newHashMap();
        File root = TemplateManager.getTemplateRootFolder();
        if (root != null && (files = new File(root, folder).listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory() || !new File(file, "template.xml").exists()) continue;
                templates.add(file);
                templateNames.put(file.getName(), file);
            }
        }
        for (File extra : TemplateManager.getExtraTemplateRootFolders()) {
            for (File file : TemplateUtils.listFiles(new File(extra, folder))) {
                if (!file.isDirectory() || !new File(file, "template.xml").exists()) continue;
                File replaces = (File)templateNames.get(file.getName());
                if (replaces != null) {
                    int compare = this.compareTemplates(replaces, file);
                    if (compare <= 0) continue;
                    int index = templates.indexOf(replaces);
                    if (index != -1) {
                        templates.set(index, file);
                        continue;
                    }
                    templates.add(file);
                    continue;
                }
                templates.add(file);
            }
        }
        if (templates.size() > 1) {
            Collections.sort(templates, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return file1.getName().compareTo(file2.getName());
                }
            });
        }
        ArrayList<File> arrayList = templates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getTemplates"));
        }
        return arrayList;
    }

    @NotNull
    public static List<File> getTemplatesFromDirectory(@NotNull File externalDirectory, boolean recursive) {
        File[] files;
        if (externalDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalDirectory", "com/android/tools/idea/templates/TemplateManager", "getTemplatesFromDirectory"));
        }
        ArrayList templates = Lists.newArrayList();
        if (new File(externalDirectory, "template.xml").exists()) {
            templates.add(externalDirectory);
        }
        if (recursive && (files = externalDirectory.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                templates.addAll(TemplateManager.getTemplatesFromDirectory(file, true));
            }
        }
        ArrayList arrayList = templates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getTemplatesFromDirectory"));
        }
        return arrayList;
    }

    @NotNull
    public List<File> getTemplateDirectoriesFromAars(@Nullable Project project) {
        ArrayList templateDirectories = Lists.newArrayList();
        if (project != null && project.getBaseDir() != null) {
            File aarRoot;
            if (this.myAarCache == null) {
                String prefix = project.getName();
                String suffix = "aar_cache";
                try {
                    this.myAarCache = FileUtil.createTempDirectory((String)prefix, (String)suffix);
                }
                catch (IOException e) {
                    LOG.error(String.format("Problem trying to create temp directory with prefix: '%1$s' suffix: '%2$s' path: '%3$s'", prefix, suffix, FileUtil.getTempDirectory()), (Throwable)e);
                    ArrayList arrayList = templateDirectories;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getTemplateDirectoriesFromAars"));
                    }
                    return arrayList;
                }
            }
            if ((aarRoot = new File(project.getBaseDir().getPath(), FileUtil.toSystemDependentName((String)EXPLODED_AAR_PATH))).isDirectory()) {
                for (File artifactPackage : TemplateUtils.listFiles(aarRoot)) {
                    if (!artifactPackage.isDirectory() || artifactPackage.isHidden()) continue;
                    for (File artifactName : TemplateUtils.listFiles(artifactPackage)) {
                        if (!artifactName.isDirectory() || artifactName.isHidden()) continue;
                        templateDirectories.addAll(this.getHighestVersionedTemplateRoot(artifactName));
                    }
                }
            }
        }
        ArrayList arrayList = templateDirectories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getTemplateDirectoriesFromAars"));
        }
        return arrayList;
    }

    @NotNull
    private List<File> getHighestVersionedTemplateRoot(@NotNull File artifactNameRoot) {
        if (artifactNameRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactNameRoot", "com/android/tools/idea/templates/TemplateManager", "getHighestVersionedTemplateRoot"));
        }
        ArrayList templateDirectories = Lists.newArrayList();
        File highestVersionDir = null;
        Revision highestVersionNumber = null;
        for (File versionDir : TemplateUtils.listFiles(artifactNameRoot)) {
            Revision revision;
            if (!versionDir.isDirectory() || versionDir.isHidden()) continue;
            try {
                revision = Revision.parseRevision((String)versionDir.getName());
            }
            catch (NumberFormatException e) {
                revision = Revision.NOT_SPECIFIED;
            }
            if (highestVersionNumber != null && revision.compareTo(highestVersionNumber) <= 0) continue;
            highestVersionNumber = revision;
            highestVersionDir = versionDir;
        }
        if (highestVersionDir != null) {
            File zipFile;
            String name = artifactNameRoot.getName() + "-" + highestVersionNumber.toString();
            File inflated = new File(this.myAarCache, name);
            if (!inflated.isDirectory() && (zipFile = new File(highestVersionDir, TEMPLATE_ZIP_NAME)).isFile()) {
                try {
                    ZipUtil.unzip(null, (File)inflated, (File)zipFile, null, null, (boolean)true);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (inflated.isDirectory()) {
                templateDirectories.add(inflated);
            }
        }
        ArrayList arrayList = templateDirectories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getHighestVersionedTemplateRoot"));
        }
        return arrayList;
    }

    @NotNull
    public List<File> getTemplatesInCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/templates/TemplateManager", "getTemplatesInCategory"));
        }
        if (this.getCategoryTable().containsRow((Object)category)) {
            ArrayList arrayList = Lists.newArrayList(this.getCategoryTable().row((Object)category).values());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getTemplatesInCategory"));
            }
            return arrayList;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateManager", "getTemplatesInCategory"));
        }
        return arrayList;
    }

    @Nullable
    public ActionGroup getTemplateCreationMenu(@Nullable Project project) {
        this.refreshDynamicTemplateMenu(project);
        return this.myTopGroup;
    }

    public void refreshDynamicTemplateMenu(@Nullable Project project) {
        if (this.myTopGroup == null) {
            this.myTopGroup = new DefaultActionGroup("AndroidTemplateGroup", false);
        } else {
            this.myTopGroup.removeAll();
        }
        this.myTopGroup.addSeparator();
        ActionManager am = ActionManager.getInstance();
        for (final String category : this.getCategoryTable(true, project).rowKeySet()) {
            if (EXCLUDED_CATEGORIES.contains(category)) continue;
            NonEmptyActionGroup categoryGroup = new NonEmptyActionGroup(){

                public void update(AnActionEvent e) {
                    TemplateManager.updateAction(e, category, this.getChildrenCount() > 0);
                }
            };
            categoryGroup.setPopup(true);
            this.fillCategory(categoryGroup, category, am);
            this.myTopGroup.add((AnAction)categoryGroup);
            TemplateManager.setPresentation(category, (AnAction)categoryGroup);
        }
    }

    private static void updateAction(AnActionEvent event, String text, boolean visible) {
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(event.getDataContext());
        Module module = (Module)LangDataKeys.MODULE.getData(event.getDataContext());
        AndroidFacet facet = module != null ? AndroidFacet.getInstance(module) : null;
        Presentation presentation = event.getPresentation();
        boolean isProjectReady = facet != null && facet.getAndroidModel() != null;
        presentation.setText(text + (isProjectReady ? "" : " (Project not ready)"));
        presentation.setVisible(visible && view != null && facet != null && facet.requiresAndroidModel());
    }

    private void fillCategory(NonEmptyActionGroup categoryGroup, String category, ActionManager am) {
        Map categoryRow = this.myCategoryTable.row((Object)category);
        if (CATEGORY_ACTIVITY.equals(category)) {
            AnAction action = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    DataContext dataContext = e.getDataContext();
                    Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
                    VirtualFile targetFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
                    NewAndroidActivityWizard wizard = new NewAndroidActivityWizard(module, targetFile, null);
                    wizard.init();
                    wizard.show();
                }

                public void update(AnActionEvent e) {
                    TemplateManager.updateAction(e, "Gallery...", true);
                }
            };
            categoryGroup.add(action);
            categoryGroup.addSeparator();
            TemplateManager.setPresentation(category, action);
        }
        for (String templateName : categoryRow.keySet()) {
            if (EXCLUDED_TEMPLATES.contains(templateName)) continue;
            TemplateMetadata metadata = this.getTemplateMetadata((File)this.myCategoryTable.get((Object)category, (Object)templateName));
            NewAndroidComponentAction templateAction = new NewAndroidComponentAction(category, templateName, metadata);
            String actionId = ACTION_ID_PREFIX + category + templateName;
            am.unregisterAction(actionId);
            am.registerAction(actionId, (AnAction)templateAction);
            categoryGroup.add((AnAction)templateAction);
        }
    }

    private static void setPresentation(String category, AnAction categoryGroup) {
        Presentation presentation = categoryGroup.getTemplatePresentation();
        presentation.setIcon(AndroidIcons.Android);
        presentation.setText(category);
    }

    private Table<String, String, File> getCategoryTable() {
        return this.getCategoryTable(false, null);
    }

    private Table<String, String, File> getCategoryTable(boolean forceReload, @Nullable Project project) {
        if (this.myCategoryTable == null || forceReload) {
            if (this.myTemplateMap != null) {
                this.myTemplateMap.clear();
            }
            this.myCategoryTable = TreeBasedTable.create();
            for (File categoryDirectory : TemplateUtils.listFiles(TemplateManager.getTemplateRootFolder())) {
                for (File newTemplate : TemplateUtils.listFiles(categoryDirectory)) {
                    this.addTemplateToTable(newTemplate);
                }
            }
            for (File rootDirectory : TemplateManager.getExtraTemplateRootFolders()) {
                for (File categoryDirectory : TemplateUtils.listFiles(rootDirectory)) {
                    for (File newTemplate : TemplateUtils.listFiles(categoryDirectory)) {
                        this.addTemplateToTable(newTemplate);
                    }
                }
            }
            for (File aarDirectory : this.getTemplateDirectoriesFromAars(project)) {
                for (File newTemplate : TemplateUtils.listFiles(aarDirectory)) {
                    this.addTemplateToTable(newTemplate);
                }
            }
        }
        return this.myCategoryTable;
    }

    private void addTemplateToTable(@NotNull File newTemplate) {
        if (newTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTemplate", "com/android/tools/idea/templates/TemplateManager", "addTemplateToTable"));
        }
        TemplateMetadata newMetadata = this.getTemplateMetadata(newTemplate);
        if (newMetadata != null) {
            String title = newMetadata.getTitle();
            if (title == null || newMetadata.getCategory() == null && this.myCategoryTable.columnKeySet().contains(title) && this.myCategoryTable.get((Object)CATEGORY_OTHER, (Object)title) == null) {
                return;
            }
            String category = newMetadata.getCategory() != null ? newMetadata.getCategory() : CATEGORY_OTHER;
            File existingTemplate = (File)this.myCategoryTable.get((Object)category, (Object)title);
            if (existingTemplate == null || this.compareTemplates(existingTemplate, newTemplate) > 0) {
                this.myCategoryTable.put((Object)category, (Object)title, (Object)newTemplate);
            }
        }
    }

    private int compareTemplates(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/android/tools/idea/templates/TemplateManager", "compareTemplates"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/android/tools/idea/templates/TemplateManager", "compareTemplates"));
        }
        TemplateMetadata template1 = this.getTemplateMetadata(file1);
        TemplateMetadata template2 = this.getTemplateMetadata(file2);
        if (template1 == null) {
            return 1;
        }
        if (template2 == null) {
            return -1;
        }
        int delta = template2.getRevision() - template1.getRevision();
        if (delta == 0) {
            delta = (int)(file2.lastModified() - file1.lastModified());
        }
        return delta;
    }

    @Nullable
    public File getTemplateFile(@Nullable String category, @Nullable String templateName) {
        return (File)this.getCategoryTable().get((Object)category, (Object)templateName);
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata(@Nullable String category, @Nullable String templateName) {
        File templateDir = this.getTemplateFile(category, templateName);
        return templateDir != null ? this.getTemplateMetadata(templateDir) : null;
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata(@NotNull File templateRoot) {
        if (templateRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRoot", "com/android/tools/idea/templates/TemplateManager", "getTemplateMetadata"));
        }
        if (this.myTemplateMap != null) {
            TemplateMetadata metadata = this.myTemplateMap.get(templateRoot);
            if (metadata != null) {
                return metadata;
            }
        } else {
            this.myTemplateMap = Maps.newHashMap();
        }
        try {
            String xml;
            Document doc;
            File templateFile = new File(templateRoot, "template.xml");
            if (templateFile.isFile() && (doc = XmlUtils.parseDocumentSilently((String)(xml = Files.toString((File)templateFile, (Charset)Charsets.UTF_8)), (boolean)true)) != null && doc.getDocumentElement() != null) {
                TemplateMetadata metadata = new TemplateMetadata(doc);
                this.myTemplateMap.put(templateRoot, metadata);
                return metadata;
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    public static boolean templatesAreValid() {
        try {
            File templateRootFolder = TemplateManager.getTemplateRootFolder();
            if (templateRootFolder == null) {
                return false;
            }
            return TemplateManager.templateRootIsValid(templateRootFolder);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File getWrapperLocation(@NotNull File templateRootFolder) {
        if (templateRootFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRootFolder", "com/android/tools/idea/templates/TemplateManager", "getWrapperLocation"));
        }
        return new File(templateRootFolder, SdkConstants.FD_GRADLE_WRAPPER);
    }

    public static boolean templateRootIsValid(@NotNull File templateRootFolder) {
        if (templateRootFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRootFolder", "com/android/tools/idea/templates/TemplateManager", "templateRootIsValid"));
        }
        return new File(TemplateManager.getWrapperLocation(templateRootFolder), "gradlew").exists();
    }
}

